/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.MessageCreateFields;
import discord4j.core.spec.MessageCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="MessageCreateMonoGenerator", generator="Immutables")
public final class MessageCreateMono
extends MessageCreateMonoGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final String nonce_value;
    private final boolean nonce_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final List<MessageCreateFields.File> files;
    private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final Snowflake messageReference_value;
    private final boolean messageReference_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private final MessageChannel channel;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private MessageCreateMono(MessageChannel channel) {
        this.channel = Objects.requireNonNull(channel, "channel");
        Possible content$impl = Possible.absent();
        Possible nonce$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible messageReference$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    private MessageCreateMono(Possible<String> content, Possible<String> nonce, Possible<Boolean> tts, Possible<List<EmbedCreateSpec>> embeds, List<MessageCreateFields.File> files, List<MessageCreateFields.FileSpoiler> fileSpoilers, Possible<AllowedMentions> allowedMentions, Possible<Snowflake> messageReference, Possible<List<LayoutComponent>> components, MessageChannel channel) {
        Possible<String> content$impl = content;
        Possible<String> nonce$impl = nonce;
        Possible<Boolean> tts$impl = tts;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        this.initShim.files(files);
        this.initShim.fileSpoilers(fileSpoilers);
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<Snowflake> messageReference$impl = messageReference;
        Possible<List<LayoutComponent>> components$impl = components;
        this.channel = channel;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.nonce_value = nonce$impl.toOptional().orElse(null);
        this.nonce_absent = nonce$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.messageReference_value = messageReference$impl.toOptional().orElse(null);
        this.messageReference_absent = messageReference$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.files = this.initShim.files();
        this.fileSpoilers = this.initShim.fileSpoilers();
        this.initShim = null;
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<String> nonce() {
        return this.nonce_absent ? Possible.absent() : Possible.of((Object)this.nonce_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public List<MessageCreateFields.File> files() {
        InitShim shim = this.initShim;
        return shim != null ? shim.files() : this.files;
    }

    @Override
    public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fileSpoilers() : this.fileSpoilers;
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<Snowflake> messageReference() {
        return this.messageReference_absent ? Possible.absent() : Possible.of((Object)this.messageReference_value);
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    @Override
    public MessageChannel channel() {
        return this.channel;
    }

    public MessageCreateMono withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(newValue, this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono((Possible<String>)newValue, this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withNonce(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withNonce(String value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), (Possible<String>)newValue, this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), (Possible<Boolean>)newValue, this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    @SafeVarargs
    public final MessageCreateMono withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), (Possible<List<EmbedCreateSpec>>)newValue, this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public final MessageCreateMono withFiles(MessageCreateFields.File ... elements) {
        List<MessageCreateFields.File> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public final MessageCreateMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
        if (this.files == elements) {
            return this;
        }
        List<MessageCreateFields.File> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(elements, true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), newValue, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public final MessageCreateMono withFileSpoilers(MessageCreateFields.FileSpoiler ... elements) {
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public final MessageCreateMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
        if (this.fileSpoilers == elements) {
            return this;
        }
        List<MessageCreateFields.FileSpoiler> newValue = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(elements, true, false));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, newValue, this.allowedMentions(), this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, newValue, this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, (Possible<AllowedMentions>)newValue, this.messageReference(), this.components(), this.channel);
    }

    public MessageCreateMono withMessageReference(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), newValue, this.components(), this.channel);
    }

    public MessageCreateMono withMessageReference(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), (Possible<Snowflake>)newValue, this.components(), this.channel);
    }

    public MessageCreateMono withComponents(Possible<List<LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), newValue, this.channel);
    }

    public MessageCreateMono withComponents(Iterable<LayoutComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), (Possible<List<LayoutComponent>>)newValue, this.channel);
    }

    @SafeVarargs
    public final MessageCreateMono withComponents(LayoutComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), (Possible<List<LayoutComponent>>)newValue, this.channel);
    }

    public final MessageCreateMono withChannel(MessageChannel value) {
        if (this.channel == value) {
            return this;
        }
        MessageChannel newValue = Objects.requireNonNull(value, "channel");
        return new MessageCreateMono(this.content(), this.nonce(), this.tts(), this.embeds(), this.files, this.fileSpoilers, this.allowedMentions(), this.messageReference(), this.components(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof MessageCreateMono && this.equalTo(0, (MessageCreateMono)another);
    }

    private boolean equalTo(int synthetic, MessageCreateMono another) {
        return this.content().equals(another.content()) && this.nonce().equals(another.nonce()) && this.tts().equals(another.tts()) && Objects.equals(this.embeds_value, another.embeds_value) && this.files.equals(another.files) && this.fileSpoilers.equals(another.fileSpoilers) && this.allowedMentions().equals(another.allowedMentions()) && this.messageReference().equals(another.messageReference()) && Objects.equals(this.components_value, another.components_value) && this.channel.equals(another.channel);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.nonce().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.files.hashCode();
        h += (h << 5) + this.fileSpoilers.hashCode();
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + this.messageReference().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        h += (h << 5) + this.channel.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "MessageCreateMono{content=" + this.content().toString() + ", nonce=" + this.nonce().toString() + ", tts=" + this.tts().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", files=" + this.files + ", fileSpoilers=" + this.fileSpoilers + ", allowedMentions=" + this.allowedMentions().toString() + ", messageReference=" + this.messageReference().toString() + ", components=" + Objects.toString(this.components_value) + ", channel=" + this.channel + "}";
    }

    public static MessageCreateMono of(MessageChannel channel) {
        return new MessageCreateMono(channel);
    }

    static MessageCreateMono copyOf(MessageCreateMonoGenerator instance) {
        if (instance instanceof MessageCreateMono) {
            return (MessageCreateMono)instance;
        }
        return MessageCreateMono.of(instance.channel()).withContent((Possible<String>)instance.content()).withNonce((Possible<String>)instance.nonce()).withTts((Possible<Boolean>)instance.tts()).withEmbeds((Possible<List<EmbedCreateSpec>>)instance.embeds()).withFiles(instance.files()).withFileSpoilers(instance.fileSpoilers()).withAllowedMentions((Possible<AllowedMentions>)instance.allowedMentions()).withMessageReference((Possible<Snowflake>)instance.messageReference()).withComponents((Possible<List<LayoutComponent>>)instance.components());
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isNoncePresent() {
        return !this.nonce_absent;
    }

    public String nonceOrElse(String defaultValue) {
        return !this.nonce_absent ? this.nonce_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isMessageReferencePresent() {
        return !this.messageReference_absent;
    }

    public Snowflake messageReferenceOrElse(Snowflake defaultValue) {
        return !this.messageReference_absent ? this.messageReference_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="MessageCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private byte filesBuildStage = 0;
        private List<MessageCreateFields.File> files;
        private byte fileSpoilersBuildStage = 0;
        private List<MessageCreateFields.FileSpoiler> fileSpoilers;

        private InitShim() {
        }

        List<MessageCreateFields.File> files() {
            if (this.filesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.filesBuildStage == 0) {
                this.filesBuildStage = (byte)-1;
                this.files = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(MessageCreateMono.super.files(), true, false));
                this.filesBuildStage = 1;
            }
            return this.files;
        }

        void files(List<MessageCreateFields.File> files) {
            this.files = files;
            this.filesBuildStage = 1;
        }

        List<MessageCreateFields.FileSpoiler> fileSpoilers() {
            if (this.fileSpoilersBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fileSpoilersBuildStage == 0) {
                this.fileSpoilersBuildStage = (byte)-1;
                this.fileSpoilers = MessageCreateMono.createUnmodifiableList(false, MessageCreateMono.createSafeList(MessageCreateMono.super.fileSpoilers(), true, false));
                this.fileSpoilersBuildStage = 1;
            }
            return this.fileSpoilers;
        }

        void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
            this.fileSpoilers = fileSpoilers;
            this.fileSpoilersBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.filesBuildStage == -1) {
                attributes.add("files");
            }
            if (this.fileSpoilersBuildStage == -1) {
                attributes.add("fileSpoilers");
            }
            return "Cannot build MessageCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

