/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.object.Invite;
import discord4j.core.spec.InviteCreateSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="InviteCreateSpecGenerator", generator="Immutables")
public final class InviteCreateSpec
implements InviteCreateSpecGenerator {
    @Nullable
    private final String reason;
    private final Integer maxAge_value;
    private final boolean maxAge_absent;
    private final Integer maxUses_value;
    private final boolean maxUses_absent;
    private final Boolean temporary_value;
    private final boolean temporary_absent;
    private final Boolean unique_value;
    private final boolean unique_absent;
    private final Invite.Type targetType_value;
    private final boolean targetType_absent;
    private final Snowflake targetUserId_value;
    private final boolean targetUserId_absent;
    private final Snowflake targetApplicationId_value;
    private final boolean targetApplicationId_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final InviteCreateSpec INSTANCE = InviteCreateSpec.validate(new InviteCreateSpec());

    private InviteCreateSpec() {
        this.reason = null;
        Possible maxAge$impl = Possible.absent();
        Possible maxUses$impl = Possible.absent();
        Possible temporary$impl = Possible.absent();
        Possible unique$impl = Possible.absent();
        Possible targetType$impl = Possible.absent();
        Possible targetUserId$impl = Possible.absent();
        Possible targetApplicationId$impl = Possible.absent();
        this.maxAge_value = maxAge$impl.toOptional().orElse(null);
        this.maxAge_absent = maxAge$impl.isAbsent();
        this.maxUses_value = maxUses$impl.toOptional().orElse(null);
        this.maxUses_absent = maxUses$impl.isAbsent();
        this.temporary_value = temporary$impl.toOptional().orElse(null);
        this.temporary_absent = temporary$impl.isAbsent();
        this.unique_value = unique$impl.toOptional().orElse(null);
        this.unique_absent = unique$impl.isAbsent();
        this.targetType_value = targetType$impl.toOptional().orElse(null);
        this.targetType_absent = targetType$impl.isAbsent();
        this.targetUserId_value = targetUserId$impl.toOptional().orElse(null);
        this.targetUserId_absent = targetUserId$impl.isAbsent();
        this.targetApplicationId_value = targetApplicationId$impl.toOptional().orElse(null);
        this.targetApplicationId_absent = targetApplicationId$impl.isAbsent();
        this.initShim = null;
    }

    private InviteCreateSpec(@Nullable String reason, Possible<Integer> maxAge, Possible<Integer> maxUses, Possible<Boolean> temporary, Possible<Boolean> unique, Possible<Invite.Type> targetType, Possible<Snowflake> targetUserId, Possible<Snowflake> targetApplicationId) {
        this.reason = reason;
        Possible<Integer> maxAge$impl = maxAge;
        Possible<Integer> maxUses$impl = maxUses;
        Possible<Boolean> temporary$impl = temporary;
        Possible<Boolean> unique$impl = unique;
        Possible<Invite.Type> targetType$impl = targetType;
        Possible<Snowflake> targetUserId$impl = targetUserId;
        Possible<Snowflake> targetApplicationId$impl = targetApplicationId;
        this.maxAge_value = maxAge$impl.toOptional().orElse(null);
        this.maxAge_absent = maxAge$impl.isAbsent();
        this.maxUses_value = maxUses$impl.toOptional().orElse(null);
        this.maxUses_absent = maxUses$impl.isAbsent();
        this.temporary_value = temporary$impl.toOptional().orElse(null);
        this.temporary_absent = temporary$impl.isAbsent();
        this.unique_value = unique$impl.toOptional().orElse(null);
        this.unique_absent = unique$impl.isAbsent();
        this.targetType_value = targetType$impl.toOptional().orElse(null);
        this.targetType_absent = targetType$impl.isAbsent();
        this.targetUserId_value = targetUserId$impl.toOptional().orElse(null);
        this.targetUserId_absent = targetUserId$impl.isAbsent();
        this.targetApplicationId_value = targetApplicationId$impl.toOptional().orElse(null);
        this.targetApplicationId_absent = targetApplicationId$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<Integer> maxAge() {
        return this.maxAge_absent ? Possible.absent() : Possible.of((Object)this.maxAge_value);
    }

    @Override
    public Possible<Integer> maxUses() {
        return this.maxUses_absent ? Possible.absent() : Possible.of((Object)this.maxUses_value);
    }

    @Override
    public Possible<Boolean> temporary() {
        return this.temporary_absent ? Possible.absent() : Possible.of((Object)this.temporary_value);
    }

    @Override
    public Possible<Boolean> unique() {
        return this.unique_absent ? Possible.absent() : Possible.of((Object)this.unique_value);
    }

    @Override
    public Possible<Invite.Type> targetType() {
        return this.targetType_absent ? Possible.absent() : Possible.of((Object)((Object)this.targetType_value));
    }

    @Override
    public Possible<Snowflake> targetUserId() {
        return this.targetUserId_absent ? Possible.absent() : Possible.of((Object)this.targetUserId_value);
    }

    @Override
    public Possible<Snowflake> targetApplicationId() {
        return this.targetApplicationId_absent ? Possible.absent() : Possible.of((Object)this.targetApplicationId_value);
    }

    public final InviteCreateSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return InviteCreateSpec.validate(new InviteCreateSpec(value, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withMaxAge(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, newValue, this.maxUses(), this.temporary(), this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withMaxAge(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, (Possible<Integer>)newValue, this.maxUses(), this.temporary(), this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withMaxUses(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), newValue, this.temporary(), this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withMaxUses(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), (Possible<Integer>)newValue, this.temporary(), this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withTemporary(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), newValue, this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withTemporary(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), (Possible<Boolean>)newValue, this.unique(), this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withUnique(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), newValue, this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withUnique(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), (Possible<Boolean>)newValue, this.targetType(), this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withTargetType(Possible<Invite.Type> value) {
        Possible<Invite.Type> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), newValue, this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withTargetType(Invite.Type value) {
        Possible newValue = Possible.of((Object)((Object)value));
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), (Possible<Invite.Type>)newValue, this.targetUserId(), this.targetApplicationId()));
    }

    public InviteCreateSpec withTargetUserId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), this.targetType(), newValue, this.targetApplicationId()));
    }

    public InviteCreateSpec withTargetUserId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), this.targetType(), (Possible<Snowflake>)newValue, this.targetApplicationId()));
    }

    public InviteCreateSpec withTargetApplicationId(Possible<Snowflake> value) {
        Possible<Snowflake> newValue = Objects.requireNonNull(value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), this.targetType(), this.targetUserId(), newValue));
    }

    public InviteCreateSpec withTargetApplicationId(Snowflake value) {
        Possible newValue = Possible.of((Object)value);
        return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge(), this.maxUses(), this.temporary(), this.unique(), this.targetType(), this.targetUserId(), (Possible<Snowflake>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InviteCreateSpec && this.equalTo(0, (InviteCreateSpec)another);
    }

    private boolean equalTo(int synthetic, InviteCreateSpec another) {
        return Objects.equals(this.reason, another.reason) && this.maxAge().equals(another.maxAge()) && this.maxUses().equals(another.maxUses()) && this.temporary().equals(another.temporary()) && this.unique().equals(another.unique()) && this.targetType().equals(another.targetType()) && this.targetUserId().equals(another.targetUserId()) && this.targetApplicationId().equals(another.targetApplicationId());
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.maxAge().hashCode();
        h += (h << 5) + this.maxUses().hashCode();
        h += (h << 5) + this.temporary().hashCode();
        h += (h << 5) + this.unique().hashCode();
        h += (h << 5) + this.targetType().hashCode();
        h += (h << 5) + this.targetUserId().hashCode();
        h += (h << 5) + this.targetApplicationId().hashCode();
        return h;
    }

    public String toString() {
        return "InviteCreateSpec{reason=" + this.reason + ", maxAge=" + this.maxAge().toString() + ", maxUses=" + this.maxUses().toString() + ", temporary=" + this.temporary().toString() + ", unique=" + this.unique().toString() + ", targetType=" + this.targetType().toString() + ", targetUserId=" + this.targetUserId().toString() + ", targetApplicationId=" + this.targetApplicationId().toString() + "}";
    }

    public static InviteCreateSpec create() {
        return INSTANCE;
    }

    private static InviteCreateSpec validate(InviteCreateSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static InviteCreateSpec copyOf(InviteCreateSpecGenerator instance) {
        if (instance instanceof InviteCreateSpec) {
            return (InviteCreateSpec)instance;
        }
        return InviteCreateSpec.builder().from(instance).build();
    }

    public boolean isMaxAgePresent() {
        return !this.maxAge_absent;
    }

    public Integer maxAgeOrElse(Integer defaultValue) {
        return !this.maxAge_absent ? this.maxAge_value : defaultValue;
    }

    public boolean isMaxUsesPresent() {
        return !this.maxUses_absent;
    }

    public Integer maxUsesOrElse(Integer defaultValue) {
        return !this.maxUses_absent ? this.maxUses_value : defaultValue;
    }

    public boolean isTemporaryPresent() {
        return !this.temporary_absent;
    }

    public Boolean temporaryOrElse(Boolean defaultValue) {
        return !this.temporary_absent ? this.temporary_value : defaultValue;
    }

    public boolean isUniquePresent() {
        return !this.unique_absent;
    }

    public Boolean uniqueOrElse(Boolean defaultValue) {
        return !this.unique_absent ? this.unique_value : defaultValue;
    }

    public boolean isTargetTypePresent() {
        return !this.targetType_absent;
    }

    public Invite.Type targetTypeOrElse(Invite.Type defaultValue) {
        return !this.targetType_absent ? this.targetType_value : defaultValue;
    }

    public boolean isTargetUserIdPresent() {
        return !this.targetUserId_absent;
    }

    public Snowflake targetUserIdOrElse(Snowflake defaultValue) {
        return !this.targetUserId_absent ? this.targetUserId_value : defaultValue;
    }

    public boolean isTargetApplicationIdPresent() {
        return !this.targetApplicationId_absent;
    }

    public Snowflake targetApplicationIdOrElse(Snowflake defaultValue) {
        return !this.targetApplicationId_absent ? this.targetApplicationId_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InviteCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<Integer> maxAge_possible = Possible.absent();
        private Possible<Integer> maxUses_possible = Possible.absent();
        private Possible<Boolean> temporary_possible = Possible.absent();
        private Possible<Boolean> unique_possible = Possible.absent();
        private Possible<Invite.Type> targetType_possible = Possible.absent();
        private Possible<Snowflake> targetUserId_possible = Possible.absent();
        private Possible<Snowflake> targetApplicationId_possible = Possible.absent();
        private String reason;

        private Builder() {
        }

        public final Builder from(InviteCreateSpec instance) {
            return this.from((InviteCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(InviteCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.maxAge(instance.maxAge());
            this.maxUses(instance.maxUses());
            this.temporary(instance.temporary());
            this.unique(instance.unique());
            this.targetType(instance.targetType());
            this.targetUserId(instance.targetUserId());
            this.targetApplicationId(instance.targetApplicationId());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxAge(Possible<Integer> value) {
            this.maxAge_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxAge(Integer value) {
            this.maxAge_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxUses(Possible<Integer> value) {
            this.maxUses_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder maxUses(Integer value) {
            this.maxUses_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder temporary(Possible<Boolean> value) {
            this.temporary_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder temporary(Boolean value) {
            this.temporary_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder unique(Possible<Boolean> value) {
            this.unique_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder unique(Boolean value) {
            this.unique_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder targetType(Possible<Invite.Type> value) {
            this.targetType_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder targetType(Invite.Type value) {
            this.targetType_possible = Possible.of((Object)((Object)value));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder targetUserId(Possible<Snowflake> value) {
            this.targetUserId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder targetUserId(Snowflake value) {
            this.targetUserId_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder targetApplicationId(Possible<Snowflake> value) {
            this.targetApplicationId_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder targetApplicationId(Snowflake value) {
            this.targetApplicationId_possible = Possible.of((Object)value);
            return this;
        }

        public InviteCreateSpec build() {
            return InviteCreateSpec.validate(new InviteCreateSpec(this.reason, this.maxAge_build(), this.maxUses_build(), this.temporary_build(), this.unique_build(), this.targetType_build(), this.targetUserId_build(), this.targetApplicationId_build()));
        }

        private Possible<Integer> maxAge_build() {
            return this.maxAge_possible;
        }

        private Possible<Integer> maxUses_build() {
            return this.maxUses_possible;
        }

        private Possible<Boolean> temporary_build() {
            return this.temporary_possible;
        }

        private Possible<Boolean> unique_build() {
            return this.unique_possible;
        }

        private Possible<Invite.Type> targetType_build() {
            return this.targetType_possible;
        }

        private Possible<Snowflake> targetUserId_build() {
            return this.targetUserId_possible;
        }

        private Possible<Snowflake> targetApplicationId_build() {
            return this.targetApplicationId_possible;
        }
    }

    @Generated(from="InviteCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build InviteCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

