/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.spec.EmbedCreateSpec;
import discord4j.core.spec.InteractionApplicationCommandCallbackSpecGenerator;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

@Generated(from="InteractionApplicationCommandCallbackSpecGenerator", generator="Immutables")
public final class InteractionApplicationCommandCallbackSpec
implements InteractionApplicationCommandCallbackSpecGenerator {
    private final String content_value;
    private final boolean content_absent;
    private final Boolean tts_value;
    private final boolean tts_absent;
    private final Boolean ephemeral_value;
    private final boolean ephemeral_absent;
    private final List<EmbedCreateSpec> embeds_value;
    private final boolean embeds_absent;
    private final AllowedMentions allowedMentions_value;
    private final boolean allowedMentions_absent;
    private final List<LayoutComponent> components_value;
    private final boolean components_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final InteractionApplicationCommandCallbackSpec INSTANCE = InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec());

    private InteractionApplicationCommandCallbackSpec() {
        Possible content$impl = Possible.absent();
        Possible tts$impl = Possible.absent();
        Possible ephemeral$impl = Possible.absent();
        Possible embeds$impl = Possible.absent();
        Possible allowedMentions$impl = Possible.absent();
        Possible components$impl = Possible.absent();
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    private InteractionApplicationCommandCallbackSpec(Possible<String> content, Possible<Boolean> tts, Possible<Boolean> ephemeral, Possible<List<EmbedCreateSpec>> embeds, Possible<AllowedMentions> allowedMentions, Possible<List<LayoutComponent>> components) {
        Possible<String> content$impl = content;
        Possible<Boolean> tts$impl = tts;
        Possible<Boolean> ephemeral$impl = ephemeral;
        Possible<List<EmbedCreateSpec>> embeds$impl = embeds;
        Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
        Possible<List<LayoutComponent>> components$impl = components;
        this.content_value = content$impl.toOptional().orElse(null);
        this.content_absent = content$impl.isAbsent();
        this.tts_value = tts$impl.toOptional().orElse(null);
        this.tts_absent = tts$impl.isAbsent();
        this.ephemeral_value = ephemeral$impl.toOptional().orElse(null);
        this.ephemeral_absent = ephemeral$impl.isAbsent();
        this.embeds_value = embeds$impl.toOptional().orElse(null);
        this.embeds_absent = embeds$impl.isAbsent();
        this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
        this.allowedMentions_absent = allowedMentions$impl.isAbsent();
        this.components_value = components$impl.toOptional().orElse(null);
        this.components_absent = components$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public Possible<String> content() {
        return this.content_absent ? Possible.absent() : Possible.of((Object)this.content_value);
    }

    @Override
    public Possible<Boolean> tts() {
        return this.tts_absent ? Possible.absent() : Possible.of((Object)this.tts_value);
    }

    @Override
    public Possible<Boolean> ephemeral() {
        return this.ephemeral_absent ? Possible.absent() : Possible.of((Object)this.ephemeral_value);
    }

    @Override
    public Possible<List<EmbedCreateSpec>> embeds() {
        return this.embeds_absent ? Possible.absent() : Possible.of(this.embeds_value);
    }

    @Override
    public Possible<AllowedMentions> allowedMentions() {
        return this.allowedMentions_absent ? Possible.absent() : Possible.of((Object)this.allowedMentions_value);
    }

    @Override
    public Possible<List<LayoutComponent>> components() {
        return this.components_absent ? Possible.absent() : Possible.of(this.components_value);
    }

    public InteractionApplicationCommandCallbackSpec withContent(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(newValue, this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withContent(String value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec((Possible<String>)newValue, this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withTts(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), newValue, this.ephemeral(), this.embeds(), this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withTts(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), (Possible<Boolean>)newValue, this.ephemeral(), this.embeds(), this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEphemeral(Possible<Boolean> value) {
        Possible<Boolean> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), newValue, this.embeds(), this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEphemeral(Boolean value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), (Possible<Boolean>)newValue, this.embeds(), this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEmbeds(Possible<List<EmbedCreateSpec>> possible) {
        Possible<List<EmbedCreateSpec>> newValue = Objects.requireNonNull(possible);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), newValue, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withEmbeds(Iterable<EmbedCreateSpec> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), (Possible<List<EmbedCreateSpec>>)newValue, this.allowedMentions(), this.components()));
    }

    @SafeVarargs
    public final InteractionApplicationCommandCallbackSpec withEmbeds(EmbedCreateSpec ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), (Possible<List<EmbedCreateSpec>>)newValue, this.allowedMentions(), this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withAllowedMentions(Possible<AllowedMentions> value) {
        Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), newValue, this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withAllowedMentions(AllowedMentions value) {
        Possible newValue = Possible.of((Object)value);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), (Possible<AllowedMentions>)newValue, this.components()));
    }

    public InteractionApplicationCommandCallbackSpec withComponents(Possible<List<LayoutComponent>> possible) {
        Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), newValue));
    }

    public InteractionApplicationCommandCallbackSpec withComponents(Iterable<LayoutComponent> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), (Possible<List<LayoutComponent>>)newValue));
    }

    @SafeVarargs
    public final InteractionApplicationCommandCallbackSpec withComponents(LayoutComponent ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content(), this.tts(), this.ephemeral(), this.embeds(), this.allowedMentions(), (Possible<List<LayoutComponent>>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof InteractionApplicationCommandCallbackSpec && this.equalTo(0, (InteractionApplicationCommandCallbackSpec)another);
    }

    private boolean equalTo(int synthetic, InteractionApplicationCommandCallbackSpec another) {
        return this.content().equals(another.content()) && this.tts().equals(another.tts()) && this.ephemeral().equals(another.ephemeral()) && Objects.equals(this.embeds_value, another.embeds_value) && this.allowedMentions().equals(another.allowedMentions()) && Objects.equals(this.components_value, another.components_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.content().hashCode();
        h += (h << 5) + this.tts().hashCode();
        h += (h << 5) + this.ephemeral().hashCode();
        h += (h << 5) + Objects.hashCode(this.embeds_value);
        h += (h << 5) + this.allowedMentions().hashCode();
        h += (h << 5) + Objects.hashCode(this.components_value);
        return h;
    }

    public String toString() {
        return "InteractionApplicationCommandCallbackSpec{content=" + this.content().toString() + ", tts=" + this.tts().toString() + ", ephemeral=" + this.ephemeral().toString() + ", embeds=" + Objects.toString(this.embeds_value) + ", allowedMentions=" + this.allowedMentions().toString() + ", components=" + Objects.toString(this.components_value) + "}";
    }

    public static InteractionApplicationCommandCallbackSpec create() {
        return INSTANCE;
    }

    private static InteractionApplicationCommandCallbackSpec validate(InteractionApplicationCommandCallbackSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static InteractionApplicationCommandCallbackSpec copyOf(InteractionApplicationCommandCallbackSpecGenerator instance) {
        if (instance instanceof InteractionApplicationCommandCallbackSpec) {
            return (InteractionApplicationCommandCallbackSpec)instance;
        }
        return InteractionApplicationCommandCallbackSpec.builder().from(instance).build();
    }

    public boolean isContentPresent() {
        return !this.content_absent;
    }

    public String contentOrElse(String defaultValue) {
        return !this.content_absent ? this.content_value : defaultValue;
    }

    public boolean isTtsPresent() {
        return !this.tts_absent;
    }

    public Boolean ttsOrElse(Boolean defaultValue) {
        return !this.tts_absent ? this.tts_value : defaultValue;
    }

    public boolean isEphemeralPresent() {
        return !this.ephemeral_absent;
    }

    public Boolean ephemeralOrElse(Boolean defaultValue) {
        return !this.ephemeral_absent ? this.ephemeral_value : defaultValue;
    }

    public boolean isEmbedsPresent() {
        return !this.embeds_absent;
    }

    public List<EmbedCreateSpec> embedsOrElse(List<EmbedCreateSpec> defaultValue) {
        return !this.embeds_absent ? this.embeds_value : defaultValue;
    }

    public boolean isAllowedMentionsPresent() {
        return !this.allowedMentions_absent;
    }

    public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
        return !this.allowedMentions_absent ? this.allowedMentions_value : defaultValue;
    }

    public boolean isComponentsPresent() {
        return !this.components_absent;
    }

    public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
        return !this.components_absent ? this.components_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="InteractionApplicationCommandCallbackSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> content_possible = Possible.absent();
        private Possible<Boolean> tts_possible = Possible.absent();
        private Possible<Boolean> ephemeral_possible = Possible.absent();
        private List<EmbedCreateSpec> embeds_list = null;
        private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
        private List<LayoutComponent> components_list = null;

        private Builder() {
        }

        public final Builder from(InteractionApplicationCommandCallbackSpec instance) {
            return this.from((InteractionApplicationCommandCallbackSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(InteractionApplicationCommandCallbackSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.content(instance.content());
            this.tts(instance.tts());
            this.ephemeral(instance.ephemeral());
            this.embeds(instance.embeds());
            this.allowedMentions(instance.allowedMentions());
            this.components(instance.components());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(Possible<String> value) {
            this.content_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder content(String value) {
            this.content_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tts(Possible<Boolean> value) {
            this.tts_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder tts(Boolean value) {
            this.tts_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder ephemeral(Possible<Boolean> value) {
            this.ephemeral_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder ephemeral(Boolean value) {
            this.ephemeral_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addEmbed(EmbedCreateSpec element) {
            this.embeds_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllEmbeds(List<EmbedCreateSpec> elements) {
            this.embeds_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Possible<List<EmbedCreateSpec>> elements) {
            this.embeds_list = null;
            elements.toOptional().ifPresent(e -> this.embeds_getOrCreate().addAll((Collection<EmbedCreateSpec>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(List<EmbedCreateSpec> elements) {
            this.embeds_list = new ArrayList<EmbedCreateSpec>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder embeds(Iterable<EmbedCreateSpec> elements) {
            this.embeds_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(Possible<AllowedMentions> value) {
            this.allowedMentions_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder allowedMentions(AllowedMentions value) {
            this.allowedMentions_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addComponent(LayoutComponent element) {
            this.components_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllComponents(List<LayoutComponent> elements) {
            this.components_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Possible<List<LayoutComponent>> elements) {
            this.components_list = null;
            elements.toOptional().ifPresent(e -> this.components_getOrCreate().addAll((Collection<LayoutComponent>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(List<LayoutComponent> elements) {
            this.components_list = new ArrayList<LayoutComponent>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder components(Iterable<LayoutComponent> elements) {
            this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public InteractionApplicationCommandCallbackSpec build() {
            return InteractionApplicationCommandCallbackSpec.validate(new InteractionApplicationCommandCallbackSpec(this.content_build(), this.tts_build(), this.ephemeral_build(), this.embeds_build(), this.allowedMentions_build(), this.components_build()));
        }

        private Possible<String> content_build() {
            return this.content_possible;
        }

        private Possible<Boolean> tts_build() {
            return this.tts_possible;
        }

        private Possible<Boolean> ephemeral_build() {
            return this.ephemeral_possible;
        }

        private Possible<List<EmbedCreateSpec>> embeds_build() {
            return this.embeds_list == null ? Possible.absent() : Possible.of(this.embeds_list);
        }

        private List<EmbedCreateSpec> embeds_getOrCreate() {
            if (this.embeds_list == null) {
                this.embeds_list = new ArrayList<EmbedCreateSpec>();
            }
            return this.embeds_list;
        }

        private Possible<AllowedMentions> allowedMentions_build() {
            return this.allowedMentions_possible;
        }

        private Possible<List<LayoutComponent>> components_build() {
            return this.components_list == null ? Possible.absent() : Possible.of(this.components_list);
        }

        private List<LayoutComponent> components_getOrCreate() {
            if (this.components_list == null) {
                this.components_list = new ArrayList<LayoutComponent>();
            }
            return this.components_list;
        }
    }

    @Generated(from="InteractionApplicationCommandCallbackSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build InteractionApplicationCommandCallbackSpec, attribute initializers form cycle " + attributes;
        }
    }
}

