/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.MessageCreateFields;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="MessageCreateFields", generator="Immutables")
final class ImmutableMessageCreateFields {
    private ImmutableMessageCreateFields() {
    }

    @Generated(from="MessageCreateFields.FileSpoiler", generator="Immutables")
    static final class FileSpoiler
    implements MessageCreateFields.FileSpoiler {
        private final String name;
        private final InputStream inputStream;

        private FileSpoiler(String name, InputStream inputStream) {
            this.name = Objects.requireNonNull(name, "name");
            this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        }

        private FileSpoiler(FileSpoiler original, String name, InputStream inputStream) {
            this.name = name;
            this.inputStream = inputStream;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public InputStream inputStream() {
            return this.inputStream;
        }

        public final FileSpoiler withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new FileSpoiler(this, newValue, this.inputStream);
        }

        public final FileSpoiler withInputStream(InputStream value) {
            if (this.inputStream == value) {
                return this;
            }
            InputStream newValue = Objects.requireNonNull(value, "inputStream");
            return new FileSpoiler(this, this.name, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof FileSpoiler && this.equalTo(0, (FileSpoiler)another);
        }

        private boolean equalTo(int synthetic, FileSpoiler another) {
            return this.name.equals(another.name) && this.inputStream.equals(another.inputStream);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.inputStream.hashCode();
            return h;
        }

        public String toString() {
            return "FileSpoiler{name=" + this.name + ", inputStream=" + this.inputStream + "}";
        }

        public static FileSpoiler of(String name, InputStream inputStream) {
            return new FileSpoiler(name, inputStream);
        }

        public static FileSpoiler copyOf(MessageCreateFields.FileSpoiler instance) {
            if (instance instanceof FileSpoiler) {
                return (FileSpoiler)instance;
            }
            return FileSpoiler.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="MessageCreateFields.FileSpoiler", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_INPUT_STREAM = 2L;
            private long initBits = 3L;
            private String name;
            private InputStream inputStream;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(MessageCreateFields.File instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder from(MessageCreateFields.FileSpoiler instance) {
                Objects.requireNonNull(instance, "instance");
                this.from((Object)instance);
                return this;
            }

            private void from(Object object) {
                MessageCreateFields.File instance;
                long bits = 0L;
                if (object instanceof MessageCreateFields.File) {
                    instance = (MessageCreateFields.File)object;
                    if ((bits & 1L) == 0L) {
                        this.name(instance.name());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.inputStream(instance.inputStream());
                        bits |= 2L;
                    }
                }
                if (object instanceof MessageCreateFields.FileSpoiler) {
                    instance = (MessageCreateFields.FileSpoiler)object;
                    if ((bits & 1L) == 0L) {
                        this.name(instance.name());
                        bits |= 1L;
                    }
                    if ((bits & 2L) == 0L) {
                        this.inputStream(instance.inputStream());
                        bits |= 2L;
                    }
                }
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder inputStream(InputStream inputStream) {
                this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public FileSpoiler build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new FileSpoiler(null, this.name, this.inputStream);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("inputStream");
                }
                return "Cannot build FileSpoiler, some of required attributes are not set " + attributes;
            }
        }
    }

    @Generated(from="MessageCreateFields.File", generator="Immutables")
    static final class File
    implements MessageCreateFields.File {
        private final String name;
        private final InputStream inputStream;

        private File(String name, InputStream inputStream) {
            this.name = Objects.requireNonNull(name, "name");
            this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
        }

        private File(File original, String name, InputStream inputStream) {
            this.name = name;
            this.inputStream = inputStream;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public InputStream inputStream() {
            return this.inputStream;
        }

        public final File withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new File(this, newValue, this.inputStream);
        }

        public final File withInputStream(InputStream value) {
            if (this.inputStream == value) {
                return this;
            }
            InputStream newValue = Objects.requireNonNull(value, "inputStream");
            return new File(this, this.name, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof File && this.equalTo(0, (File)another);
        }

        private boolean equalTo(int synthetic, File another) {
            return this.name.equals(another.name) && this.inputStream.equals(another.inputStream);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.inputStream.hashCode();
            return h;
        }

        public String toString() {
            return "File{name=" + this.name + ", inputStream=" + this.inputStream + "}";
        }

        public static File of(String name, InputStream inputStream) {
            return new File(name, inputStream);
        }

        public static File copyOf(MessageCreateFields.File instance) {
            if (instance instanceof File) {
                return (File)instance;
            }
            return File.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="MessageCreateFields.File", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_INPUT_STREAM = 2L;
            private long initBits = 3L;
            private String name;
            private InputStream inputStream;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(MessageCreateFields.File instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.inputStream(instance.inputStream());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder inputStream(InputStream inputStream) {
                this.inputStream = Objects.requireNonNull(inputStream, "inputStream");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public File build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new File(null, this.name, this.inputStream);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("inputStream");
                }
                return "Cannot build File, some of required attributes are not set " + attributes;
            }
        }
    }
}

