/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.spec.GuildCreateFields;
import java.util.ArrayList;
import java.util.Objects;
import org.immutables.value.Generated;

@Generated(from="GuildCreateFields", generator="Immutables")
final class ImmutableGuildCreateFields {
    private ImmutableGuildCreateFields() {
    }

    @Generated(from="GuildCreateFields.PartialChannel", generator="Immutables")
    static final class PartialChannel
    implements GuildCreateFields.PartialChannel {
        private final String name;
        private final Channel.Type type;

        private PartialChannel(String name, Channel.Type type) {
            this.name = Objects.requireNonNull(name, "name");
            this.type = Objects.requireNonNull(type, "type");
        }

        private PartialChannel(PartialChannel original, String name, Channel.Type type) {
            this.name = name;
            this.type = type;
        }

        @Override
        public String name() {
            return this.name;
        }

        @Override
        public Channel.Type type() {
            return this.type;
        }

        public final PartialChannel withName(String value) {
            String newValue = Objects.requireNonNull(value, "name");
            if (this.name.equals(newValue)) {
                return this;
            }
            return new PartialChannel(this, newValue, this.type);
        }

        public final PartialChannel withType(Channel.Type value) {
            Channel.Type newValue = Objects.requireNonNull(value, "type");
            if (this.type == newValue) {
                return this;
            }
            return new PartialChannel(this, this.name, newValue);
        }

        public boolean equals(Object another) {
            if (this == another) {
                return true;
            }
            return another instanceof PartialChannel && this.equalTo(0, (PartialChannel)another);
        }

        private boolean equalTo(int synthetic, PartialChannel another) {
            return this.name.equals(another.name) && this.type.equals((Object)another.type);
        }

        public int hashCode() {
            int h = 5381;
            h += (h << 5) + this.name.hashCode();
            h += (h << 5) + this.type.hashCode();
            return h;
        }

        public String toString() {
            return "PartialChannel{name=" + this.name + ", type=" + (Object)((Object)this.type) + "}";
        }

        public static PartialChannel of(String name, Channel.Type type) {
            return new PartialChannel(name, type);
        }

        public static PartialChannel copyOf(GuildCreateFields.PartialChannel instance) {
            if (instance instanceof PartialChannel) {
                return (PartialChannel)instance;
            }
            return PartialChannel.builder().from(instance).build();
        }

        public static Builder builder() {
            return new Builder();
        }

        @Generated(from="GuildCreateFields.PartialChannel", generator="Immutables")
        public static final class Builder {
            private static final long INIT_BIT_NAME = 1L;
            private static final long INIT_BIT_TYPE = 2L;
            private long initBits = 3L;
            private String name;
            private Channel.Type type;

            private Builder() {
            }

            @CanIgnoreReturnValue
            public final Builder from(GuildCreateFields.PartialChannel instance) {
                Objects.requireNonNull(instance, "instance");
                this.name(instance.name());
                this.type(instance.type());
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder name(String name) {
                this.name = Objects.requireNonNull(name, "name");
                this.initBits &= 0xFFFFFFFFFFFFFFFEL;
                return this;
            }

            @CanIgnoreReturnValue
            public final Builder type(Channel.Type type) {
                this.type = Objects.requireNonNull(type, "type");
                this.initBits &= 0xFFFFFFFFFFFFFFFDL;
                return this;
            }

            public PartialChannel build() {
                if (this.initBits != 0L) {
                    throw new IllegalStateException(this.formatRequiredAttributesMessage());
                }
                return new PartialChannel(null, this.name, this.type);
            }

            private String formatRequiredAttributesMessage() {
                ArrayList<String> attributes = new ArrayList<String>();
                if ((this.initBits & 1L) != 0L) {
                    attributes.add("name");
                }
                if ((this.initBits & 2L) != 0L) {
                    attributes.add("type");
                }
                return "Cannot build PartialChannel, some of required attributes are not set " + attributes;
            }
        }
    }
}

