/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildTemplateCreateMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildTemplateCreateMonoGenerator", generator="Immutables")
public final class GuildTemplateCreateMono
extends GuildTemplateCreateMonoGenerator {
    private final String name;
    private final String description_value;
    private final boolean description_absent;
    private final Guild guild;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private GuildTemplateCreateMono(String name, Guild guild) {
        this.name = Objects.requireNonNull(name, "name");
        this.guild = Objects.requireNonNull(guild, "guild");
        Possible description$impl = Possible.absent();
        this.description_value = Possible.flatOpt((Possible)description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    private GuildTemplateCreateMono(String name, Possible<Optional<String>> description, Guild guild) {
        this.name = name;
        Possible<Optional<String>> description$impl = description;
        this.guild = guild;
        this.description_value = Possible.flatOpt(description$impl).orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Possible<Optional<String>> description() {
        return this.description_absent ? Possible.absent() : Possible.of(Optional.ofNullable(this.description_value));
    }

    @Override
    public Guild guild() {
        return this.guild;
    }

    public final GuildTemplateCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildTemplateCreateMono(newValue, this.description(), this.guild);
    }

    public GuildTemplateCreateMono withDescription(Possible<Optional<String>> value) {
        Possible<Optional<String>> newValue = Objects.requireNonNull(value);
        return new GuildTemplateCreateMono(this.name, newValue, this.guild);
    }

    @Deprecated
    public GuildTemplateCreateMono withDescription(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new GuildTemplateCreateMono(this.name, (Possible<Optional<String>>)newValue, this.guild);
    }

    public GuildTemplateCreateMono withDescriptionOrNull(@Nullable String value) {
        Possible newValue = Possible.of(Optional.ofNullable(value));
        return new GuildTemplateCreateMono(this.name, (Possible<Optional<String>>)newValue, this.guild);
    }

    public final GuildTemplateCreateMono withGuild(Guild value) {
        if (this.guild == value) {
            return this;
        }
        Guild newValue = Objects.requireNonNull(value, "guild");
        return new GuildTemplateCreateMono(this.name, this.description(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildTemplateCreateMono && this.equalTo(0, (GuildTemplateCreateMono)another);
    }

    private boolean equalTo(int synthetic, GuildTemplateCreateMono another) {
        return this.name.equals(another.name) && this.description().equals(another.description()) && this.guild.equals(another.guild);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.guild.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildTemplateCreateMono{name=" + this.name + ", description=" + this.description().toString() + ", guild=" + this.guild + "}";
    }

    public static GuildTemplateCreateMono of(String name, Guild guild) {
        return new GuildTemplateCreateMono(name, guild);
    }

    static GuildTemplateCreateMono copyOf(GuildTemplateCreateMonoGenerator instance) {
        if (instance instanceof GuildTemplateCreateMono) {
            return (GuildTemplateCreateMono)instance;
        }
        return GuildTemplateCreateMono.of(instance.name(), instance.guild()).withDescription((Possible<Optional<String>>)instance.description());
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    @Generated(from="GuildTemplateCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildTemplateCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

