/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.common.util.Snowflake;
import discord4j.core.spec.GuildEmojiEditSpecGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildEmojiEditSpecGenerator", generator="Immutables")
public final class GuildEmojiEditSpec
implements GuildEmojiEditSpecGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final List<Snowflake> roles_value;
    private final boolean roles_absent;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final GuildEmojiEditSpec INSTANCE = GuildEmojiEditSpec.validate(new GuildEmojiEditSpec());

    private GuildEmojiEditSpec() {
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible roles$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.roles_value = roles$impl.toOptional().orElse(null);
        this.roles_absent = roles$impl.isAbsent();
        this.initShim = null;
    }

    private GuildEmojiEditSpec(@Nullable String reason, Possible<String> name, Possible<List<Snowflake>> roles) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<List<Snowflake>> roles$impl = roles;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.roles_value = roles$impl.toOptional().orElse(null);
        this.roles_absent = roles$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<List<Snowflake>> roles() {
        return this.roles_absent ? Possible.absent() : Possible.of(this.roles_value);
    }

    public final GuildEmojiEditSpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(value, this.name(), this.roles()));
    }

    public GuildEmojiEditSpec withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(this.reason, newValue, this.roles()));
    }

    public GuildEmojiEditSpec withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(this.reason, (Possible<String>)newValue, this.roles()));
    }

    public GuildEmojiEditSpec withRoles(Possible<List<Snowflake>> possible) {
        Possible<List<Snowflake>> newValue = Objects.requireNonNull(possible);
        return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(this.reason, this.name(), newValue));
    }

    public GuildEmojiEditSpec withRoles(Iterable<Snowflake> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(this.reason, this.name(), (Possible<List<Snowflake>>)newValue));
    }

    @SafeVarargs
    public final GuildEmojiEditSpec withRoles(Snowflake ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(this.reason, this.name(), (Possible<List<Snowflake>>)newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildEmojiEditSpec && this.equalTo(0, (GuildEmojiEditSpec)another);
    }

    private boolean equalTo(int synthetic, GuildEmojiEditSpec another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && Objects.equals(this.roles_value, another.roles_value);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + Objects.hashCode(this.roles_value);
        return h;
    }

    public String toString() {
        return "GuildEmojiEditSpec{reason=" + this.reason + ", name=" + this.name().toString() + ", roles=" + Objects.toString(this.roles_value) + "}";
    }

    public static GuildEmojiEditSpec create() {
        return INSTANCE;
    }

    private static GuildEmojiEditSpec validate(GuildEmojiEditSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static GuildEmojiEditSpec copyOf(GuildEmojiEditSpecGenerator instance) {
        if (instance instanceof GuildEmojiEditSpec) {
            return (GuildEmojiEditSpec)instance;
        }
        return GuildEmojiEditSpec.builder().from(instance).build();
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isRolesPresent() {
        return !this.roles_absent;
    }

    public List<Snowflake> rolesOrElse(List<Snowflake> defaultValue) {
        return !this.roles_absent ? this.roles_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="GuildEmojiEditSpecGenerator", generator="Immutables")
    public static final class Builder {
        private Possible<String> name_possible = Possible.absent();
        private List<Snowflake> roles_list = null;
        private String reason;

        private Builder() {
        }

        public final Builder from(GuildEmojiEditSpec instance) {
            return this.from((GuildEmojiEditSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(GuildEmojiEditSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            this.name(instance.name());
            this.roles(instance.roles());
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(Possible<String> value) {
            this.name_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder name(String value) {
            this.name_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addRole(Snowflake element) {
            this.roles_getOrCreate().add(element);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder addAllRoles(List<Snowflake> elements) {
            this.roles_getOrCreate().addAll(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder roles(Possible<List<Snowflake>> elements) {
            this.roles_list = null;
            elements.toOptional().ifPresent(e -> this.roles_getOrCreate().addAll((Collection<Snowflake>)e));
            return this;
        }

        @CanIgnoreReturnValue
        public Builder roles(List<Snowflake> elements) {
            this.roles_list = new ArrayList<Snowflake>(elements);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder roles(Iterable<Snowflake> elements) {
            this.roles_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
            return this;
        }

        public GuildEmojiEditSpec build() {
            return GuildEmojiEditSpec.validate(new GuildEmojiEditSpec(this.reason, this.name_build(), this.roles_build()));
        }

        private Possible<String> name_build() {
            return this.name_possible;
        }

        private Possible<List<Snowflake>> roles_build() {
            return this.roles_list == null ? Possible.absent() : Possible.of(this.roles_list);
        }

        private List<Snowflake> roles_getOrCreate() {
            if (this.roles_list == null) {
                this.roles_list = new ArrayList<Snowflake>();
            }
            return this.roles_list;
        }
    }

    @Generated(from="GuildEmojiEditSpecGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build GuildEmojiEditSpec, attribute initializers form cycle " + attributes;
        }
    }
}

