/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.common.util.Snowflake;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.AuditSpec;
import discord4j.core.spec.InternalSpecUtils;
import discord4j.discordjson.json.GuildModifyRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import org.immutables.value.Value;

@Value.Immutable(singleton=true)
interface GuildEditSpecGenerator
extends AuditSpec<GuildModifyRequest> {
    public Possible<String> name();

    public Possible<Optional<Region>> region();

    public Possible<Optional<Guild.VerificationLevel>> verificationLevel();

    public Possible<Optional<Guild.NotificationLevel>> defaultMessageNotificationsLevel();

    public Possible<Optional<Guild.ContentFilterLevel>> explicitContentFilter();

    public Possible<Optional<Snowflake>> afkChannelId();

    public Possible<Integer> afkTimeout();

    public Possible<Optional<Image>> icon();

    public Possible<Snowflake> ownerId();

    public Possible<Optional<Image>> splash();

    public Possible<Optional<Image>> discoverySplash();

    public Possible<Optional<Image>> banner();

    public Possible<Optional<Snowflake>> systemChannelId();

    public Possible<Guild.SystemChannelFlag> systemChannelFlags();

    public Possible<Optional<Snowflake>> rulesChannelId();

    public Possible<Optional<Snowflake>> publicUpdatesChannelId();

    public Possible<Optional<Locale>> preferredLocale();

    public Possible<List<String>> features();

    public Possible<Optional<String>> description();

    @Override
    default public GuildModifyRequest asRequest() {
        return GuildModifyRequest.builder().name(this.name()).region(InternalSpecUtils.mapPossibleOptional(this.region(), Region::getId)).verificationLevel(InternalSpecUtils.mapPossibleOptional(this.verificationLevel(), Guild.VerificationLevel::getValue)).defaultMessageNotifications(InternalSpecUtils.mapPossibleOptional(this.defaultMessageNotificationsLevel(), Guild.NotificationLevel::getValue)).explicitContentFilter(InternalSpecUtils.mapPossibleOptional(this.explicitContentFilter(), Guild.ContentFilterLevel::getValue)).afkChannelId(InternalSpecUtils.mapPossibleOptional(this.afkChannelId(), Snowflake::asString)).afkTimeout(this.afkTimeout()).icon(InternalSpecUtils.mapPossibleOptional(this.icon(), Image::getDataUri)).ownerId(InternalSpecUtils.mapPossible(this.ownerId(), Snowflake::asString)).splash(InternalSpecUtils.mapPossibleOptional(this.splash(), Image::getDataUri)).discoverySplash(InternalSpecUtils.mapPossibleOptional(this.discoverySplash(), Image::getDataUri)).banner(InternalSpecUtils.mapPossibleOptional(this.banner(), Image::getDataUri)).systemChannelId(InternalSpecUtils.mapPossibleOptional(this.systemChannelId(), Snowflake::asString)).systemChannelFlags(InternalSpecUtils.mapPossible(this.systemChannelFlags(), Guild.SystemChannelFlag::getValue)).rulesChannelId(InternalSpecUtils.mapPossibleOptional(this.rulesChannelId(), Snowflake::asString)).publicUpdatesChannelId(InternalSpecUtils.mapPossibleOptional(this.publicUpdatesChannelId(), Snowflake::asString)).preferredLocale(InternalSpecUtils.mapPossibleOptional(this.preferredLocale(), Locale::toLanguageTag)).features(InternalSpecUtils.mapPossible(this.features(), ArrayList::new)).description(this.description()).build();
    }
}

