/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Region;
import discord4j.core.object.entity.Guild;
import discord4j.core.spec.GuildCreateFields;
import discord4j.core.spec.GuildCreateMonoGenerator;
import discord4j.core.spec.RoleCreateSpec;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="GuildCreateMonoGenerator", generator="Immutables")
public final class GuildCreateMono
extends GuildCreateMonoGenerator {
    private final String name;
    private final Region region;
    @Nullable
    private final Image icon;
    private final Guild.VerificationLevel verificationLevel;
    private final Guild.NotificationLevel defaultMessageNotificationLevel;
    private final Guild.ContentFilterLevel explicitContentFilter;
    private final List<RoleCreateSpec> roles;
    @Nullable
    private final RoleCreateSpec everyoneRole;
    private final List<GuildCreateFields.PartialChannel> channels;
    private final GatewayDiscordClient gateway;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private GuildCreateMono(String name, Region region, GatewayDiscordClient gateway) {
        this.name = Objects.requireNonNull(name, "name");
        this.region = Objects.requireNonNull(region, "region");
        this.gateway = Objects.requireNonNull(gateway, "gateway");
        this.icon = null;
        this.everyoneRole = null;
        this.verificationLevel = this.initShim.verificationLevel();
        this.defaultMessageNotificationLevel = this.initShim.defaultMessageNotificationLevel();
        this.explicitContentFilter = this.initShim.explicitContentFilter();
        this.roles = this.initShim.roles();
        this.channels = this.initShim.channels();
        this.initShim = null;
    }

    private GuildCreateMono(String name, Region region, @Nullable Image icon, Guild.VerificationLevel verificationLevel, Guild.NotificationLevel defaultMessageNotificationLevel, Guild.ContentFilterLevel explicitContentFilter, List<RoleCreateSpec> roles, @Nullable RoleCreateSpec everyoneRole, List<GuildCreateFields.PartialChannel> channels, GatewayDiscordClient gateway) {
        this.name = name;
        this.region = region;
        this.icon = icon;
        this.verificationLevel = verificationLevel;
        this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
        this.explicitContentFilter = explicitContentFilter;
        this.roles = roles;
        this.everyoneRole = everyoneRole;
        this.channels = channels;
        this.gateway = gateway;
        this.initShim = null;
    }

    @Override
    public String name() {
        return this.name;
    }

    @Override
    public Region region() {
        return this.region;
    }

    @Override
    @Nullable
    public Image icon() {
        return this.icon;
    }

    @Override
    public Guild.VerificationLevel verificationLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.verificationLevel() : this.verificationLevel;
    }

    @Override
    public Guild.NotificationLevel defaultMessageNotificationLevel() {
        InitShim shim = this.initShim;
        return shim != null ? shim.defaultMessageNotificationLevel() : this.defaultMessageNotificationLevel;
    }

    @Override
    public Guild.ContentFilterLevel explicitContentFilter() {
        InitShim shim = this.initShim;
        return shim != null ? shim.explicitContentFilter() : this.explicitContentFilter;
    }

    @Override
    public List<RoleCreateSpec> roles() {
        InitShim shim = this.initShim;
        return shim != null ? shim.roles() : this.roles;
    }

    @Override
    @Nullable
    public RoleCreateSpec everyoneRole() {
        return this.everyoneRole;
    }

    @Override
    public List<GuildCreateFields.PartialChannel> channels() {
        InitShim shim = this.initShim;
        return shim != null ? shim.channels() : this.channels;
    }

    @Override
    public GatewayDiscordClient gateway() {
        return this.gateway;
    }

    public final GuildCreateMono withName(String value) {
        String newValue = Objects.requireNonNull(value, "name");
        if (this.name.equals(newValue)) {
            return this;
        }
        return new GuildCreateMono(newValue, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withRegion(Region value) {
        if (this.region == value) {
            return this;
        }
        Region newValue = Objects.requireNonNull(value, "region");
        return new GuildCreateMono(this.name, newValue, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withIcon(@Nullable Image value) {
        if (this.icon == value) {
            return this;
        }
        return new GuildCreateMono(this.name, this.region, value, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withVerificationLevel(Guild.VerificationLevel value) {
        Guild.VerificationLevel newValue = Objects.requireNonNull(value, "verificationLevel");
        if (this.verificationLevel == newValue) {
            return this;
        }
        return new GuildCreateMono(this.name, this.region, this.icon, newValue, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withDefaultMessageNotificationLevel(Guild.NotificationLevel value) {
        Guild.NotificationLevel newValue = Objects.requireNonNull(value, "defaultMessageNotificationLevel");
        if (this.defaultMessageNotificationLevel == newValue) {
            return this;
        }
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, newValue, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withExplicitContentFilter(Guild.ContentFilterLevel value) {
        Guild.ContentFilterLevel newValue = Objects.requireNonNull(value, "explicitContentFilter");
        if (this.explicitContentFilter == newValue) {
            return this;
        }
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, newValue, this.roles, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withRoles(RoleCreateSpec ... elements) {
        List<RoleCreateSpec> newValue = GuildCreateMono.createUnmodifiableList(false, GuildCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, newValue, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withRoles(Iterable<? extends RoleCreateSpec> elements) {
        if (this.roles == elements) {
            return this;
        }
        List<RoleCreateSpec> newValue = GuildCreateMono.createUnmodifiableList(false, GuildCreateMono.createSafeList(elements, true, false));
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, newValue, this.everyoneRole, this.channels, this.gateway);
    }

    public final GuildCreateMono withEveryoneRole(@Nullable RoleCreateSpec value) {
        if (this.everyoneRole == value) {
            return this;
        }
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, value, this.channels, this.gateway);
    }

    public final GuildCreateMono withChannels(GuildCreateFields.PartialChannel ... elements) {
        List<GuildCreateFields.PartialChannel> newValue = GuildCreateMono.createUnmodifiableList(false, GuildCreateMono.createSafeList(Arrays.asList(elements), true, false));
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, newValue, this.gateway);
    }

    public final GuildCreateMono withChannels(Iterable<? extends GuildCreateFields.PartialChannel> elements) {
        if (this.channels == elements) {
            return this;
        }
        List<GuildCreateFields.PartialChannel> newValue = GuildCreateMono.createUnmodifiableList(false, GuildCreateMono.createSafeList(elements, true, false));
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, newValue, this.gateway);
    }

    public final GuildCreateMono withGateway(GatewayDiscordClient value) {
        if (this.gateway == value) {
            return this;
        }
        GatewayDiscordClient newValue = Objects.requireNonNull(value, "gateway");
        return new GuildCreateMono(this.name, this.region, this.icon, this.verificationLevel, this.defaultMessageNotificationLevel, this.explicitContentFilter, this.roles, this.everyoneRole, this.channels, newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof GuildCreateMono && this.equalTo(0, (GuildCreateMono)another);
    }

    private boolean equalTo(int synthetic, GuildCreateMono another) {
        return this.name.equals(another.name) && this.region.equals(another.region) && Objects.equals(this.icon, another.icon) && this.verificationLevel.equals((Object)another.verificationLevel) && this.defaultMessageNotificationLevel.equals((Object)another.defaultMessageNotificationLevel) && this.explicitContentFilter.equals((Object)another.explicitContentFilter) && this.roles.equals(another.roles) && Objects.equals(this.everyoneRole, another.everyoneRole) && this.channels.equals(another.channels) && this.gateway.equals(another.gateway);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.name.hashCode();
        h += (h << 5) + this.region.hashCode();
        h += (h << 5) + Objects.hashCode(this.icon);
        h += (h << 5) + this.verificationLevel.hashCode();
        h += (h << 5) + this.defaultMessageNotificationLevel.hashCode();
        h += (h << 5) + this.explicitContentFilter.hashCode();
        h += (h << 5) + this.roles.hashCode();
        h += (h << 5) + Objects.hashCode(this.everyoneRole);
        h += (h << 5) + this.channels.hashCode();
        h += (h << 5) + this.gateway.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "GuildCreateMono{name=" + this.name + ", region=" + this.region + ", icon=" + this.icon + ", verificationLevel=" + (Object)((Object)this.verificationLevel) + ", defaultMessageNotificationLevel=" + (Object)((Object)this.defaultMessageNotificationLevel) + ", explicitContentFilter=" + (Object)((Object)this.explicitContentFilter) + ", roles=" + this.roles + ", everyoneRole=" + this.everyoneRole + ", channels=" + this.channels + ", gateway=" + this.gateway + "}";
    }

    public static GuildCreateMono of(String name, Region region, GatewayDiscordClient gateway) {
        return new GuildCreateMono(name, region, gateway);
    }

    static GuildCreateMono copyOf(GuildCreateMonoGenerator instance) {
        if (instance instanceof GuildCreateMono) {
            return (GuildCreateMono)instance;
        }
        return GuildCreateMono.of(instance.name(), instance.region(), instance.gateway()).withIcon(instance.icon()).withVerificationLevel(instance.verificationLevel()).withDefaultMessageNotificationLevel(instance.defaultMessageNotificationLevel()).withExplicitContentFilter(instance.explicitContentFilter()).withRoles(instance.roles()).withEveryoneRole(instance.everyoneRole()).withChannels(instance.channels());
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="GuildCreateMonoGenerator", generator="Immutables")
    private final class InitShim {
        private byte verificationLevelBuildStage = 0;
        private Guild.VerificationLevel verificationLevel;
        private byte defaultMessageNotificationLevelBuildStage = 0;
        private Guild.NotificationLevel defaultMessageNotificationLevel;
        private byte explicitContentFilterBuildStage = 0;
        private Guild.ContentFilterLevel explicitContentFilter;
        private byte rolesBuildStage = 0;
        private List<RoleCreateSpec> roles;
        private byte channelsBuildStage = 0;
        private List<GuildCreateFields.PartialChannel> channels;

        private InitShim() {
        }

        Guild.VerificationLevel verificationLevel() {
            if (this.verificationLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.verificationLevelBuildStage == 0) {
                this.verificationLevelBuildStage = (byte)-1;
                this.verificationLevel = Objects.requireNonNull(GuildCreateMono.super.verificationLevel(), "verificationLevel");
                this.verificationLevelBuildStage = 1;
            }
            return this.verificationLevel;
        }

        void verificationLevel(Guild.VerificationLevel verificationLevel) {
            this.verificationLevel = verificationLevel;
            this.verificationLevelBuildStage = 1;
        }

        Guild.NotificationLevel defaultMessageNotificationLevel() {
            if (this.defaultMessageNotificationLevelBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.defaultMessageNotificationLevelBuildStage == 0) {
                this.defaultMessageNotificationLevelBuildStage = (byte)-1;
                this.defaultMessageNotificationLevel = Objects.requireNonNull(GuildCreateMono.super.defaultMessageNotificationLevel(), "defaultMessageNotificationLevel");
                this.defaultMessageNotificationLevelBuildStage = 1;
            }
            return this.defaultMessageNotificationLevel;
        }

        void defaultMessageNotificationLevel(Guild.NotificationLevel defaultMessageNotificationLevel) {
            this.defaultMessageNotificationLevel = defaultMessageNotificationLevel;
            this.defaultMessageNotificationLevelBuildStage = 1;
        }

        Guild.ContentFilterLevel explicitContentFilter() {
            if (this.explicitContentFilterBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.explicitContentFilterBuildStage == 0) {
                this.explicitContentFilterBuildStage = (byte)-1;
                this.explicitContentFilter = Objects.requireNonNull(GuildCreateMono.super.explicitContentFilter(), "explicitContentFilter");
                this.explicitContentFilterBuildStage = 1;
            }
            return this.explicitContentFilter;
        }

        void explicitContentFilter(Guild.ContentFilterLevel explicitContentFilter) {
            this.explicitContentFilter = explicitContentFilter;
            this.explicitContentFilterBuildStage = 1;
        }

        List<RoleCreateSpec> roles() {
            if (this.rolesBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.rolesBuildStage == 0) {
                this.rolesBuildStage = (byte)-1;
                this.roles = GuildCreateMono.createUnmodifiableList(false, GuildCreateMono.createSafeList(GuildCreateMono.super.roles(), true, false));
                this.rolesBuildStage = 1;
            }
            return this.roles;
        }

        void roles(List<RoleCreateSpec> roles) {
            this.roles = roles;
            this.rolesBuildStage = 1;
        }

        List<GuildCreateFields.PartialChannel> channels() {
            if (this.channelsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.channelsBuildStage == 0) {
                this.channelsBuildStage = (byte)-1;
                this.channels = GuildCreateMono.createUnmodifiableList(false, GuildCreateMono.createSafeList(GuildCreateMono.super.channels(), true, false));
                this.channelsBuildStage = 1;
            }
            return this.channels;
        }

        void channels(List<GuildCreateFields.PartialChannel> channels) {
            this.channels = channels;
            this.channelsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.verificationLevelBuildStage == -1) {
                attributes.add("verificationLevel");
            }
            if (this.defaultMessageNotificationLevelBuildStage == -1) {
                attributes.add("defaultMessageNotificationLevel");
            }
            if (this.explicitContentFilterBuildStage == -1) {
                attributes.add("explicitContentFilter");
            }
            if (this.rolesBuildStage == -1) {
                attributes.add("roles");
            }
            if (this.channelsBuildStage == -1) {
                attributes.add("channels");
            }
            return "Cannot build GuildCreateMono, attribute initializers form cycle " + attributes;
        }
    }
}

