/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.EmbedCreateFields;
import discord4j.core.spec.EmbedCreateSpecGenerator;
import discord4j.core.spec.ImmutableEmbedCreateFields;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="EmbedCreateSpecGenerator", generator="Immutables")
public final class EmbedCreateSpec
implements EmbedCreateSpecGenerator {
    private final String title_value;
    private final boolean title_absent;
    private final String description_value;
    private final boolean description_absent;
    private final String url_value;
    private final boolean url_absent;
    private final Instant timestamp_value;
    private final boolean timestamp_absent;
    private final Color color_value;
    private final boolean color_absent;
    @Nullable
    private final ImmutableEmbedCreateFields.Footer footer;
    private final String image_value;
    private final boolean image_absent;
    private final String thumbnail_value;
    private final boolean thumbnail_absent;
    @Nullable
    private final ImmutableEmbedCreateFields.Author author;
    private final List<EmbedCreateFields.Field> fields;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();
    private static final EmbedCreateSpec INSTANCE = EmbedCreateSpec.validate(new EmbedCreateSpec());

    private EmbedCreateSpec() {
        Possible title$impl = Possible.absent();
        Possible description$impl = Possible.absent();
        Possible url$impl = Possible.absent();
        Possible timestamp$impl = Possible.absent();
        Possible color$impl = Possible.absent();
        this.footer = null;
        Possible image$impl = Possible.absent();
        Possible thumbnail$impl = Possible.absent();
        this.author = null;
        this.title_value = title$impl.toOptional().orElse(null);
        this.title_absent = title$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.url_value = url$impl.toOptional().orElse(null);
        this.url_absent = url$impl.isAbsent();
        this.timestamp_value = timestamp$impl.toOptional().orElse(null);
        this.timestamp_absent = timestamp$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.thumbnail_value = thumbnail$impl.toOptional().orElse(null);
        this.thumbnail_absent = thumbnail$impl.isAbsent();
        this.fields = this.initShim.fields();
        this.initShim = null;
    }

    private EmbedCreateSpec(Builder builder) {
        Possible title$impl = builder.title_build();
        Possible description$impl = builder.description_build();
        Possible url$impl = builder.url_build();
        Possible timestamp$impl = builder.timestamp_build();
        Possible color$impl = builder.color_build();
        this.footer = builder.footer == null ? null : ImmutableEmbedCreateFields.Footer.copyOf(builder.footer);
        Possible image$impl = builder.image_build();
        Possible thumbnail$impl = builder.thumbnail_build();
        ImmutableEmbedCreateFields.Author author = this.author = builder.author == null ? null : ImmutableEmbedCreateFields.Author.copyOf(builder.author);
        if (builder.fieldsIsSet()) {
            this.initShim.fields(EmbedCreateSpec.createUnmodifiableList(true, builder.fields));
        }
        this.title_value = title$impl.toOptional().orElse(null);
        this.title_absent = title$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.url_value = url$impl.toOptional().orElse(null);
        this.url_absent = url$impl.isAbsent();
        this.timestamp_value = timestamp$impl.toOptional().orElse(null);
        this.timestamp_absent = timestamp$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.thumbnail_value = thumbnail$impl.toOptional().orElse(null);
        this.thumbnail_absent = thumbnail$impl.isAbsent();
        this.fields = this.initShim.fields();
        this.initShim = null;
    }

    private EmbedCreateSpec(Possible<String> title, Possible<String> description, Possible<String> url, Possible<Instant> timestamp, Possible<Color> color, @Nullable ImmutableEmbedCreateFields.Footer footer, Possible<String> image, Possible<String> thumbnail, @Nullable ImmutableEmbedCreateFields.Author author, List<EmbedCreateFields.Field> fields) {
        Possible<String> title$impl = title;
        Possible<String> description$impl = description;
        Possible<String> url$impl = url;
        Possible<Instant> timestamp$impl = timestamp;
        Possible<Color> color$impl = color;
        this.footer = footer;
        Possible<String> image$impl = image;
        Possible<String> thumbnail$impl = thumbnail;
        this.author = author;
        this.initShim.fields(fields);
        this.title_value = title$impl.toOptional().orElse(null);
        this.title_absent = title$impl.isAbsent();
        this.description_value = description$impl.toOptional().orElse(null);
        this.description_absent = description$impl.isAbsent();
        this.url_value = url$impl.toOptional().orElse(null);
        this.url_absent = url$impl.isAbsent();
        this.timestamp_value = timestamp$impl.toOptional().orElse(null);
        this.timestamp_absent = timestamp$impl.isAbsent();
        this.color_value = color$impl.toOptional().orElse(null);
        this.color_absent = color$impl.isAbsent();
        this.image_value = image$impl.toOptional().orElse(null);
        this.image_absent = image$impl.isAbsent();
        this.thumbnail_value = thumbnail$impl.toOptional().orElse(null);
        this.thumbnail_absent = thumbnail$impl.isAbsent();
        this.fields = this.initShim.fields();
        this.initShim = null;
    }

    private List<EmbedCreateFields.Field> fieldsInitialize() {
        return EmbedCreateSpecGenerator.super.fields();
    }

    @Override
    public Possible<String> title() {
        return this.title_absent ? Possible.absent() : Possible.of((Object)this.title_value);
    }

    @Override
    public Possible<String> description() {
        return this.description_absent ? Possible.absent() : Possible.of((Object)this.description_value);
    }

    @Override
    public Possible<String> url() {
        return this.url_absent ? Possible.absent() : Possible.of((Object)this.url_value);
    }

    @Override
    public Possible<Instant> timestamp() {
        return this.timestamp_absent ? Possible.absent() : Possible.of((Object)this.timestamp_value);
    }

    @Override
    public Possible<Color> color() {
        return this.color_absent ? Possible.absent() : Possible.of((Object)this.color_value);
    }

    @Override
    @Nullable
    public ImmutableEmbedCreateFields.Footer footer() {
        return this.footer;
    }

    @Override
    public Possible<String> image() {
        return this.image_absent ? Possible.absent() : Possible.of((Object)this.image_value);
    }

    @Override
    public Possible<String> thumbnail() {
        return this.thumbnail_absent ? Possible.absent() : Possible.of((Object)this.thumbnail_value);
    }

    @Override
    @Nullable
    public ImmutableEmbedCreateFields.Author author() {
        return this.author;
    }

    @Override
    public List<EmbedCreateFields.Field> fields() {
        InitShim shim = this.initShim;
        return shim != null ? shim.fields() : this.fields;
    }

    public EmbedCreateSpec withTitle(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(newValue, this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withTitle(String value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec((Possible<String>)newValue, this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withDescription(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), newValue, this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withDescription(String value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), (Possible<String>)newValue, this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withUrl(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), newValue, this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withUrl(String value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), (Possible<String>)newValue, this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withTimestamp(Possible<Instant> value) {
        Possible<Instant> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), newValue, this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withTimestamp(Instant value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), (Possible<Instant>)newValue, this.color(), this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withColor(Possible<Color> value) {
        Possible<Color> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), newValue, this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withColor(Color value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), (Possible<Color>)newValue, this.footer, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public final EmbedCreateSpec withFooter(@Nullable EmbedCreateFields.Footer value) {
        if (this.footer == value) {
            return this;
        }
        ImmutableEmbedCreateFields.Footer newValue = value == null ? null : ImmutableEmbedCreateFields.Footer.copyOf(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), newValue, this.image(), this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withImage(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, newValue, this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withImage(String value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, (Possible<String>)newValue, this.thumbnail(), this.author, this.fields));
    }

    public EmbedCreateSpec withThumbnail(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), newValue, this.author, this.fields));
    }

    public EmbedCreateSpec withThumbnail(String value) {
        Possible newValue = Possible.of((Object)value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), (Possible<String>)newValue, this.author, this.fields));
    }

    public final EmbedCreateSpec withAuthor(@Nullable EmbedCreateFields.Author value) {
        if (this.author == value) {
            return this;
        }
        ImmutableEmbedCreateFields.Author newValue = value == null ? null : ImmutableEmbedCreateFields.Author.copyOf(value);
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), newValue, this.fields));
    }

    public final EmbedCreateSpec withFields(EmbedCreateFields.Field ... elements) {
        List<EmbedCreateFields.Field> newValue = EmbedCreateSpec.createUnmodifiableList(false, EmbedCreateSpec.createSafeList(Arrays.asList(elements), true, false));
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, newValue));
    }

    public final EmbedCreateSpec withFields(Iterable<? extends EmbedCreateFields.Field> elements) {
        if (this.fields == elements) {
            return this;
        }
        List<EmbedCreateFields.Field> newValue = EmbedCreateSpec.createUnmodifiableList(false, EmbedCreateSpec.createSafeList(elements, true, false));
        return EmbedCreateSpec.validate(new EmbedCreateSpec(this.title(), this.description(), this.url(), this.timestamp(), this.color(), this.footer, this.image(), this.thumbnail(), this.author, newValue));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof EmbedCreateSpec && this.equalTo(0, (EmbedCreateSpec)another);
    }

    private boolean equalTo(int synthetic, EmbedCreateSpec another) {
        return this.title().equals(another.title()) && this.description().equals(another.description()) && this.url().equals(another.url()) && this.timestamp().equals(another.timestamp()) && this.color().equals(another.color()) && Objects.equals(this.footer, another.footer) && this.image().equals(another.image()) && this.thumbnail().equals(another.thumbnail()) && Objects.equals(this.author, another.author) && this.fields.equals(another.fields);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + this.title().hashCode();
        h += (h << 5) + this.description().hashCode();
        h += (h << 5) + this.url().hashCode();
        h += (h << 5) + this.timestamp().hashCode();
        h += (h << 5) + this.color().hashCode();
        h += (h << 5) + Objects.hashCode(this.footer);
        h += (h << 5) + this.image().hashCode();
        h += (h << 5) + this.thumbnail().hashCode();
        h += (h << 5) + Objects.hashCode(this.author);
        h += (h << 5) + this.fields.hashCode();
        return h;
    }

    public String toString() {
        return "EmbedCreateSpec{title=" + this.title().toString() + ", description=" + this.description().toString() + ", url=" + this.url().toString() + ", timestamp=" + this.timestamp().toString() + ", color=" + this.color().toString() + ", footer=" + this.footer + ", image=" + this.image().toString() + ", thumbnail=" + this.thumbnail().toString() + ", author=" + this.author + ", fields=" + this.fields + "}";
    }

    public static EmbedCreateSpec create() {
        return INSTANCE;
    }

    private static EmbedCreateSpec validate(EmbedCreateSpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static EmbedCreateSpec copyOf(EmbedCreateSpecGenerator instance) {
        if (instance instanceof EmbedCreateSpec) {
            return (EmbedCreateSpec)instance;
        }
        return EmbedCreateSpec.builder().from(instance).build();
    }

    public boolean isTitlePresent() {
        return !this.title_absent;
    }

    public String titleOrElse(String defaultValue) {
        return !this.title_absent ? this.title_value : defaultValue;
    }

    public boolean isDescriptionPresent() {
        return !this.description_absent;
    }

    public String descriptionOrElse(String defaultValue) {
        return !this.description_absent ? this.description_value : defaultValue;
    }

    public boolean isUrlPresent() {
        return !this.url_absent;
    }

    public String urlOrElse(String defaultValue) {
        return !this.url_absent ? this.url_value : defaultValue;
    }

    public boolean isTimestampPresent() {
        return !this.timestamp_absent;
    }

    public Instant timestampOrElse(Instant defaultValue) {
        return !this.timestamp_absent ? this.timestamp_value : defaultValue;
    }

    public boolean isColorPresent() {
        return !this.color_absent;
    }

    public Color colorOrElse(Color defaultValue) {
        return !this.color_absent ? this.color_value : defaultValue;
    }

    public boolean isImagePresent() {
        return !this.image_absent;
    }

    public String imageOrElse(String defaultValue) {
        return !this.image_absent ? this.image_value : defaultValue;
    }

    public boolean isThumbnailPresent() {
        return !this.thumbnail_absent;
    }

    public String thumbnailOrElse(String defaultValue) {
        return !this.thumbnail_absent ? this.thumbnail_value : defaultValue;
    }

    public static Builder builder() {
        return new Builder();
    }

    private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
        ArrayList<T> list;
        if (iterable instanceof Collection) {
            int size = ((Collection)iterable).size();
            if (size == 0) {
                return Collections.emptyList();
            }
            list = new ArrayList();
        } else {
            list = new ArrayList<T>();
        }
        for (T element : iterable) {
            if (skipNulls && element == null) continue;
            if (checkNulls) {
                Objects.requireNonNull(element, "element");
            }
            list.add(element);
        }
        return list;
    }

    private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
        switch (list.size()) {
            case 0: {
                return Collections.emptyList();
            }
            case 1: {
                return Collections.singletonList(list.get(0));
            }
        }
        if (clone) {
            return Collections.unmodifiableList(new ArrayList<T>(list));
        }
        if (list instanceof ArrayList) {
            ((ArrayList)list).trimToSize();
        }
        return Collections.unmodifiableList(list);
    }

    @Generated(from="EmbedCreateSpecGenerator", generator="Immutables")
    public static final class Builder {
        private static final long OPT_BIT_FIELDS = 1L;
        private long optBits;
        private Possible<String> title_possible = Possible.absent();
        private Possible<String> description_possible = Possible.absent();
        private Possible<String> url_possible = Possible.absent();
        private Possible<Instant> timestamp_possible = Possible.absent();
        private Possible<Color> color_possible = Possible.absent();
        private Possible<String> image_possible = Possible.absent();
        private Possible<String> thumbnail_possible = Possible.absent();
        private EmbedCreateFields.Footer footer;
        private EmbedCreateFields.Author author;
        private List<EmbedCreateFields.Field> fields = new ArrayList<EmbedCreateFields.Field>();

        private Builder() {
        }

        public final Builder from(EmbedCreateSpec instance) {
            return this.from((EmbedCreateSpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(EmbedCreateSpecGenerator instance) {
            Objects.requireNonNull(instance, "instance");
            this.title(instance.title());
            this.description(instance.description());
            this.url(instance.url());
            this.timestamp(instance.timestamp());
            this.color(instance.color());
            EmbedCreateFields.Footer footerValue = instance.footer();
            if (footerValue != null) {
                this.footer(footerValue);
            }
            this.image(instance.image());
            this.thumbnail(instance.thumbnail());
            EmbedCreateFields.Author authorValue = instance.author();
            if (authorValue != null) {
                this.author(authorValue);
            }
            this.addAllFields(instance.fields());
            return this;
        }

        @CanIgnoreReturnValue
        public Builder title(Possible<String> value) {
            this.title_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder title(String value) {
            this.title_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(Possible<String> value) {
            this.description_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder description(String value) {
            this.description_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder url(Possible<String> value) {
            this.url_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder url(String value) {
            this.url_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder timestamp(Possible<Instant> value) {
            this.timestamp_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder timestamp(Instant value) {
            this.timestamp_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder color(Possible<Color> value) {
            this.color_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder color(Color value) {
            this.color_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder footer(String text, @Nullable String iconUrl) {
            return this.footer(ImmutableEmbedCreateFields.Footer.of(text, iconUrl));
        }

        @CanIgnoreReturnValue
        public final Builder footer(@Nullable EmbedCreateFields.Footer footer) {
            this.footer = footer == null ? null : ImmutableEmbedCreateFields.Footer.copyOf(footer);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder image(Possible<String> value) {
            this.image_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder image(String value) {
            this.image_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public Builder thumbnail(Possible<String> value) {
            this.thumbnail_possible = value;
            return this;
        }

        @CanIgnoreReturnValue
        public Builder thumbnail(String value) {
            this.thumbnail_possible = Possible.of((Object)value);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder author(String name, @Nullable String url, @Nullable String iconUrl) {
            return this.author(ImmutableEmbedCreateFields.Author.of(name, url, iconUrl));
        }

        @CanIgnoreReturnValue
        public final Builder author(@Nullable EmbedCreateFields.Author author) {
            this.author = author == null ? null : ImmutableEmbedCreateFields.Author.copyOf(author);
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder addField(EmbedCreateFields.Field element) {
            element = ImmutableEmbedCreateFields.Field.copyOf(element);
            this.fields.add(Objects.requireNonNull(element, "fields element"));
            this.optBits |= 1L;
            return this;
        }

        public final Builder addField(String name, String value, boolean inline) {
            return this.addField(ImmutableEmbedCreateFields.Field.of(name, value, inline));
        }

        @CanIgnoreReturnValue
        public final Builder addFields(EmbedCreateFields.Field ... elements) {
            for (EmbedCreateFields.Field element : elements) {
                element = ImmutableEmbedCreateFields.Field.copyOf(element);
                this.fields.add(Objects.requireNonNull(element, "fields element"));
            }
            this.optBits |= 1L;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder fields(Iterable<? extends EmbedCreateFields.Field> elements) {
            this.fields.clear();
            return this.addAllFields(elements);
        }

        @CanIgnoreReturnValue
        public final Builder addAllFields(Iterable<? extends EmbedCreateFields.Field> elements) {
            for (EmbedCreateFields.Field field : elements) {
                ImmutableEmbedCreateFields.Field field2 = ImmutableEmbedCreateFields.Field.copyOf(field);
                this.fields.add(Objects.requireNonNull(field2, "fields element"));
            }
            this.optBits |= 1L;
            return this;
        }

        public EmbedCreateSpec build() {
            return EmbedCreateSpec.validate(new EmbedCreateSpec(this));
        }

        private boolean fieldsIsSet() {
            return (this.optBits & 1L) != 0L;
        }

        private Possible<String> title_build() {
            return this.title_possible;
        }

        private Possible<String> description_build() {
            return this.description_possible;
        }

        private Possible<String> url_build() {
            return this.url_possible;
        }

        private Possible<Instant> timestamp_build() {
            return this.timestamp_possible;
        }

        private Possible<Color> color_build() {
            return this.color_possible;
        }

        private Possible<String> image_build() {
            return this.image_possible;
        }

        private Possible<String> thumbnail_build() {
            return this.thumbnail_possible;
        }
    }

    @Generated(from="EmbedCreateSpecGenerator", generator="Immutables")
    private final class InitShim {
        private byte fieldsBuildStage = 0;
        private List<EmbedCreateFields.Field> fields;

        private InitShim() {
        }

        List<EmbedCreateFields.Field> fields() {
            if (this.fieldsBuildStage == -1) {
                throw new IllegalStateException(this.formatInitCycleMessage());
            }
            if (this.fieldsBuildStage == 0) {
                this.fieldsBuildStage = (byte)-1;
                this.fields = EmbedCreateSpec.createUnmodifiableList(false, EmbedCreateSpec.createSafeList(EmbedCreateSpec.this.fieldsInitialize(), true, false));
                this.fieldsBuildStage = 1;
            }
            return this.fields;
        }

        void fields(List<EmbedCreateFields.Field> fields) {
            this.fields = fields;
            this.fieldsBuildStage = 1;
        }

        private String formatInitCycleMessage() {
            ArrayList<String> attributes = new ArrayList<String>();
            if (this.fieldsBuildStage == -1) {
                attributes.add("fields");
            }
            return "Cannot build EmbedCreateSpec, attribute initializers form cycle " + attributes;
        }
    }
}

