/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.spec.CategoryEditMonoGenerator;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="CategoryEditMonoGenerator", generator="Immutables")
public final class CategoryEditMono
extends CategoryEditMonoGenerator {
    @Nullable
    private final String reason;
    private final String name_value;
    private final boolean name_absent;
    private final Integer position_value;
    private final boolean position_absent;
    private final List<PermissionOverwrite> permissionOverwrites_value;
    private final boolean permissionOverwrites_absent;
    private final Category category;
    private static final byte STAGE_INITIALIZING = -1;
    private static final byte STAGE_UNINITIALIZED = 0;
    private static final byte STAGE_INITIALIZED = 1;
    private volatile transient InitShim initShim = new InitShim();

    private CategoryEditMono(Category category) {
        this.category = Objects.requireNonNull(category, "category");
        this.reason = null;
        Possible name$impl = Possible.absent();
        Possible position$impl = Possible.absent();
        Possible permissionOverwrites$impl = Possible.absent();
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.initShim = null;
    }

    private CategoryEditMono(@Nullable String reason, Possible<String> name, Possible<Integer> position, Possible<List<PermissionOverwrite>> permissionOverwrites, Category category) {
        this.reason = reason;
        Possible<String> name$impl = name;
        Possible<Integer> position$impl = position;
        Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
        this.category = category;
        this.name_value = name$impl.toOptional().orElse(null);
        this.name_absent = name$impl.isAbsent();
        this.position_value = position$impl.toOptional().orElse(null);
        this.position_absent = position$impl.isAbsent();
        this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
        this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
        this.initShim = null;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    public Possible<String> name() {
        return this.name_absent ? Possible.absent() : Possible.of((Object)this.name_value);
    }

    @Override
    public Possible<Integer> position() {
        return this.position_absent ? Possible.absent() : Possible.of((Object)this.position_value);
    }

    @Override
    public Possible<List<PermissionOverwrite>> permissionOverwrites() {
        return this.permissionOverwrites_absent ? Possible.absent() : Possible.of(this.permissionOverwrites_value);
    }

    @Override
    public Category category() {
        return this.category;
    }

    public final CategoryEditMono withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return new CategoryEditMono(value, this.name(), this.position(), this.permissionOverwrites(), this.category);
    }

    public CategoryEditMono withName(Possible<String> value) {
        Possible<String> newValue = Objects.requireNonNull(value);
        return new CategoryEditMono(this.reason, newValue, this.position(), this.permissionOverwrites(), this.category);
    }

    public CategoryEditMono withName(String value) {
        Possible newValue = Possible.of((Object)value);
        return new CategoryEditMono(this.reason, (Possible<String>)newValue, this.position(), this.permissionOverwrites(), this.category);
    }

    public CategoryEditMono withPosition(Possible<Integer> value) {
        Possible<Integer> newValue = Objects.requireNonNull(value);
        return new CategoryEditMono(this.reason, this.name(), newValue, this.permissionOverwrites(), this.category);
    }

    public CategoryEditMono withPosition(Integer value) {
        Possible newValue = Possible.of((Object)value);
        return new CategoryEditMono(this.reason, this.name(), (Possible<Integer>)newValue, this.permissionOverwrites(), this.category);
    }

    public CategoryEditMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
        Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
        return new CategoryEditMono(this.reason, this.name(), this.position(), newValue, this.category);
    }

    public CategoryEditMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
        Possible newValue = Possible.of(StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
        return new CategoryEditMono(this.reason, this.name(), this.position(), (Possible<List<PermissionOverwrite>>)newValue, this.category);
    }

    @SafeVarargs
    public final CategoryEditMono withPermissionOverwrites(PermissionOverwrite ... elements) {
        Possible newValue = Possible.of(Arrays.asList(elements));
        return new CategoryEditMono(this.reason, this.name(), this.position(), (Possible<List<PermissionOverwrite>>)newValue, this.category);
    }

    public final CategoryEditMono withCategory(Category value) {
        if (this.category == value) {
            return this;
        }
        Category newValue = Objects.requireNonNull(value, "category");
        return new CategoryEditMono(this.reason, this.name(), this.position(), this.permissionOverwrites(), newValue);
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof CategoryEditMono && this.equalTo(0, (CategoryEditMono)another);
    }

    private boolean equalTo(int synthetic, CategoryEditMono another) {
        return Objects.equals(this.reason, another.reason) && this.name().equals(another.name()) && this.position().equals(another.position()) && Objects.equals(this.permissionOverwrites_value, another.permissionOverwrites_value) && this.category.equals(another.category);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + this.name().hashCode();
        h += (h << 5) + this.position().hashCode();
        h += (h << 5) + Objects.hashCode(this.permissionOverwrites_value);
        h += (h << 5) + this.category.hashCode();
        return h;
    }

    @Override
    public String toString() {
        return "CategoryEditMono{reason=" + this.reason + ", name=" + this.name().toString() + ", position=" + this.position().toString() + ", permissionOverwrites=" + Objects.toString(this.permissionOverwrites_value) + ", category=" + this.category + "}";
    }

    public static CategoryEditMono of(Category category) {
        return new CategoryEditMono(category);
    }

    static CategoryEditMono copyOf(CategoryEditMonoGenerator instance) {
        if (instance instanceof CategoryEditMono) {
            return (CategoryEditMono)instance;
        }
        return CategoryEditMono.of(instance.category()).withReason(instance.reason()).withName((Possible<String>)instance.name()).withPosition((Possible<Integer>)instance.position()).withPermissionOverwrites((Possible<List<PermissionOverwrite>>)instance.permissionOverwrites());
    }

    public boolean isNamePresent() {
        return !this.name_absent;
    }

    public String nameOrElse(String defaultValue) {
        return !this.name_absent ? this.name_value : defaultValue;
    }

    public boolean isPositionPresent() {
        return !this.position_absent;
    }

    public Integer positionOrElse(Integer defaultValue) {
        return !this.position_absent ? this.position_value : defaultValue;
    }

    public boolean isPermissionOverwritesPresent() {
        return !this.permissionOverwrites_absent;
    }

    public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
        return !this.permissionOverwrites_absent ? this.permissionOverwrites_value : defaultValue;
    }

    @Generated(from="CategoryEditMonoGenerator", generator="Immutables")
    private final class InitShim {
        private InitShim() {
        }

        private String formatInitCycleMessage() {
            ArrayList attributes = new ArrayList();
            return "Cannot build CategoryEditMono, attribute initializers form cycle " + attributes;
        }
    }
}

