/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import discord4j.core.spec.BanQuerySpecGenerator;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

@Generated(from="BanQuerySpecGenerator", generator="Immutables")
public final class BanQuerySpec
implements BanQuerySpecGenerator {
    @Nullable
    private final String reason;
    @Nullable
    private final Integer deleteMessageDays;
    private static final BanQuerySpec INSTANCE = BanQuerySpec.validate(new BanQuerySpec());

    private BanQuerySpec() {
        this.reason = null;
        this.deleteMessageDays = null;
    }

    private BanQuerySpec(@Nullable String reason, @Nullable Integer deleteMessageDays) {
        this.reason = reason;
        this.deleteMessageDays = deleteMessageDays;
    }

    @Override
    @Nullable
    public String reason() {
        return this.reason;
    }

    @Override
    @Nullable
    public Integer deleteMessageDays() {
        return this.deleteMessageDays;
    }

    public final BanQuerySpec withReason(@Nullable String value) {
        if (Objects.equals(this.reason, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(value, this.deleteMessageDays));
    }

    public final BanQuerySpec withDeleteMessageDays(@Nullable Integer value) {
        if (Objects.equals(this.deleteMessageDays, value)) {
            return this;
        }
        return BanQuerySpec.validate(new BanQuerySpec(this.reason, value));
    }

    public boolean equals(Object another) {
        if (this == another) {
            return true;
        }
        return another instanceof BanQuerySpec && this.equalTo(0, (BanQuerySpec)another);
    }

    private boolean equalTo(int synthetic, BanQuerySpec another) {
        return Objects.equals(this.reason, another.reason) && Objects.equals(this.deleteMessageDays, another.deleteMessageDays);
    }

    public int hashCode() {
        int h = 5381;
        h += (h << 5) + Objects.hashCode(this.reason);
        h += (h << 5) + Objects.hashCode(this.deleteMessageDays);
        return h;
    }

    public String toString() {
        return "BanQuerySpec{reason=" + this.reason + ", deleteMessageDays=" + this.deleteMessageDays + "}";
    }

    public static BanQuerySpec create() {
        return INSTANCE;
    }

    private static BanQuerySpec validate(BanQuerySpec instance) {
        return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
    }

    static BanQuerySpec copyOf(BanQuerySpecGenerator instance) {
        if (instance instanceof BanQuerySpec) {
            return (BanQuerySpec)instance;
        }
        return BanQuerySpec.builder().from(instance).build();
    }

    public static Builder builder() {
        return new Builder();
    }

    @Generated(from="BanQuerySpecGenerator", generator="Immutables")
    public static final class Builder {
        private String reason;
        private Integer deleteMessageDays;

        private Builder() {
        }

        public final Builder from(BanQuerySpec instance) {
            return this.from((BanQuerySpecGenerator)instance);
        }

        @CanIgnoreReturnValue
        final Builder from(BanQuerySpecGenerator instance) {
            Integer deleteMessageDaysValue;
            Objects.requireNonNull(instance, "instance");
            String reasonValue = instance.reason();
            if (reasonValue != null) {
                this.reason(reasonValue);
            }
            if ((deleteMessageDaysValue = instance.deleteMessageDays()) != null) {
                this.deleteMessageDays(deleteMessageDaysValue);
            }
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder reason(@Nullable String reason) {
            this.reason = reason;
            return this;
        }

        @CanIgnoreReturnValue
        public final Builder deleteMessageDays(@Nullable Integer deleteMessageDays) {
            this.deleteMessageDays = deleteMessageDays;
            return this;
        }

        public BanQuerySpec build() {
            return BanQuerySpec.validate(new BanQuerySpec(this.reason, this.deleteMessageDays));
        }
    }
}

