/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.retriever;

import discord4j.common.store.Store;
import discord4j.common.store.action.read.ReadActions;
import discord4j.common.store.api.StoreAction;
import discord4j.common.store.api.object.ExactResultNotAvailableException;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.retriever.EntityRetriever;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.UserData;
import java.util.Collections;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class StoreEntityRetriever
implements EntityRetriever {
    private final GatewayDiscordClient gateway;
    private final Store store;

    public StoreEntityRetriever(GatewayDiscordClient gateway) {
        this.gateway = gateway;
        this.store = gateway.getGatewayResources().getStore();
    }

    @Override
    public Mono<Channel> getChannelById(Snowflake channelId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getChannelById((long)channelId.asLong()))).map(data -> EntityUtil.getChannel(this.gateway, data));
    }

    @Override
    public Mono<Guild> getGuildById(Snowflake guildId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getGuildById((long)guildId.asLong()))).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<GuildEmoji> getGuildEmojiById(Snowflake guildId, Snowflake emojiId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getEmojiById((long)guildId.asLong(), (long)emojiId.asLong()))).map(data -> new GuildEmoji(this.gateway, (EmojiData)data, guildId.asLong()));
    }

    @Override
    public Mono<Member> getMemberById(Snowflake guildId, Snowflake userId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getMemberById((long)guildId.asLong(), (long)userId.asLong()))).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).onErrorResume(ExactResultNotAvailableException.class, ignored -> this.gateway.requestMembers(guildId, Collections.singleton(userId)).filter(member -> member.getId().equals((Object)userId)).next());
    }

    @Override
    public Mono<Message> getMessageById(Snowflake channelId, Snowflake messageId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getMessageById((long)channelId.asLong(), (long)messageId.asLong()))).map(data -> new Message(this.gateway, (MessageData)data));
    }

    @Override
    public Mono<Role> getRoleById(Snowflake guildId, Snowflake roleId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getRoleById((long)guildId.asLong(), (long)roleId.asLong()))).map(data -> new Role(this.gateway, (RoleData)data, guildId.asLong()));
    }

    @Override
    public Mono<User> getUserById(Snowflake userId) {
        return Mono.from((Publisher)this.store.execute((StoreAction)ReadActions.getUserById((long)userId.asLong()))).map(data -> new User(this.gateway, (UserData)data));
    }

    @Override
    public Flux<Guild> getGuilds() {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getGuilds())).map(data -> new Guild(this.gateway, (GuildData)data));
    }

    @Override
    public Mono<User> getSelf() {
        return this.getUserById(this.gateway.getSelfId());
    }

    @Override
    public Mono<Member> getSelfMember(Snowflake guildId) {
        return this.getMemberById(guildId, this.gateway.getSelfId());
    }

    @Override
    public Flux<Member> getGuildMembers(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getExactMembersInGuild((long)guildId.asLong()))).map(data -> new Member(this.gateway, (MemberData)data, guildId.asLong())).onErrorResume(ExactResultNotAvailableException.class, e -> this.gateway.requestMembers(guildId));
    }

    @Override
    public Flux<GuildChannel> getGuildChannels(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getChannelsInGuild((long)guildId.asLong()))).map(channelData -> EntityUtil.getChannel(this.gateway, channelData)).cast(GuildChannel.class);
    }

    @Override
    public Flux<Role> getGuildRoles(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getRolesInGuild((long)guildId.asLong()))).map(roleData -> new Role(this.gateway, (RoleData)roleData, guildId.asLong()));
    }

    @Override
    public Flux<GuildEmoji> getGuildEmojis(Snowflake guildId) {
        return Flux.from((Publisher)this.store.execute((StoreAction)ReadActions.getEmojisInGuild((long)guildId.asLong()))).map(emojiData -> new GuildEmoji(this.gateway, (EmojiData)emojiData, guildId.asLong()));
    }
}

