/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.presence;

import discord4j.core.object.presence.Activity;
import discord4j.discordjson.json.ActivityUpdateRequest;
import java.util.Optional;
import reactor.util.annotation.Nullable;

public class ClientActivity {
    private final ActivityUpdateRequest activityUpdateRequest;

    public static ClientActivity playing(String name) {
        return ClientActivity.of(Activity.Type.PLAYING, name, null);
    }

    public static ClientActivity streaming(String name, String url) {
        return ClientActivity.of(Activity.Type.STREAMING, name, url);
    }

    public static ClientActivity listening(String name) {
        return ClientActivity.of(Activity.Type.LISTENING, name, null);
    }

    public static ClientActivity watching(String name) {
        return ClientActivity.of(Activity.Type.WATCHING, name, null);
    }

    public static ClientActivity competing(String name) {
        return ClientActivity.of(Activity.Type.COMPETING, name, null);
    }

    public static ClientActivity of(Activity.Type type, String name, @Nullable String url) {
        return new ClientActivity((ActivityUpdateRequest)ActivityUpdateRequest.builder().type(type.getValue()).name(name).url(Optional.ofNullable(url)).build());
    }

    private ClientActivity(ActivityUpdateRequest activityUpdateRequest) {
        this.activityUpdateRequest = activityUpdateRequest;
    }

    public ActivityUpdateRequest getActivityUpdateRequest() {
        return this.activityUpdateRequest;
    }
}

