/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.store.action.read.ReadActions;
import discord4j.common.store.api.StoreAction;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Region;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.channel.BaseTopLevelGuildMessageChannel;
import discord4j.core.spec.VoiceChannelEditMono;
import discord4j.core.spec.VoiceChannelEditSpec;
import discord4j.core.spec.VoiceChannelJoinMono;
import discord4j.core.spec.VoiceChannelJoinSpec;
import discord4j.core.spec.legacy.LegacyVoiceChannelEditSpec;
import discord4j.core.spec.legacy.LegacyVoiceChannelJoinSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.VoiceStateUpdate;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.GatewayClientGroup;
import discord4j.gateway.json.ShardGatewayPayload;
import discord4j.voice.VoiceConnection;
import java.util.Objects;
import java.util.function.Consumer;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public final class VoiceChannel
extends BaseTopLevelGuildMessageChannel {
    public VoiceChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
    }

    public int getBitrate() {
        return (Integer)this.getData().bitrate().toOptional().orElseThrow(IllegalStateException::new);
    }

    public int getUserLimit() {
        return (Integer)this.getData().userLimit().toOptional().orElseThrow(IllegalStateException::new);
    }

    public Region.Id getRtcRegion() {
        return Possible.flatOpt((Possible)this.getData().rtcRegion()).map(Region.Id::of).orElse(Region.Id.AUTOMATIC);
    }

    public Mode getVideoQualityMode() {
        return this.getData().videoQualityMode().toOptional().map(Mode::of).orElse(Mode.AUTO);
    }

    @Deprecated
    public Mono<VoiceChannel> edit(Consumer<? super LegacyVoiceChannelEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyVoiceChannelEditSpec mutatedSpec = new LegacyVoiceChannelEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(VoiceChannel.class);
    }

    public VoiceChannelEditMono edit() {
        return VoiceChannelEditMono.of(this);
    }

    public Mono<VoiceChannel> edit(VoiceChannelEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getChannelService().modifyChannel(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> EntityUtil.getChannel(this.getClient(), data)).cast(VoiceChannel.class);
    }

    public Flux<VoiceState> getVoiceStates() {
        return Flux.from((Publisher)this.getClient().getGatewayResources().getStore().execute((StoreAction)ReadActions.getVoiceStatesInChannel((long)this.getGuildId().asLong(), (long)this.getId().asLong()))).map(data -> new VoiceState(this.getClient(), (VoiceStateData)data));
    }

    @Deprecated
    public Mono<VoiceConnection> join(Consumer<? super LegacyVoiceChannelJoinSpec> spec) {
        return Mono.defer(() -> {
            LegacyVoiceChannelJoinSpec mutatedSpec = new LegacyVoiceChannelJoinSpec(this.getClient(), this);
            spec.accept(mutatedSpec);
            return mutatedSpec.asRequest();
        });
    }

    public VoiceChannelJoinMono join() {
        return VoiceChannelJoinMono.of(this);
    }

    public Mono<VoiceConnection> join(VoiceChannelJoinSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> (Mono)spec.asRequest().apply(this));
    }

    public Mono<Void> sendConnectVoiceState(boolean selfMute, boolean selfDeaf) {
        GatewayClientGroup clientGroup = this.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(this.getGuildId());
        return clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate((VoiceStateUpdate)VoiceStateUpdate.builder().guildId(this.getGuildId().asString()).channelId(this.getId().asString()).selfMute(selfMute).selfDeaf(selfDeaf).build(), (int)shardId));
    }

    public Mono<Void> sendDisconnectVoiceState() {
        GatewayClientGroup clientGroup = this.getClient().getGatewayClientGroup();
        int shardId = clientGroup.computeShardIndex(this.getGuildId());
        return clientGroup.unicast(ShardGatewayPayload.voiceStateUpdate((VoiceStateUpdate)VoiceStateUpdate.builder().guildId(this.getGuildId().asString()).selfMute(false).selfDeaf(false).build(), (int)shardId));
    }

    public Mono<Boolean> isMemberConnected(Snowflake memberId) {
        return this.getVoiceStates().map(VoiceState::getUserId).any(arg_0 -> ((Snowflake)memberId).equals(arg_0));
    }

    public Mono<VoiceConnection> getVoiceConnection() {
        return this.getGuild().flatMap(Guild::getVoiceConnection).filterWhen(voiceConnection -> voiceConnection.getChannelId().map(channelId -> channelId.equals((Object)this.getId())));
    }

    @Override
    public String toString() {
        return "VoiceChannel{} " + super.toString();
    }

    public static enum Mode {
        UNKNOWN(-1),
        AUTO(1),
        FULL(2);

        private final int value;

        private Mode(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Mode of(int value) {
            switch (value) {
                case 1: {
                    return AUTO;
                }
                case 2: {
                    return FULL;
                }
            }
            return UNKNOWN;
        }
    }
}

