/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity.channel;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.ExtendedInvite;
import discord4j.core.object.ExtendedPermissionOverwrite;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.BaseCategorizableChannel;
import discord4j.core.object.entity.channel.BaseChannel;
import discord4j.core.object.entity.channel.BaseGuildChannel;
import discord4j.core.object.entity.channel.BaseMessageChannel;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.InviteCreateSpec;
import discord4j.core.spec.MessageCreateSpec;
import discord4j.core.spec.WebhookCreateSpec;
import discord4j.core.spec.legacy.LegacyInviteCreateSpec;
import discord4j.core.spec.legacy.LegacyMessageCreateSpec;
import discord4j.core.spec.legacy.LegacyWebhookCreateSpec;
import discord4j.discordjson.json.BulkDeleteRequest;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Permission;
import discord4j.rest.util.PermissionSet;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

class BaseGuildMessageChannel
extends BaseChannel
implements GuildMessageChannel {
    private final BaseGuildChannel guildChannel;
    private final BaseMessageChannel messageChannel;
    private final BaseCategorizableChannel categorizableChannel;

    BaseGuildMessageChannel(GatewayDiscordClient gateway, ChannelData data) {
        super(gateway, data);
        this.guildChannel = new BaseGuildChannel(gateway, data);
        this.messageChannel = new BaseMessageChannel(gateway, data);
        this.categorizableChannel = new BaseCategorizableChannel(gateway, data);
    }

    @Override
    public Snowflake getGuildId() {
        return this.guildChannel.getGuildId();
    }

    @Override
    public Mono<Guild> getGuild() {
        return this.guildChannel.getGuild();
    }

    @Override
    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.guildChannel.getGuild(retrievalStrategy);
    }

    @Override
    public Set<ExtendedPermissionOverwrite> getPermissionOverwrites() {
        return this.guildChannel.getPermissionOverwrites();
    }

    @Override
    public Optional<ExtendedPermissionOverwrite> getOverwriteForMember(Snowflake memberId) {
        return this.guildChannel.getOverwriteForMember(memberId);
    }

    @Override
    public Optional<ExtendedPermissionOverwrite> getOverwriteForRole(Snowflake roleId) {
        return this.guildChannel.getOverwriteForRole(roleId);
    }

    @Override
    public Mono<PermissionSet> getEffectivePermissions(Snowflake memberId) {
        return this.guildChannel.getEffectivePermissions(memberId);
    }

    @Override
    public Mono<PermissionSet> getEffectivePermissions(Member member) {
        return this.guildChannel.getEffectivePermissions(member);
    }

    @Override
    public String getName() {
        return this.guildChannel.getName();
    }

    @Override
    public int getRawPosition() {
        return this.guildChannel.getRawPosition();
    }

    @Override
    public Mono<Integer> getPosition() {
        return this.guildChannel.getPosition();
    }

    @Override
    public Mono<Void> addMemberOverwrite(Snowflake memberId, PermissionOverwrite overwrite, @Nullable String reason) {
        return this.guildChannel.addMemberOverwrite(memberId, overwrite, reason);
    }

    @Override
    public Mono<Void> addRoleOverwrite(Snowflake roleId, PermissionOverwrite overwrite, @Nullable String reason) {
        return this.guildChannel.addRoleOverwrite(roleId, overwrite, reason);
    }

    @Override
    public Optional<Snowflake> getLastMessageId() {
        return this.messageChannel.getLastMessageId();
    }

    @Override
    public Mono<Message> getLastMessage() {
        return this.messageChannel.getLastMessage();
    }

    @Override
    public Mono<Message> getLastMessage(EntityRetrievalStrategy retrievalStrategy) {
        return this.messageChannel.getLastMessage(retrievalStrategy);
    }

    @Override
    public Optional<Instant> getLastPinTimestamp() {
        return this.messageChannel.getLastPinTimestamp();
    }

    @Override
    public Mono<Message> createMessage(Consumer<? super LegacyMessageCreateSpec> spec) {
        return this.messageChannel.createMessage(spec);
    }

    @Override
    public Mono<Message> createMessage(MessageCreateSpec spec) {
        return this.messageChannel.createMessage(spec);
    }

    @Override
    public Mono<Void> type() {
        return this.messageChannel.type();
    }

    @Override
    public Flux<Long> typeUntil(Publisher<?> until) {
        return this.messageChannel.typeUntil(until);
    }

    @Override
    public Flux<Message> getMessagesBefore(Snowflake messageId) {
        return this.messageChannel.getMessagesBefore(messageId);
    }

    @Override
    public Flux<Message> getMessagesAfter(Snowflake messageId) {
        return this.messageChannel.getMessagesAfter(messageId);
    }

    @Override
    public Mono<Message> getMessageById(Snowflake id) {
        return this.messageChannel.getMessageById(id);
    }

    @Override
    public Mono<Message> getMessageById(Snowflake id, EntityRetrievalStrategy retrievalStrategy) {
        return this.messageChannel.getMessageById(id, retrievalStrategy);
    }

    @Override
    public Flux<Message> getPinnedMessages() {
        return this.messageChannel.getPinnedMessages();
    }

    @Override
    public Optional<Snowflake> getCategoryId() {
        return this.categorizableChannel.getCategoryId();
    }

    @Override
    public Mono<Category> getCategory() {
        return this.categorizableChannel.getCategory();
    }

    @Override
    public Mono<Category> getCategory(EntityRetrievalStrategy retrievalStrategy) {
        return this.categorizableChannel.getCategory(retrievalStrategy);
    }

    @Override
    public Mono<ExtendedInvite> createInvite(Consumer<? super LegacyInviteCreateSpec> spec) {
        return this.categorizableChannel.createInvite(spec);
    }

    @Override
    public Mono<ExtendedInvite> createInvite(InviteCreateSpec spec) {
        return this.categorizableChannel.createInvite(spec);
    }

    @Override
    public Flux<ExtendedInvite> getInvites() {
        return this.categorizableChannel.getInvites();
    }

    @Override
    public Optional<String> getTopic() {
        return Possible.flatOpt((Possible)this.getData().topic());
    }

    @Override
    public Flux<Snowflake> bulkDelete(Publisher<Snowflake> messageIds) {
        return this.getRestChannel().bulkDelete(messageIds);
    }

    @Override
    public Flux<Message> bulkDeleteMessages(Publisher<Message> messages) {
        Instant timeLimit = Instant.now().minus(Duration.ofDays(14L));
        return Flux.from(messages).distinct(Message::getId).buffer(100).flatMap(allMessages -> {
            ArrayList<Message> eligibleMessages = new ArrayList<Message>(0);
            ArrayList<Message> ineligibleMessages = new ArrayList<Message>(0);
            for (Message message : allMessages) {
                if (message.getId().getTimestamp().isBefore(timeLimit)) {
                    ineligibleMessages.add(message);
                    continue;
                }
                eligibleMessages.add(message);
            }
            if (eligibleMessages.size() == 1) {
                ineligibleMessages.add((Message)eligibleMessages.get(0));
                eligibleMessages.clear();
            }
            Collection eligibleIds = eligibleMessages.stream().map(Message::getId).map(Snowflake::asString).collect(Collectors.toList());
            return Mono.just((Object)eligibleIds).filter(chunk -> !chunk.isEmpty()).flatMap(chunk -> this.getClient().getRestClient().getChannelService().bulkDeleteMessages(this.getId().asLong(), (BulkDeleteRequest)BulkDeleteRequest.builder().messages((Iterable)chunk).build())).thenMany((Publisher)Flux.fromIterable(ineligibleMessages));
        });
    }

    @Override
    public Mono<Webhook> createWebhook(Consumer<? super LegacyWebhookCreateSpec> spec) {
        return Mono.defer(() -> {
            LegacyWebhookCreateSpec mutatedSpec = new LegacyWebhookCreateSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getWebhookService().createWebhook(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new Webhook(this.getClient(), (WebhookData)data));
    }

    @Override
    public Mono<Webhook> createWebhook(WebhookCreateSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getWebhookService().createWebhook(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new Webhook(this.getClient(), (WebhookData)data));
    }

    @Override
    public Flux<Webhook> getWebhooks() {
        return this.getClient().getRestClient().getWebhookService().getChannelWebhooks(this.getId().asLong()).map(data -> new Webhook(this.getClient(), (WebhookData)data));
    }

    @Override
    public Flux<Member> getMembers() {
        return this.getGuild().flatMapMany(Guild::getMembers).filterWhen(member -> this.getEffectivePermissions(member.getId()).map(permissions -> permissions.contains((Object)Permission.VIEW_CHANNEL)));
    }

    @Override
    public String toString() {
        return "GuildMessageChannel{guildChannel=" + this.guildChannel + ", messageChannel=" + this.messageChannel + "} " + super.toString();
    }
}

