/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Message;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.WebhookEditMono;
import discord4j.core.spec.WebhookEditSpec;
import discord4j.core.spec.WebhookEditWithTokenMono;
import discord4j.core.spec.WebhookEditWithTokenSpec;
import discord4j.core.spec.WebhookExecuteMono;
import discord4j.core.spec.WebhookExecuteSpec;
import discord4j.core.spec.WebhookMessageEditMono;
import discord4j.core.spec.WebhookMessageEditSpec;
import discord4j.core.spec.legacy.LegacyWebhookEditSpec;
import discord4j.core.spec.legacy.LegacyWebhookEditWithTokenSpec;
import discord4j.core.spec.legacy.LegacyWebhookExecuteSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookData;
import discord4j.discordjson.json.WebhookPartialChannelData;
import discord4j.discordjson.json.WebhookPartialGuildData;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class Webhook
implements Entity {
    private final GatewayDiscordClient gateway;
    private final WebhookData data;

    public Webhook(GatewayDiscordClient gateway, WebhookData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public WebhookData getData() {
        return this.data;
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public Snowflake getGuildId() {
        return Snowflake.of((Id)((Id)((Optional)this.data.guildId().get()).get()));
    }

    public Mono<Guild> getGuild() {
        return this.gateway.getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public Snowflake getChannelId() {
        return Snowflake.of((Id)((Id)this.data.channelId().get()));
    }

    public Mono<GuildMessageChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(GuildMessageChannel.class);
    }

    public Mono<GuildMessageChannel> getChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getChannelId()).cast(GuildMessageChannel.class);
    }

    public Optional<User> getCreator() {
        return this.data.user().toOptional().map(userData -> new User(this.gateway, (UserData)userData));
    }

    public Optional<String> getName() {
        return this.data.name();
    }

    public Optional<String> getAvatar() {
        return this.data.avatar();
    }

    public Optional<String> getToken() {
        return this.data.token().toOptional();
    }

    public Optional<Snowflake> getApplicationId() {
        return this.data.applicationId().map(Snowflake::of);
    }

    public Optional<Snowflake> getSourceGuildId() {
        return this.data.sourceGuild().toOptional().map(WebhookPartialGuildData::id).map(Snowflake::of);
    }

    public Optional<String> getSourceGuildName() {
        return this.data.sourceGuild().toOptional().map(WebhookPartialGuildData::name);
    }

    public Optional<Snowflake> getSourceChannelId() {
        return this.data.sourceChannel().toOptional().map(WebhookPartialChannelData::id).map(Snowflake::of);
    }

    public Optional<String> getSourceChannelName() {
        return this.data.sourceChannel().toOptional().map(WebhookPartialChannelData::name);
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getWebhookService().deleteWebhook(this.getId().asLong(), reason);
    }

    public Mono<Void> deleteWithToken() {
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalStateException("Missing token");
            }
            return this.gateway.getRestClient().getWebhookService().deleteWebhookWithToken(this.getId().asLong(), this.getToken().get());
        });
    }

    @Deprecated
    public Mono<Webhook> edit(Consumer<? super LegacyWebhookEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyWebhookEditSpec mutatedSpec = new LegacyWebhookEditSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getWebhookService().modifyWebhook(this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason());
        }).map(data -> new Webhook(this.gateway, (WebhookData)data));
    }

    public WebhookEditMono edit() {
        return WebhookEditMono.of(this);
    }

    public Mono<Webhook> edit(WebhookEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getWebhookService().modifyWebhook(this.getId().asLong(), spec.asRequest(), spec.reason())).map(data -> new Webhook(this.gateway, (WebhookData)data));
    }

    @Deprecated
    public Mono<Webhook> editWithToken(Consumer<? super LegacyWebhookEditWithTokenSpec> spec) {
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalStateException("Can't edit webhook.");
            }
            LegacyWebhookEditWithTokenSpec mutatedSpec = new LegacyWebhookEditWithTokenSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getWebhookService().modifyWebhookWithToken(this.getId().asLong(), this.getToken().get(), mutatedSpec.asRequest());
        }).map(data -> new Webhook(this.gateway, (WebhookData)data));
    }

    public WebhookEditWithTokenMono editWithToken() {
        return WebhookEditWithTokenMono.of(this);
    }

    public Mono<Webhook> editWithToken(WebhookEditWithTokenSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.gateway.getRestClient().getWebhookService().modifyWebhookWithToken(this.getId().asLong(), this.getToken().orElseThrow(() -> new IllegalStateException("Can't edit webhook.")), spec.asRequest())).map(data -> new Webhook(this.gateway, (WebhookData)data));
    }

    @Deprecated
    public Mono<Void> execute(Consumer<? super LegacyWebhookExecuteSpec> spec) {
        return this.execute(false, spec).cast(Void.class);
    }

    public WebhookExecuteMono execute() {
        return WebhookExecuteMono.of(false, this);
    }

    public Mono<Void> execute(WebhookExecuteSpec spec) {
        return this.execute(false, spec).cast(Void.class);
    }

    @Deprecated
    public Mono<Message> execute(boolean wait, Consumer<? super LegacyWebhookExecuteSpec> spec) {
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalArgumentException("Can't execute webhook.");
            }
            LegacyWebhookExecuteSpec mutatedSpec = new LegacyWebhookExecuteSpec();
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getWebhookService().executeWebhook(this.getId().asLong(), this.getToken().get(), wait, mutatedSpec.asRequest()).map(data -> new Message(this.gateway, (MessageData)data));
        });
    }

    public Mono<Message> execute(boolean wait, WebhookExecuteSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalArgumentException("Can't execute webhook.");
            }
            return this.gateway.getRestClient().getWebhookService().executeWebhook(this.getId().asLong(), this.getToken().get(), wait, spec.asRequest()).map(data -> new Message(this.gateway, (MessageData)data));
        });
    }

    @Deprecated
    public Mono<Message> executeAndWait(Consumer<? super LegacyWebhookExecuteSpec> spec) {
        return this.execute(true, spec);
    }

    public Mono<Message> executeAndWait(WebhookExecuteSpec spec) {
        return this.execute(true, spec);
    }

    public Mono<Message> getMessage(Snowflake messageId) {
        Objects.requireNonNull(messageId);
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalArgumentException("Can't get message with this webhook.");
            }
            return this.gateway.getRestClient().getWebhookService().getWebhookMessage(this.getId().asLong(), this.getToken().get(), messageId.asString()).map(data -> new Message(this.gateway, (MessageData)data));
        });
    }

    public WebhookMessageEditMono editMessage(Snowflake messageId) {
        return WebhookMessageEditMono.of(messageId, this);
    }

    public Mono<Message> editMessage(Snowflake messageId, WebhookMessageEditSpec spec) {
        Objects.requireNonNull(messageId);
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalArgumentException("Can't edit message with this webhook.");
            }
            return this.gateway.getRestClient().getWebhookService().modifyWebhookMessage(this.getId().asLong(), this.getToken().get(), messageId.asString(), spec.asRequest()).map(data -> new Message(this.gateway, (MessageData)data));
        });
    }

    public Mono<Void> deleteMessage(Snowflake messageId) {
        Objects.requireNonNull(messageId);
        return Mono.defer(() -> {
            if (!this.getToken().isPresent()) {
                throw new IllegalArgumentException("Can't delete message with this webhook.");
            }
            return this.gateway.getRestClient().getWebhookService().deleteWebhookMessage(this.getId().asLong(), this.getToken().get(), messageId.asString());
        });
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Webhook{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        INCOMING(1),
        CHANNEL_FOLLOWER(2);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return INCOMING;
                }
                case 2: {
                    return CHANNEL_FOLLOWER;
                }
            }
            return UNKNOWN;
        }

        public int getValue() {
            return this.value;
        }
    }
}

