/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.store.action.read.ReadActions;
import discord4j.common.store.api.StoreAction;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.VoiceState;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.object.presence.Presence;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.BanQuerySpec;
import discord4j.core.spec.GuildMemberEditMono;
import discord4j.core.spec.GuildMemberEditSpec;
import discord4j.core.spec.MemberBanQueryMono;
import discord4j.core.spec.legacy.LegacyBanQuerySpec;
import discord4j.core.spec.legacy.LegacyGuildMemberEditSpec;
import discord4j.core.util.ImageUtil;
import discord4j.core.util.OrderUtil;
import discord4j.core.util.PermissionUtil;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.VoiceStateData;
import discord4j.discordjson.json.gateway.ImmutableRequestGuildMembers;
import discord4j.discordjson.json.gateway.RequestGuildMembers;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Color;
import discord4j.rest.util.Image;
import discord4j.rest.util.PermissionSet;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.reactivestreams.Publisher;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.math.MathFlux;
import reactor.util.annotation.Nullable;

public class PartialMember
extends User {
    private static final String AVATAR_IMAGE_PATH = "guilds/%s/users/%s/avatars/%s";
    private final PartialMemberData data;
    private final long guildId;

    public PartialMember(GatewayDiscordClient gateway, UserData userData, PartialMemberData memberData, long guildId) {
        super(gateway, userData);
        this.data = Objects.requireNonNull(memberData);
        this.guildId = guildId;
    }

    public PartialMemberData getMemberData() {
        return this.data;
    }

    public Mono<Member> asFullMember() {
        return this.asMember(this.getGuildId());
    }

    public Set<Snowflake> getRoleIds() {
        return this.data.roles().stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Flux<Role> getRoles() {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Flux<Role> getRoles(EntityRetrievalStrategy retrievalStrategy) {
        return Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Mono<Role> getHighestRole() {
        return MathFlux.max((Publisher)Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().getRoleById(this.getGuildId(), (Snowflake)id)), OrderUtil.ROLE_ORDER);
    }

    public Mono<Role> getHighestRole(EntityRetrievalStrategy retrievalStrategy) {
        return MathFlux.max((Publisher)Flux.fromIterable(this.getRoleIds()).flatMap(id -> this.getClient().withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id)), OrderUtil.ROLE_ORDER);
    }

    public Optional<Instant> getJoinTime() {
        return this.data.joinedAt().map(it -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)it, Instant::from));
    }

    public Optional<Instant> getPremiumTime() {
        return Possible.flatOpt((Possible)this.data.premiumSince()).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Optional<Instant> getCommunicationDisabledUntil() {
        return Possible.flatOpt((Possible)this.data.communicationDisabledUntil()).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Mono<Guild> getGuild() {
        return this.getClient().getGuildById(this.getGuildId());
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getClient().withRetrievalStrategy(retrievalStrategy).getGuildById(this.getGuildId());
    }

    public String getDisplayName() {
        return this.getNickname().orElse(this.getUsername());
    }

    public Optional<String> getNickname() {
        return Possible.flatOpt((Possible)this.data.nick());
    }

    public String getNicknameMention() {
        return "<@!" + this.getId().asString() + ">";
    }

    public final boolean hasAnimatedGuildAvatar() {
        String avatar = this.data.avatar().orElse(null);
        return avatar != null && avatar.startsWith("a_");
    }

    public final Optional<String> getGuildAvatarUrl(Image.Format format) {
        return this.data.avatar().map(avatar -> ImageUtil.getUrl(String.format(AVATAR_IMAGE_PATH, this.guildId, this.getId().asString(), avatar), format));
    }

    public final String getEffectiveAvatarUrl() {
        boolean animated = this.hasAnimatedGuildAvatar();
        return this.getGuildAvatarUrl(animated ? Image.Format.GIF : Image.Format.PNG).orElse(this.getDefaultAvatarUrl());
    }

    public Mono<Image> getGuildAvatar(Image.Format format) {
        return Mono.justOrEmpty(this.getGuildAvatarUrl(format)).flatMap(Image::ofUrl);
    }

    public final Mono<Image> getEffectiveAvatar() {
        return Image.ofUrl((String)this.getEffectiveAvatarUrl());
    }

    public Mono<VoiceState> getVoiceState() {
        return Mono.from((Publisher)this.getClient().getGatewayResources().getStore().execute((StoreAction)ReadActions.getVoiceStateById((long)this.getGuildId().asLong(), (long)this.getId().asLong()))).map(bean -> new VoiceState(this.getClient(), (VoiceStateData)bean));
    }

    public Mono<Presence> getPresence() {
        if (this.getClient().getSelfId().equals((Object)this.getId())) {
            return Mono.defer(() -> {
                ImmutableRequestGuildMembers request = RequestGuildMembers.builder().guildId(this.getGuildId().asString()).addUserId(this.getId().asString()).presences(Boolean.valueOf(true)).limit(1).build();
                return this.getClient().requestMemberChunks((RequestGuildMembers)request).singleOrEmpty().flatMap(chunk -> Mono.justOrEmpty((Optional)chunk.presences().toOptional()).flatMapIterable(list -> list).next().map(Presence::new)).onErrorResume(IllegalArgumentException.class, err -> Mono.empty());
            });
        }
        return Mono.from((Publisher)this.getClient().getGatewayResources().getStore().execute((StoreAction)ReadActions.getPresenceById((long)this.getGuildId().asLong(), (long)this.getId().asLong()))).map(Presence::new);
    }

    public Mono<Void> kick() {
        return this.kick(null);
    }

    public Mono<Void> kick(@Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().removeGuildMember(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    public Mono<Void> addRole(Snowflake roleId) {
        return this.addRole(roleId, null);
    }

    public Mono<Void> addRole(Snowflake roleId, @Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().addGuildMemberRole(this.guildId, this.getId().asLong(), roleId.asLong(), reason);
    }

    public Mono<Void> removeRole(Snowflake roleId) {
        return this.removeRole(roleId, null);
    }

    public Mono<Void> removeRole(Snowflake roleId, @Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().removeGuildMemberRole(this.guildId, this.getId().asLong(), roleId.asLong(), reason);
    }

    public Mono<PermissionSet> getBasePermissions() {
        Mono getIsOwner = this.getGuild().map(guild -> guild.getOwnerId().equals((Object)this.getId()));
        Mono getEveryonePerms = this.getGuild().flatMap(Guild::getEveryoneRole).map(Role::getPermissions);
        Mono getRolePerms = this.getRoles().map(Role::getPermissions).collectList();
        return getIsOwner.filter(Predicate.isEqual(Boolean.TRUE)).flatMap(ignored -> Mono.just((Object)PermissionSet.all())).switchIfEmpty(Mono.zip((Mono)getEveryonePerms, (Mono)getRolePerms, PermissionUtil::computeBasePermissions));
    }

    public Mono<Boolean> isHigher(Member otherMember) {
        if (!this.getGuildId().equals((Object)otherMember.getGuildId())) {
            return Mono.error((Throwable)new IllegalArgumentException("The provided member is in a different guild."));
        }
        if (this.equals(otherMember)) {
            return Mono.just((Object)false);
        }
        return this.getGuild().map(Guild::getOwnerId).flatMap(ownerId -> {
            if (ownerId.equals((Object)this.getId())) {
                return Mono.just((Object)true);
            }
            if (ownerId.equals((Object)otherMember.getId())) {
                return Mono.just((Object)false);
            }
            return this.hasHigherRoles(otherMember.getRoleIds());
        });
    }

    public Mono<Boolean> isHigher(Snowflake id) {
        return this.getClient().getMemberById(this.getGuildId(), id).flatMap(this::isHigher);
    }

    public Mono<Boolean> hasHigherRoles(Set<Snowflake> otherRoles) {
        return this.getGuild().flatMapMany(Guild::getRoles).transform(OrderUtil::orderRoles).collectList().map(guildRoles -> {
            Set<Snowflake> thisRoleIds = this.getRoleIds();
            int thisHighestRolePos = guildRoles.stream().filter(role -> thisRoleIds.contains(role.getId())).max(OrderUtil.ROLE_ORDER).map(guildRoles::indexOf).orElse(0);
            int otherHighestPos = guildRoles.stream().filter(role -> otherRoles.contains(role.getId())).max(OrderUtil.ROLE_ORDER).map(guildRoles::indexOf).orElse(0);
            return thisHighestRolePos > otherHighestPos;
        });
    }

    public Mono<Color> getColor() {
        Flux rolesWithColor = this.getRoles().filter(it -> !it.getColor().equals((Object)Role.DEFAULT_COLOR));
        return MathFlux.max((Publisher)rolesWithColor, OrderUtil.ROLE_ORDER).map(Role::getColor).defaultIfEmpty((Object)Role.DEFAULT_COLOR);
    }

    @Deprecated
    public Mono<Void> ban(Consumer<? super LegacyBanQuerySpec> spec) {
        return Mono.defer(() -> {
            LegacyBanQuerySpec mutatedSpec = new LegacyBanQuerySpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getGuildService().createGuildBan(this.getGuildId().asLong(), this.getId().asLong(), (Map)mutatedSpec.asRequest(), mutatedSpec.getReason());
        });
    }

    public MemberBanQueryMono ban() {
        return MemberBanQueryMono.of(this);
    }

    public Mono<Void> ban(BanQuerySpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getGuildService().createGuildBan(this.getGuildId().asLong(), this.getId().asLong(), (Map)spec.asRequest(), spec.reason()));
    }

    public Mono<Void> unban() {
        return this.unban(null);
    }

    public Mono<Void> unban(@Nullable String reason) {
        return this.getClient().getRestClient().getGuildService().removeGuildBan(this.getGuildId().asLong(), this.getId().asLong(), reason);
    }

    @Deprecated
    public Mono<Member> edit(Consumer<? super LegacyGuildMemberEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyGuildMemberEditSpec mutatedSpec = new LegacyGuildMemberEditSpec();
            spec.accept(mutatedSpec);
            return this.getClient().getRestClient().getGuildService().modifyGuildMember(this.getGuildId().asLong(), this.getId().asLong(), mutatedSpec.asRequest(), mutatedSpec.getReason()).map(data -> new Member(this.getClient(), (MemberData)data, this.getGuildId().asLong()));
        });
    }

    public GuildMemberEditMono edit() {
        return GuildMemberEditMono.of(this);
    }

    public Mono<Member> edit(GuildMemberEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> this.getClient().getRestClient().getGuildService().modifyGuildMember(this.getGuildId().asLong(), this.getId().asLong(), spec.asRequest(), spec.reason()).map(data -> new Member(this.getClient(), (MemberData)data, this.getGuildId().asLong())));
    }

    @Override
    public String toString() {
        return "PartialMember{data=" + this.data + ", guildId=" + this.guildId + "} " + super.toString();
    }
}

