/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.Embed;
import discord4j.core.object.MessageInteraction;
import discord4j.core.object.MessageReference;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.component.MessageComponent;
import discord4j.core.object.entity.Attachment;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.PartialMember;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.Sticker;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.Webhook;
import discord4j.core.object.entity.channel.GuildChannel;
import discord4j.core.object.entity.channel.MessageChannel;
import discord4j.core.object.reaction.Reaction;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.spec.MessageEditMono;
import discord4j.core.spec.MessageEditSpec;
import discord4j.core.spec.legacy.LegacyMessageEditSpec;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.MessageInteractionData;
import discord4j.discordjson.json.MessageReferenceData;
import discord4j.discordjson.json.PartialMemberData;
import discord4j.discordjson.json.ReactionData;
import discord4j.discordjson.json.StickerData;
import discord4j.discordjson.json.SuppressEmbedsRequest;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.RestClient;
import discord4j.rest.entity.RestChannel;
import discord4j.rest.entity.RestMessage;
import discord4j.rest.util.MultipartRequest;
import discord4j.rest.util.PaginationUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public final class Message
implements Entity {
    public static final int MAX_CONTENT_LENGTH = 2000;
    public static final int MAX_TOTAL_EMBEDS_CHARACTER_LENGTH = 6000;
    private final GatewayDiscordClient gateway;
    private final MessageData data;
    private final RestMessage rest;

    public Message(GatewayDiscordClient gateway, MessageData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.rest = RestMessage.create((RestClient)gateway.getRestClient(), (Snowflake)Snowflake.of((Id)data.channelId()), (Snowflake)Snowflake.of((Id)data.id()));
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public MessageData getData() {
        return this.data;
    }

    public RestMessage getRestMessage() {
        return this.rest;
    }

    public RestChannel getRestChannel() {
        return RestChannel.create((RestClient)this.gateway.getRestClient(), (Snowflake)Snowflake.of((Id)this.data.channelId()));
    }

    public Snowflake getChannelId() {
        return Snowflake.of((Id)this.data.channelId());
    }

    public Mono<MessageChannel> getChannel() {
        return this.gateway.getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Mono<MessageChannel> getChannel(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getChannelById(this.getChannelId()).cast(MessageChannel.class);
    }

    public Optional<Snowflake> getWebhookId() {
        return this.data.webhookId().toOptional().map(Snowflake::of);
    }

    public Optional<User> getAuthor() {
        return this.data.webhookId().isAbsent() || !this.data.interaction().isAbsent() ? Optional.of(new User(this.gateway, this.data.author())) : Optional.empty();
    }

    public Mono<Member> getAuthorAsMember() {
        return Mono.justOrEmpty(this.getAuthor()).flatMap(author -> this.getGuild().map(Guild::getId).flatMap(author::asMember));
    }

    @Experimental
    public UserData getUserData() {
        return this.data.author();
    }

    public String getContent() {
        return this.data.content();
    }

    public Instant getTimestamp() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.timestamp(), Instant::from);
    }

    public Optional<Instant> getEditedTimestamp() {
        return this.data.editedTimestamp().map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public boolean isTts() {
        return this.data.tts();
    }

    public boolean mentionsEveryone() {
        return this.data.mentionEveryone();
    }

    public List<Snowflake> getUserMentionIds() {
        return this.data.mentions().stream().map(UserData::id).map(Snowflake::of).collect(Collectors.toList());
    }

    public List<PartialMember> getMemberMentions() {
        if (this.data.guildId().isAbsent()) {
            return Collections.emptyList();
        }
        long guildId = ((Id)this.data.guildId().get()).asLong();
        return this.data.mentions().stream().map(data -> new PartialMember(this.gateway, (UserData)data, (PartialMemberData)data.member().get(), guildId)).collect(Collectors.toList());
    }

    public List<User> getUserMentions() {
        return this.data.mentions().stream().map(data -> new User(this.gateway, (UserData)data)).collect(Collectors.toList());
    }

    public List<Snowflake> getRoleMentionIds() {
        return this.data.mentionRoles().stream().map(Snowflake::of).collect(Collectors.toList());
    }

    public Flux<Role> getRoleMentions() {
        return Flux.fromIterable(this.getRoleMentionIds()).flatMap(roleId -> this.getGuild().map(Guild::getId).flatMap(guildId -> this.gateway.getRoleById((Snowflake)guildId, (Snowflake)roleId)));
    }

    public Flux<Role> getRoleMentions(EntityRetrievalStrategy retrievalStrategy) {
        return Flux.fromIterable(this.getRoleMentionIds()).flatMap(roleId -> this.getGuild().map(Guild::getId).flatMap(guildId -> this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById((Snowflake)guildId, (Snowflake)roleId)));
    }

    public List<Attachment> getAttachments() {
        return this.data.attachments().stream().map(data -> new Attachment(this.gateway, (AttachmentData)data)).collect(Collectors.toList());
    }

    public List<Embed> getEmbeds() {
        return this.data.embeds().stream().map(data -> new Embed(this.gateway, (EmbedData)data)).collect(Collectors.toList());
    }

    public List<Reaction> getReactions() {
        return this.data.reactions().toOptional().map(reactions -> reactions.stream().map(data -> new Reaction(this.gateway, (ReactionData)data)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public Flux<User> getReactors(ReactionEmoji emoji) {
        Function<Map, Flux> makeRequest = params -> this.gateway.getRestClient().getChannelService().getReactions(this.getChannelId().asLong(), this.getId().asLong(), EntityUtil.getEmojiString(emoji), params);
        return PaginationUtil.paginateAfter(makeRequest, data -> Snowflake.asLong((Id)data.id()), (long)0L, (int)100).map(data -> new User(this.gateway, (UserData)data));
    }

    public boolean isPinned() {
        return this.data.pinned();
    }

    public Mono<Webhook> getWebhook() {
        return Mono.justOrEmpty(this.getWebhookId()).flatMap(this.gateway::getWebhookById);
    }

    public Optional<MessageReference> getMessageReference() {
        return this.data.messageReference().toOptional().map(data -> new MessageReference(this.gateway, (MessageReferenceData)data));
    }

    public EnumSet<Flag> getFlags() {
        return this.data.flags().toOptional().map(Flag::of).orElse(EnumSet.noneOf(Flag.class));
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return this.getChannel().ofType(GuildChannel.class).flatMap(GuildChannel::getGuild);
    }

    public Mono<Guild> getGuild(EntityRetrievalStrategy retrievalStrategy) {
        return this.getChannel(retrievalStrategy).ofType(GuildChannel.class).flatMap(guildChannel -> guildChannel.getGuild(retrievalStrategy));
    }

    public Type getType() {
        return Type.of(this.data.type());
    }

    public List<Sticker> getStickers() {
        return this.data.stickers().toOptional().orElse(Collections.emptyList()).stream().map(data -> new Sticker(this.gateway, (StickerData)data)).collect(Collectors.toList());
    }

    public Optional<Message> getReferencedMessage() {
        return Possible.flatOpt((Possible)this.data.referencedMessage()).map(data -> new Message(this.gateway, (MessageData)data));
    }

    public Optional<MessageInteraction> getInteraction() {
        return this.data.interaction().toOptional().map(data -> new MessageInteraction(this.gateway, (MessageInteractionData)data));
    }

    public List<LayoutComponent> getComponents() {
        return this.data.components().toOptional().map(components -> components.stream().map(MessageComponent::fromData).filter(component -> component instanceof LayoutComponent).map(component -> (LayoutComponent)component).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    @Deprecated
    public Mono<Message> edit(Consumer<? super LegacyMessageEditSpec> spec) {
        return Mono.defer(() -> {
            LegacyMessageEditSpec mutatedSpec = new LegacyMessageEditSpec();
            this.getClient().getRestClient().getRestResources().getAllowedMentions().ifPresent(mutatedSpec::setAllowedMentions);
            spec.accept(mutatedSpec);
            return this.gateway.getRestClient().getChannelService().editMessage(this.getChannelId().asLong(), this.getId().asLong(), MultipartRequest.ofRequest((Object)mutatedSpec.asRequest()));
        }).map(data -> new Message(this.gateway, (MessageData)data));
    }

    public Mono<Message> edit(MessageEditSpec spec) {
        Objects.requireNonNull(spec);
        return Mono.defer(() -> {
            MessageEditSpec actualSpec = this.getClient().getRestClient().getRestResources().getAllowedMentions().filter(allowedMentions -> !spec.isAllowedMentionsPresent()).map(spec::withAllowedMentionsOrNull).orElse(spec);
            return this.gateway.getRestClient().getChannelService().editMessage(this.getChannelId().asLong(), this.getId().asLong(), actualSpec.asRequest());
        }).map(data -> new Message(this.gateway, (MessageData)data));
    }

    public MessageEditMono edit() {
        return MessageEditMono.of(this);
    }

    public Mono<Void> delete() {
        return this.delete(null);
    }

    public Mono<Void> delete(@Nullable String reason) {
        return this.gateway.getRestClient().getChannelService().deleteMessage(this.getChannelId().asLong(), this.getId().asLong(), reason);
    }

    @Experimental
    public Mono<Void> suppressEmbeds(boolean suppress) {
        return this.gateway.getRestClient().getChannelService().suppressEmbeds(this.getChannelId().asLong(), this.getId().asLong(), (SuppressEmbedsRequest)SuppressEmbedsRequest.builder().suppress(suppress).build());
    }

    public Mono<Void> addReaction(ReactionEmoji emoji) {
        return this.gateway.getRestClient().getChannelService().createReaction(this.getChannelId().asLong(), this.getId().asLong(), EntityUtil.getEmojiString(emoji));
    }

    public Mono<Void> removeReaction(ReactionEmoji emoji, Snowflake userId) {
        return this.gateway.getRestClient().getChannelService().deleteReaction(this.getChannelId().asLong(), this.getId().asLong(), EntityUtil.getEmojiString(emoji), userId.asLong());
    }

    public Mono<Void> removeReactions(ReactionEmoji emoji) {
        return this.gateway.getRestClient().getChannelService().deleteReactions(this.getChannelId().asLong(), this.getId().asLong(), EntityUtil.getEmojiString(emoji));
    }

    public Mono<Void> removeSelfReaction(ReactionEmoji emoji) {
        return this.gateway.getRestClient().getChannelService().deleteOwnReaction(this.getChannelId().asLong(), this.getId().asLong(), EntityUtil.getEmojiString(emoji));
    }

    public Mono<Void> removeAllReactions() {
        return this.gateway.getRestClient().getChannelService().deleteAllReactions(this.getChannelId().asLong(), this.getId().asLong());
    }

    public Mono<Void> pin() {
        return this.gateway.getRestClient().getChannelService().addPinnedMessage(this.getChannelId().asLong(), this.getId().asLong());
    }

    public Mono<Void> unpin() {
        return this.gateway.getRestClient().getChannelService().deletePinnedMessage(this.getChannelId().asLong(), this.getId().asLong());
    }

    public Mono<Message> publish() {
        return this.gateway.getRestClient().getChannelService().publishMessage(this.getChannelId().asLong(), this.getId().asLong()).map(data -> new Message(this.gateway, (MessageData)data));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Message{data=" + this.data + '}';
    }

    public static enum Type {
        UNKNOWN(-1),
        DEFAULT(0),
        RECIPIENT_ADD(1),
        RECIPIENT_REMOVE(2),
        CALL(3),
        CHANNEL_NAME_CHANGE(4),
        CHANNEL_ICON_CHANGE(5),
        CHANNEL_PINNED_MESSAGE(6),
        GUILD_MEMBER_JOIN(7),
        USER_PREMIUM_GUILD_SUBSCRIPTION(8),
        USER_PREMIUM_GUILD_SUBSCRIPTION_TIER_1(9),
        USER_PREMIUM_GUILD_SUBSCRIPTION_TIER_2(10),
        USER_PREMIUM_GUILD_SUBSCRIPTION_TIER_3(11),
        CHANNEL_FOLLOW_ADD(12),
        GUILD_DISCOVERY_DISQUALIFIED(14),
        GUILD_DISCOVERY_REQUALIFIED(15),
        GUILD_DISCOVERY_GRACE_PERIOD_INITIAL_WARNING(16),
        GUILD_DISCOVERY_GRACE_PERIOD_FINAL_WARNING(17),
        THREAD_CREATED(18),
        REPLY(19),
        APPLICATION_COMMAND(20),
        THREAD_STARTER_MESSAGE(21),
        GUILD_INVITE_REMINDER(22),
        CONTEXT_MENU_COMMAND(23);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 0: {
                    return DEFAULT;
                }
                case 1: {
                    return RECIPIENT_ADD;
                }
                case 2: {
                    return RECIPIENT_REMOVE;
                }
                case 3: {
                    return CALL;
                }
                case 4: {
                    return CHANNEL_NAME_CHANGE;
                }
                case 5: {
                    return CHANNEL_ICON_CHANGE;
                }
                case 6: {
                    return CHANNEL_PINNED_MESSAGE;
                }
                case 7: {
                    return GUILD_MEMBER_JOIN;
                }
                case 8: {
                    return USER_PREMIUM_GUILD_SUBSCRIPTION;
                }
                case 9: {
                    return USER_PREMIUM_GUILD_SUBSCRIPTION_TIER_1;
                }
                case 10: {
                    return USER_PREMIUM_GUILD_SUBSCRIPTION_TIER_2;
                }
                case 11: {
                    return USER_PREMIUM_GUILD_SUBSCRIPTION_TIER_3;
                }
                case 12: {
                    return CHANNEL_FOLLOW_ADD;
                }
                case 14: {
                    return GUILD_DISCOVERY_DISQUALIFIED;
                }
                case 15: {
                    return GUILD_DISCOVERY_REQUALIFIED;
                }
                case 16: {
                    return GUILD_DISCOVERY_GRACE_PERIOD_INITIAL_WARNING;
                }
                case 17: {
                    return GUILD_DISCOVERY_GRACE_PERIOD_FINAL_WARNING;
                }
                case 18: {
                    return THREAD_CREATED;
                }
                case 19: {
                    return REPLY;
                }
                case 20: {
                    return APPLICATION_COMMAND;
                }
                case 21: {
                    return THREAD_STARTER_MESSAGE;
                }
                case 22: {
                    return GUILD_INVITE_REMINDER;
                }
                case 23: {
                    return CONTEXT_MENU_COMMAND;
                }
            }
            return UNKNOWN;
        }
    }

    public static enum Flag {
        CROSSPOSTED(0),
        IS_CROSSPOST(1),
        SUPPRESS_EMBEDS(2),
        SOURCE_MESSAGE_DELETED(3),
        URGENT(4),
        HAS_THREAD(5),
        EPHEMERAL(6),
        LOADING(7);

        private final int value;
        private final int flag;

        private Flag(int value) {
            this.value = value;
            this.flag = 1 << value;
        }

        public int getValue() {
            return this.value;
        }

        public int getFlag() {
            return this.flag;
        }

        public static EnumSet<Flag> of(int value) {
            EnumSet<Flag> messageFlags = EnumSet.noneOf(Flag.class);
            for (Flag flag : Flag.values()) {
                long flagValue = flag.getFlag();
                if ((flagValue & (long)value) != flagValue) continue;
                messageFlags.add(flag);
            }
            return messageFlags;
        }
    }
}

