/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.IntegrationAccount;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.IntegrationApplication;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.IntegrationApplicationData;
import discord4j.discordjson.json.IntegrationData;
import discord4j.discordjson.json.UserData;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class Integration
implements Entity {
    private final GatewayDiscordClient gateway;
    private final IntegrationData data;
    private final long guildId;

    public Integration(GatewayDiscordClient gateway, IntegrationData data, long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.guildId = guildId;
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public IntegrationData getData() {
        return this.data;
    }

    public String getName() {
        return this.data.name();
    }

    public String getType() {
        return this.data.type();
    }

    public boolean isEnabled() {
        return this.data.enabled();
    }

    public boolean isSyncing() {
        return this.data.syncing().toOptional().orElse(false);
    }

    public Optional<Snowflake> getSubscriberRoleId() {
        return this.data.roleId().toOptional().map(Snowflake::of);
    }

    public Mono<Role> getSubscriberRole() {
        return Mono.justOrEmpty(this.getSubscriberRoleId()).flatMap(id -> this.gateway.getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public Mono<Role> getSubscriberRole(EntityRetrievalStrategy retrievalStrategy) {
        return Mono.justOrEmpty(this.getSubscriberRoleId()).flatMap(id -> this.gateway.withRetrievalStrategy(retrievalStrategy).getRoleById(this.getGuildId(), (Snowflake)id));
    }

    public boolean isEnableEmoticons() {
        return this.data.enableEmoticons().toOptional().orElse(false);
    }

    public Optional<ExpireBehavior> getExpireBehavior() {
        return this.data.expireBehavior().toOptional().map(ExpireBehavior::of);
    }

    public Optional<Integer> getExpireGracePeriod() {
        return this.data.expireGracePeriod().toOptional();
    }

    public Optional<User> getUser() {
        return this.data.user().toOptional().map(data -> new User(this.gateway, (UserData)data));
    }

    public IntegrationAccount getAccount() {
        return new IntegrationAccount(this.gateway, this.data.account());
    }

    public Optional<Instant> getSyncedAt() {
        return this.data.syncedAt().toOptional().map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Optional<Integer> getSubscriberCount() {
        return this.data.subscriberCount().toOptional();
    }

    public boolean isRevoked() {
        return this.data.revoked().toOptional().orElse(false);
    }

    public Optional<IntegrationApplication> getApplication() {
        return this.data.application().toOptional().map(data -> new IntegrationApplication(this.gateway, (IntegrationApplicationData)data));
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Integration{data=" + this.data + '}';
    }

    public static enum ExpireBehavior {
        UNKNOWN(-1),
        REMOVE_ROLE(0),
        KICK(1);

        private final int value;

        private ExpireBehavior(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static ExpireBehavior of(int value) {
            switch (value) {
                case 0: {
                    return REMOVE_ROLE;
                }
                case 1: {
                    return KICK;
                }
            }
            return UNKNOWN;
        }
    }
}

