/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.entity;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.entity.Entity;
import discord4j.core.util.EntityUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AttachmentData;
import discord4j.discordjson.possible.Possible;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalInt;
import reactor.util.annotation.Nullable;

public final class Attachment
implements Entity {
    public static final String SPOILER_PREFIX = "SPOILER_";
    private final GatewayDiscordClient gateway;
    private final AttachmentData data;

    public Attachment(GatewayDiscordClient gateway, AttachmentData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    public AttachmentData getData() {
        return this.data;
    }

    public String getFilename() {
        return this.data.filename();
    }

    public int getSize() {
        return this.data.size();
    }

    public String getUrl() {
        return this.data.url();
    }

    public String getProxyUrl() {
        return this.data.proxyUrl();
    }

    public OptionalInt getHeight() {
        return Possible.flatOpt((Possible)this.data.height()).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public OptionalInt getWidth() {
        return Possible.flatOpt((Possible)this.data.width()).map(OptionalInt::of).orElse(OptionalInt.empty());
    }

    public boolean isSpoiler() {
        return this.getFilename().startsWith(SPOILER_PREFIX);
    }

    public Optional<String> getContentType() {
        return this.data.contentType().toOptional();
    }

    public boolean equals(@Nullable Object obj) {
        return EntityUtil.equals(this, obj);
    }

    public int hashCode() {
        return EntityUtil.hashCode(this);
    }

    public String toString() {
        return "Attachment{data=" + this.data + '}';
    }
}

