/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.Member;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ResolvedMemberData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.PermissionSet;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

@Experimental
public class ResolvedMember
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ResolvedMemberData data;
    private final UserData user;
    private final long guildId;

    public ResolvedMember(GatewayDiscordClient gateway, ResolvedMemberData data, UserData user, long guildId) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
        this.user = Objects.requireNonNull(user);
        this.guildId = guildId;
    }

    public ResolvedMemberData getData() {
        return this.data;
    }

    public Snowflake getId() {
        return Snowflake.of((Id)this.user.id());
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public Set<Snowflake> getRoleIds() {
        return this.data.roles().stream().map(Snowflake::of).collect(Collectors.toSet());
    }

    public Instant getJoinTime() {
        return DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)this.data.joinedAt(), Instant::from);
    }

    public Optional<Instant> getPremiumTime() {
        return Possible.flatOpt((Possible)this.data.premiumSince()).map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public String getDisplayName() {
        return this.getNickname().orElse(this.user.username());
    }

    public Optional<String> getNickname() {
        return Possible.flatOpt((Possible)this.data.nick());
    }

    public String getNicknameMention() {
        return "<@!" + this.getId().asString() + ">";
    }

    public PermissionSet getEffectivePermissions() {
        return PermissionSet.of((String)((String)this.data.permissions().toOptional().orElseThrow(IllegalStateException::new)));
    }

    public Mono<Member> asFullMember() {
        return this.gateway.getMemberById(this.getGuildId(), this.getId());
    }

    public Mono<Member> asFullMember(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getMemberById(this.getGuildId(), this.getId());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "ResolvedMember{data=" + this.data + ", user=" + this.user + ", guildId=" + this.guildId + '}';
    }
}

