/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.json.ApplicationCommandOptionChoiceData;
import java.util.Objects;

@Experimental
public class ApplicationCommandOptionChoice
implements DiscordObject {
    public static final int MAX_NAME_LENGTH = 100;
    public static final int MAX_VALUE_LENGTH = 100;
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandOptionChoiceData data;

    public ApplicationCommandOptionChoice(GatewayDiscordClient gateway, ApplicationCommandOptionChoiceData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public String getName() {
        return this.data.name();
    }

    public Object getValue() {
        return this.data.value();
    }

    public String asString() {
        return String.valueOf(this.data.value());
    }

    public long asLong() {
        try {
            return Long.parseLong(this.asString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Choice value cannot be converted to long", e);
        }
    }

    public double asDouble() {
        try {
            return Double.parseDouble(this.asString());
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Choice value cannot be converted to double", e);
        }
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }
}

