/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.command;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.command.ApplicationCommandOption;
import discord4j.discordjson.json.ApplicationCommandData;
import discord4j.discordjson.json.ApplicationCommandOptionData;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@Experimental
public class ApplicationCommand
implements DiscordObject {
    public static final int MAX_NAME_LENGTH = 32;
    public static final int MAX_DESCRIPTION_LENGTH = 100;
    private final GatewayDiscordClient gateway;
    private final ApplicationCommandData data;

    public ApplicationCommand(GatewayDiscordClient gateway, ApplicationCommandData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public Snowflake getId() {
        return Snowflake.of((String)this.data.id());
    }

    public Type getType() {
        return this.data.type().toOptional().map(Type::of).orElse(Type.CHAT_INPUT);
    }

    public Snowflake getApplicationId() {
        return Snowflake.of((String)this.data.applicationId());
    }

    public String getName() {
        return this.data.name();
    }

    public String getDescription() {
        return this.data.description();
    }

    public List<ApplicationCommandOption> getOptions() {
        return this.data.options().toOptional().orElse(Collections.emptyList()).stream().map(data -> new ApplicationCommandOption(this.gateway, (ApplicationCommandOptionData)data)).collect(Collectors.toList());
    }

    public Optional<ApplicationCommandOption> getOption(String name) {
        return this.getOptions().stream().filter(option -> option.getName().equals(name)).findFirst();
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public static enum Type {
        UNKNOWN(-1),
        CHAT_INPUT(1),
        USER(2),
        MESSAGE(3);

        private final int value;

        private Type(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static Type of(int value) {
            switch (value) {
                case 1: {
                    return CHAT_INPUT;
                }
                case 2: {
                    return USER;
                }
                case 3: {
                    return MESSAGE;
                }
            }
            return UNKNOWN;
        }
    }
}

