/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.audit;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.audit.AuditLogEntry;
import discord4j.core.object.entity.User;
import discord4j.core.object.entity.Webhook;
import discord4j.discordjson.json.AuditLogData;
import discord4j.discordjson.json.AuditLogEntryData;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.WebhookData;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

public class AuditLogPart {
    private final long guildId;
    private final Set<Webhook> webhooks;
    private final Set<User> users;
    private final List<AuditLogEntry> entries;

    public AuditLogPart(long guildId, GatewayDiscordClient gateway, AuditLogData data) {
        this.guildId = guildId;
        this.webhooks = data.webhooks().stream().map(webhookData -> new Webhook(gateway, (WebhookData)webhookData)).collect(Collectors.toSet());
        this.users = data.users().stream().map(userData -> new User(gateway, (UserData)userData)).collect(Collectors.toSet());
        this.entries = data.auditLogEntries().stream().map(auditLogEntryData -> new AuditLogEntry(gateway, this, (AuditLogEntryData)auditLogEntryData)).collect(Collectors.toList());
    }

    private AuditLogPart(long guildId, Set<Webhook> webhooks, Set<User> users, List<AuditLogEntry> entries) {
        this.guildId = guildId;
        this.webhooks = webhooks;
        this.users = users;
        this.entries = entries;
    }

    public Set<Webhook> getWebhooks() {
        return this.webhooks;
    }

    public Set<User> getUsers() {
        return this.users;
    }

    public List<AuditLogEntry> getEntries() {
        return this.entries;
    }

    public Optional<Webhook> getWebhookById(Snowflake webhookId) {
        return this.webhooks.stream().filter(webhook -> webhook.getId().equals((Object)webhookId)).findFirst();
    }

    public Optional<User> getUserById(Snowflake userId) {
        return this.users.stream().filter(user -> user.getId().equals((Object)userId)).findFirst();
    }

    public Snowflake getGuildId() {
        return Snowflake.of((long)this.guildId);
    }

    public AuditLogPart combine(AuditLogPart other) {
        if (other.guildId != this.guildId) {
            throw new IllegalArgumentException("Cannot combine audit log parts from two different guilds.");
        }
        HashSet<Webhook> combinedWebhooks = new HashSet<Webhook>(this.webhooks.size() + other.webhooks.size());
        combinedWebhooks.addAll(this.webhooks);
        combinedWebhooks.addAll(other.webhooks);
        HashSet<User> combinedUsers = new HashSet<User>(this.users.size() + other.users.size());
        combinedUsers.addAll(this.users);
        combinedUsers.addAll(other.users);
        ArrayList<AuditLogEntry> combinedEntries = new ArrayList<AuditLogEntry>(this.entries.size() + other.entries.size());
        combinedEntries.addAll(this.entries);
        combinedEntries.addAll(other.entries);
        return new AuditLogPart(this.guildId, combinedWebhooks, combinedUsers, combinedEntries);
    }
}

