/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object.audit;

import com.fasterxml.jackson.databind.JsonNode;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.audit.ActionType;
import discord4j.core.object.audit.AuditLogChange;
import discord4j.core.object.audit.AuditLogPart;
import discord4j.core.object.audit.ChangeKey;
import discord4j.core.object.audit.OptionKey;
import discord4j.core.object.entity.Entity;
import discord4j.core.object.entity.User;
import discord4j.core.util.AuditLogUtil;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.AuditLogChangeData;
import discord4j.discordjson.json.AuditLogEntryData;
import java.util.NoSuchElementException;
import java.util.Optional;

public class AuditLogEntry
implements Entity {
    public static final int MAX_REASON_LENGTH = 512;
    private final GatewayDiscordClient gateway;
    private final AuditLogPart auditLogPart;
    private final AuditLogEntryData data;

    AuditLogEntry(GatewayDiscordClient gateway, AuditLogPart auditLogPart, AuditLogEntryData data) {
        this.gateway = gateway;
        this.auditLogPart = auditLogPart;
        this.data = data;
    }

    public AuditLogEntryData getData() {
        return this.data;
    }

    public Optional<Snowflake> getTargetId() {
        return this.data.targetId().filter(it -> !it.equals("0")).map(Snowflake::of);
    }

    public Optional<Snowflake> getResponsibleUserId() {
        return this.data.userId().map(Snowflake::of);
    }

    public Optional<User> getResponsibleUser() {
        return this.getResponsibleUserId().map(id -> this.auditLogPart.getUserById((Snowflake)id).orElseThrow(() -> new NoSuchElementException("Audit log users does not contain responsible user ID.")));
    }

    public Optional<String> getReason() {
        return this.data.reason().toOptional();
    }

    public ActionType getActionType() {
        return ActionType.of(this.data.actionType());
    }

    public <T> Optional<AuditLogChange<T>> getChange(ChangeKey<T> changeKey) {
        return this.data.changes().toOptional().map(list -> list.stream().collect(AuditLogUtil.changeCollector())).flatMap(map -> Optional.ofNullable((AuditLogChangeData)map.get(changeKey.getName()))).map(changeData -> {
            Object oldValue = changeData.oldValue().toOptional().map(v -> changeKey.parseValue(this, (JsonNode)v)).orElse(null);
            Object newValue = changeData.newValue().toOptional().map(v -> changeKey.parseValue(this, (JsonNode)v)).orElse(null);
            return new AuditLogChange<Object>(oldValue, newValue);
        });
    }

    public <T> Optional<T> getOption(OptionKey<T> optionKey) {
        return this.data.options().toOptional().map(AuditLogUtil::createOptionMap).map(map -> optionKey.parseValue((String)map.get(optionKey.getField())));
    }

    public AuditLogPart getParent() {
        return this.auditLogPart;
    }

    @Override
    public Snowflake getId() {
        return Snowflake.of((Id)this.data.id());
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "AuditLogEntry{data=" + this.data + '}';
    }
}

