/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.MessageReferenceData;
import java.util.Objects;
import java.util.Optional;

@Experimental
public class MessageReference
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final MessageReferenceData data;

    public MessageReference(GatewayDiscordClient gateway, MessageReferenceData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    public MessageReferenceData getData() {
        return this.data;
    }

    public Snowflake getChannelId() {
        return Snowflake.of((Id)((Id)this.data.channelId().toOptional().orElseThrow(IllegalStateException::new)));
    }

    public Optional<Snowflake> getGuildId() {
        return this.data.guildId().toOptional().map(Snowflake::of);
    }

    public Optional<Snowflake> getMessageId() {
        return this.data.messageId().toOptional().map(Snowflake::of);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public String toString() {
        return "MessageReference{data=" + this.data + '}';
    }
}

