/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.discordjson.json.EmbedAuthorData;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.EmbedFieldData;
import discord4j.discordjson.json.EmbedFooterData;
import discord4j.discordjson.json.EmbedImageData;
import discord4j.discordjson.json.EmbedProviderData;
import discord4j.discordjson.json.EmbedThumbnailData;
import discord4j.discordjson.json.EmbedVideoData;
import discord4j.rest.util.Color;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import reactor.util.annotation.Nullable;

public final class Embed
implements DiscordObject {
    public static final int MAX_TITLE_LENGTH = 256;
    public static final int MAX_DESCRIPTION_LENGTH = 4096;
    public static final int MAX_FIELDS = 25;
    @Deprecated
    public static final int MAX_CHARACTER_LENGTH = 6000;
    private final GatewayDiscordClient gateway;
    private final EmbedData data;

    public Embed(GatewayDiscordClient gateway, EmbedData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public EmbedData getData() {
        return this.data;
    }

    public Optional<String> getTitle() {
        return this.data.title().toOptional();
    }

    public Type getType() {
        return this.data.type().toOptional().map(Type::of).orElseThrow(IllegalStateException::new);
    }

    public Optional<String> getDescription() {
        return this.data.description().toOptional();
    }

    public Optional<String> getUrl() {
        return this.data.url().toOptional();
    }

    public Optional<Instant> getTimestamp() {
        return this.data.timestamp().toOptional().map(timestamp -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)timestamp, Instant::from));
    }

    public Optional<Color> getColor() {
        return this.data.color().toOptional().map(Color::of);
    }

    public Optional<Footer> getFooter() {
        return this.data.footer().toOptional().map(x$0 -> new Footer((EmbedFooterData)x$0));
    }

    public Optional<Image> getImage() {
        return this.data.image().toOptional().map(x$0 -> new Image((EmbedImageData)x$0));
    }

    public Optional<Thumbnail> getThumbnail() {
        return this.data.thumbnail().toOptional().map(x$0 -> new Thumbnail((EmbedThumbnailData)x$0));
    }

    public Optional<Video> getVideo() {
        return this.data.video().toOptional().map(x$0 -> new Video((EmbedVideoData)x$0));
    }

    public Optional<Provider> getProvider() {
        return this.data.provider().toOptional().map(x$0 -> new Provider((EmbedProviderData)x$0));
    }

    public Optional<Author> getAuthor() {
        return this.data.author().toOptional().map(x$0 -> new Author((EmbedAuthorData)x$0));
    }

    public List<Field> getFields() {
        return this.data.fields().toOptional().map(fields -> fields.stream().map(x$0 -> new Field((EmbedFieldData)x$0)).collect(Collectors.toList())).orElse(Collections.emptyList());
    }

    public String toString() {
        return "Embed{data=" + this.data + '}';
    }

    public final class Field {
        public static final int MAX_NAME_LENGTH = 256;
        public static final int MAX_VALUE_LENGTH = 1024;
        private final EmbedFieldData data;

        private Field(EmbedFieldData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedFieldData getData() {
            return this.data;
        }

        public String getName() {
            return this.data.name();
        }

        public String getValue() {
            return this.data.value();
        }

        public boolean isInline() {
            return (Boolean)this.data.inline().toOptional().orElseThrow(IllegalStateException::new);
        }
    }

    public final class Author {
        public static final int MAX_NAME_LENGTH = 256;
        private final EmbedAuthorData data;

        private Author(EmbedAuthorData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedAuthorData getData() {
            return this.data;
        }

        public Optional<String> getName() {
            return this.data.name().toOptional();
        }

        public Optional<String> getUrl() {
            return this.data.url().toOptional();
        }

        public Optional<String> getIconUrl() {
            return this.data.iconUrl().toOptional();
        }

        public Optional<String> getProxyIconUrl() {
            return this.data.proxyIconUrl().toOptional();
        }
    }

    public final class Provider {
        private final EmbedProviderData data;

        private Provider(EmbedProviderData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedProviderData getData() {
            return this.data;
        }

        public Optional<String> getName() {
            return this.data.name().toOptional();
        }

        public Optional<String> getUrl() {
            return this.data.url().toOptional();
        }
    }

    public final class Video {
        private final EmbedVideoData data;

        private Video(EmbedVideoData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedVideoData getData() {
            return this.data;
        }

        public String getUrl() {
            return (String)this.data.url().toOptional().orElseThrow(IllegalStateException::new);
        }

        @Nullable
        public String getProxyUrl() {
            return this.data.proxyUrl().toOptional().orElse(null);
        }

        public int getHeight() {
            return (Integer)this.data.height().toOptional().orElseThrow(IllegalStateException::new);
        }

        public int getWidth() {
            return (Integer)this.data.width().toOptional().orElseThrow(IllegalStateException::new);
        }
    }

    public final class Thumbnail {
        private final EmbedThumbnailData data;

        private Thumbnail(EmbedThumbnailData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedThumbnailData getData() {
            return this.data;
        }

        public String getUrl() {
            return (String)this.data.url().toOptional().orElseThrow(IllegalStateException::new);
        }

        public String getProxyUrl() {
            return (String)this.data.proxyUrl().toOptional().orElseThrow(IllegalStateException::new);
        }

        public int getHeight() {
            return (Integer)this.data.height().toOptional().orElseThrow(IllegalStateException::new);
        }

        public int getWidth() {
            return (Integer)this.data.width().toOptional().orElseThrow(IllegalStateException::new);
        }
    }

    public final class Image {
        private final EmbedImageData data;

        private Image(EmbedImageData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedImageData getData() {
            return this.data;
        }

        public String getUrl() {
            return (String)this.data.url().toOptional().orElseThrow(IllegalStateException::new);
        }

        public String getProxyUrl() {
            return (String)this.data.proxyUrl().toOptional().orElseThrow(IllegalStateException::new);
        }

        public int getHeight() {
            return (Integer)this.data.height().toOptional().orElseThrow(IllegalStateException::new);
        }

        public int getWidth() {
            return (Integer)this.data.width().toOptional().orElseThrow(IllegalStateException::new);
        }
    }

    public final class Footer {
        public static final int MAX_TEXT_LENGTH = 2048;
        private final EmbedFooterData data;

        private Footer(EmbedFooterData data) {
            this.data = Objects.requireNonNull(data);
        }

        public Embed getEmbed() {
            return Embed.this;
        }

        public EmbedFooterData getData() {
            return this.data;
        }

        public String getText() {
            return this.data.text();
        }

        public Optional<String> getIconUrl() {
            return this.data.iconUrl().toOptional();
        }

        public Optional<String> getProxyIconUrl() {
            return this.data.proxyIconUrl().toOptional();
        }
    }

    public static enum Type {
        UNKNOWN("UNKNOWN"),
        IMAGE("image"),
        LINK("link"),
        RICH("rich"),
        VIDEO("video");

        private final String value;

        private Type(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public static Type of(String value) {
            switch (value) {
                case "image": {
                    return IMAGE;
                }
                case "link": {
                    return LINK;
                }
                case "rich": {
                    return RICH;
                }
                case "video": {
                    return VIDEO;
                }
            }
            return UNKNOWN;
        }
    }
}

