/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.object;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.object.DiscordObject;
import discord4j.core.object.entity.User;
import discord4j.core.retriever.EntityRetrievalStrategy;
import discord4j.discordjson.json.ApplicationTeamMemberData;
import java.util.Objects;
import reactor.core.publisher.Mono;

public class ApplicationTeamMember
implements DiscordObject {
    private final GatewayDiscordClient gateway;
    private final ApplicationTeamMemberData data;

    public ApplicationTeamMember(GatewayDiscordClient gateway, ApplicationTeamMemberData data) {
        this.gateway = Objects.requireNonNull(gateway);
        this.data = Objects.requireNonNull(data);
    }

    @Override
    public GatewayDiscordClient getClient() {
        return this.gateway;
    }

    public ApplicationTeamMemberData getData() {
        return this.data;
    }

    public MembershipState getMembershipState() {
        return MembershipState.of(this.data.membershipState());
    }

    public Snowflake getTeamId() {
        return Snowflake.of((long)this.data.teamId().asLong());
    }

    public Snowflake getUserId() {
        return Snowflake.of((long)this.data.user().id().asLong());
    }

    public Mono<User> getUser() {
        return this.gateway.getUserById(this.getUserId());
    }

    public Mono<User> getUser(EntityRetrievalStrategy retrievalStrategy) {
        return this.gateway.withRetrievalStrategy(retrievalStrategy).getUserById(this.getUserId());
    }

    public String toString() {
        return "ApplicationTeamMember{data=" + this.data + '}';
    }

    public static enum MembershipState {
        UNKNOWN(-1),
        INVITED(1),
        ACCEPTED(2);

        private final int value;

        private MembershipState(int value) {
            this.value = value;
        }

        public int getValue() {
            return this.value;
        }

        public static MembershipState of(int value) {
            switch (value) {
                case 1: {
                    return INVITED;
                }
                case 2: {
                    return ACCEPTED;
                }
            }
            return UNKNOWN;
        }
    }
}

