/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain.interaction;

import discord4j.common.annotations.Experimental;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.command.Interaction;
import discord4j.core.object.entity.Message;
import discord4j.discordjson.json.FollowupMessageRequest;
import discord4j.discordjson.json.ImmutableFollowupMessageRequest;
import discord4j.discordjson.json.ImmutableInteractionResponseData;
import discord4j.discordjson.json.InteractionApplicationCommandCallbackData;
import discord4j.discordjson.json.InteractionData;
import discord4j.discordjson.json.InteractionResponseData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.WebhookExecuteRequest;
import discord4j.discordjson.json.WebhookMessageEditRequest;
import discord4j.discordjson.possible.Possible;
import discord4j.gateway.ShardInfo;
import discord4j.rest.RestClient;
import discord4j.rest.interaction.InteractionResponse;
import discord4j.rest.util.InteractionResponseType;
import discord4j.rest.util.MultipartRequest;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

@Experimental
public class InteractionCreateEvent
extends Event {
    private final Interaction interaction;

    public InteractionCreateEvent(GatewayDiscordClient gateway, ShardInfo shardInfo, Interaction interaction) {
        super(gateway, shardInfo);
        this.interaction = interaction;
    }

    public Interaction getInteraction() {
        return this.interaction;
    }

    protected Mono<Void> createInteractionResponse(InteractionResponseType responseType, @Nullable InteractionApplicationCommandCallbackData data) {
        ImmutableInteractionResponseData responseData = InteractionResponseData.builder().type(responseType.getValue()).data(data == null ? Possible.absent() : Possible.of((Object)data)).build();
        long id = this.interaction.getId().asLong();
        String token = this.interaction.getToken();
        return this.getClient().rest().getInteractionService().createInteractionResponse(id, token, (InteractionResponseData)responseData);
    }

    static class EventInteractionResponse
    implements InteractionResponse {
        private final RestClient restClient;
        private final InteractionData interactionData;
        private final long applicationId;

        EventInteractionResponse(RestClient restClient, InteractionData interactionData) {
            this.restClient = restClient;
            this.interactionData = interactionData;
            this.applicationId = Snowflake.asLong((String)interactionData.applicationId());
        }

        public Mono<MessageData> getInitialResponse() {
            return this.restClient.getWebhookService().getWebhookMessage(this.applicationId, this.interactionData.token(), "@original");
        }

        public Mono<MessageData> editInitialResponse(WebhookMessageEditRequest request) {
            return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), "@original", request);
        }

        public Mono<MessageData> editInitialResponse(MultipartRequest<WebhookMessageEditRequest> request) {
            return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), "@original", request);
        }

        public Mono<Void> deleteInitialResponse() {
            return this.restClient.getWebhookService().deleteWebhookMessage(this.applicationId, this.interactionData.token(), "@original");
        }

        public Mono<MessageData> createFollowupMessage(String content) {
            ImmutableFollowupMessageRequest body = FollowupMessageRequest.builder().content(content).build();
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, MultipartRequest.ofRequest((Object)body));
        }

        public Mono<MessageData> createFollowupMessage(MultipartRequest<? extends WebhookExecuteRequest> request) {
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, request);
        }

        public Mono<MessageData> createFollowupMessageEphemeral(String content) {
            ImmutableFollowupMessageRequest body = FollowupMessageRequest.builder().content(content).flags(Integer.valueOf(Message.Flag.EPHEMERAL.getFlag())).build();
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, MultipartRequest.ofRequest((Object)body));
        }

        public Mono<MessageData> createFollowupMessageEphemeral(MultipartRequest<WebhookExecuteRequest> request) {
            ImmutableFollowupMessageRequest newBody = FollowupMessageRequest.builder().from((WebhookExecuteRequest)request.getJsonPayload()).flags(Integer.valueOf(Message.Flag.EPHEMERAL.getFlag())).build();
            return this.restClient.getWebhookService().executeWebhook(this.applicationId, this.interactionData.token(), true, MultipartRequest.ofRequest((Object)newBody));
        }

        public Mono<MessageData> editFollowupMessage(long messageId, WebhookMessageEditRequest request, boolean wait) {
            return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId), request);
        }

        public Mono<MessageData> editFollowupMessage(long messageId, MultipartRequest<WebhookMessageEditRequest> request) {
            return this.restClient.getWebhookService().modifyWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId), request);
        }

        public Mono<Void> deleteFollowupMessage(long messageId) {
            return this.restClient.getWebhookService().deleteWebhookMessage(this.applicationId, this.interactionData.token(), String.valueOf(messageId));
        }
    }
}

