/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.domain;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.domain.Event;
import discord4j.core.object.Invite;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.User;
import discord4j.gateway.ShardInfo;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Optional;
import reactor.core.publisher.Mono;
import reactor.util.annotation.Nullable;

public class InviteCreateEvent
extends Event {
    @Nullable
    private final Long guildId;
    private final long channelId;
    private final String code;
    @Nullable
    private final User inviter;
    private final Instant createdAt;
    private final int uses;
    private final int maxUses;
    private final int maxAge;
    private final boolean temporary;

    public InviteCreateEvent(GatewayDiscordClient client, ShardInfo shardInfo, Long guildId, long channelId, String code, @Nullable User inviter, Instant createdAt, int uses, int maxUses, int maxAge, boolean temporary) {
        super(client, shardInfo);
        this.guildId = guildId;
        this.channelId = channelId;
        this.code = code;
        this.inviter = inviter;
        this.createdAt = createdAt;
        this.uses = uses;
        this.maxAge = maxAge;
        this.maxUses = maxUses;
        this.temporary = temporary;
    }

    public Optional<Snowflake> getGuildId() {
        return Optional.ofNullable(this.guildId).map(Snowflake::of);
    }

    public Mono<Guild> getGuild() {
        return Mono.justOrEmpty(this.getGuildId()).flatMap(this.getClient()::getGuildById);
    }

    public Snowflake getChannelId() {
        return Snowflake.of((long)this.channelId);
    }

    public String getCode() {
        return this.code;
    }

    public Optional<User> getInviter() {
        return Optional.ofNullable(this.inviter);
    }

    public int getUses() {
        return this.uses;
    }

    public int getMaxUses() {
        return this.maxUses;
    }

    public int getMaxAge() {
        return this.maxAge;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public Instant getCreation() {
        return this.createdAt;
    }

    public Optional<Instant> getExpiration() {
        boolean temporary = this.isTemporary();
        int maxAge = this.getMaxAge();
        return temporary ? Optional.of(this.getCreation().plus((long)maxAge, ChronoUnit.SECONDS)) : Optional.empty();
    }

    public Mono<Invite> getInvite() {
        return this.getClient().getInvite(this.code);
    }

    public String toString() {
        return "InviteCreateEvent{code='" + this.code + '\'' + ", guildId=" + this.guildId + ", channelId=" + this.channelId + ", inviter=" + this.inviter + ", uses=" + this.uses + ", maxUses=" + this.maxUses + ", maxAge=" + this.maxAge + ", temporary=" + this.temporary + ", createdAt='" + this.createdAt + '\'' + '}';
    }
}

