/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.message.MessageBulkDeleteEvent;
import discord4j.core.event.domain.message.MessageCreateEvent;
import discord4j.core.event.domain.message.MessageDeleteEvent;
import discord4j.core.event.domain.message.MessageUpdateEvent;
import discord4j.core.event.domain.message.ReactionAddEvent;
import discord4j.core.event.domain.message.ReactionRemoveAllEvent;
import discord4j.core.event.domain.message.ReactionRemoveEmojiEvent;
import discord4j.core.event.domain.message.ReactionRemoveEvent;
import discord4j.core.object.Embed;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Message;
import discord4j.core.object.reaction.ReactionEmoji;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.EmbedData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.MessageData;
import discord4j.discordjson.json.PartialMessageData;
import discord4j.discordjson.json.gateway.MessageCreate;
import discord4j.discordjson.json.gateway.MessageDelete;
import discord4j.discordjson.json.gateway.MessageDeleteBulk;
import discord4j.discordjson.json.gateway.MessageReactionAdd;
import discord4j.discordjson.json.gateway.MessageReactionRemove;
import discord4j.discordjson.json.gateway.MessageReactionRemoveAll;
import discord4j.discordjson.json.gateway.MessageReactionRemoveEmoji;
import discord4j.discordjson.json.gateway.MessageUpdate;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.publisher.Mono;

class MessageDispatchHandlers {
    MessageDispatchHandlers() {
    }

    static Mono<MessageCreateEvent> messageCreate(DispatchContext<MessageCreate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        MessageData message = context.getDispatch().message();
        Optional maybeMember = context.getDispatch().message().guildId().toOptional().map(Snowflake::asLong).flatMap(guildId -> message.member().toOptional().map(memberData -> new Member(gateway, (MemberData)MemberData.builder().from((MemberData)MemberData.builder().user(message.author()).nick(memberData.nick()).roles(memberData.roles()).joinedAt(memberData.joinedAt()).premiumSince(memberData.premiumSince()).hoistedRole(memberData.hoistedRole()).deaf(memberData.deaf()).mute(memberData.mute()).build()).user(message.author()).build(), (long)guildId)));
        return Mono.just((Object)new MessageCreateEvent(gateway, context.getShardInfo(), new Message(gateway, message), context.getDispatch().message().guildId().toOptional().map(Snowflake::asLong).orElse(null), maybeMember.orElse(null)));
    }

    static Mono<MessageDeleteEvent> messageDelete(DispatchContext<MessageDelete, MessageData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long messageId = Snowflake.asLong((Id)context.getDispatch().id());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        Message oldMessage = context.getOldState().map(data -> new Message(gateway, (MessageData)data)).orElse(null);
        return Mono.just((Object)new MessageDeleteEvent(gateway, context.getShardInfo(), messageId, channelId, guildId, oldMessage));
    }

    static Mono<MessageBulkDeleteEvent> messageDeleteBulk(DispatchContext<MessageDeleteBulk, Set<MessageData>> context) {
        GatewayDiscordClient gateway = context.getGateway();
        List<Long> messageIds = context.getDispatch().ids().stream().map(Snowflake::asLong).collect(Collectors.toList());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        long guildId = Snowflake.asLong((Id)((Id)context.getDispatch().guildId().get()));
        Set<Message> deletedMessages = context.getOldState().map(oldState -> oldState.stream().map(data -> new Message(gateway, (MessageData)data)).collect(Collectors.toSet())).orElse(Collections.emptySet());
        return Mono.just((Object)new MessageBulkDeleteEvent(gateway, context.getShardInfo(), messageIds, channelId, guildId, deletedMessages));
    }

    static Mono<ReactionAddEvent> messageReactionAdd(DispatchContext<MessageReactionAdd, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long userId = Snowflake.asLong((Id)context.getDispatch().userId());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        long messageId = Snowflake.asLong((Id)context.getDispatch().messageId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        MemberData memberData = context.getDispatch().member().toOptional().orElse(null);
        Long emojiId = context.getDispatch().emoji().id().map(Snowflake::asLong).orElse(null);
        String emojiName = context.getDispatch().emoji().name().orElse(null);
        boolean emojiAnimated = context.getDispatch().emoji().animated().toOptional().orElse(false);
        ReactionEmoji emoji = ReactionEmoji.of(emojiId, emojiName, emojiAnimated);
        Member member = memberData != null ? new Member(gateway, memberData, guildId) : null;
        return Mono.just((Object)new ReactionAddEvent(gateway, context.getShardInfo(), userId, channelId, messageId, guildId, emoji, member));
    }

    static Mono<ReactionRemoveEvent> messageReactionRemove(DispatchContext<MessageReactionRemove, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long userId = Snowflake.asLong((Id)context.getDispatch().userId());
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        long messageId = Snowflake.asLong((Id)context.getDispatch().messageId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        Long emojiId = context.getDispatch().emoji().id().map(Snowflake::asLong).orElse(null);
        String emojiName = context.getDispatch().emoji().name().orElse(null);
        boolean emojiAnimated = context.getDispatch().emoji().animated().toOptional().orElse(false);
        ReactionEmoji emoji = ReactionEmoji.of(emojiId, emojiName, emojiAnimated);
        return Mono.just((Object)new ReactionRemoveEvent(gateway, context.getShardInfo(), userId, channelId, messageId, guildId, emoji));
    }

    static Mono<ReactionRemoveEmojiEvent> messageReactionRemoveEmoji(DispatchContext<MessageReactionRemoveEmoji, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        long messageId = Snowflake.asLong((Id)context.getDispatch().messageId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        Long emojiId = context.getDispatch().emoji().id().map(Snowflake::asLong).orElse(null);
        String emojiName = context.getDispatch().emoji().name().orElse(null);
        boolean emojiAnimated = context.getDispatch().emoji().animated().toOptional().orElse(false);
        ReactionEmoji emoji = ReactionEmoji.of(emojiId, emojiName, emojiAnimated);
        return Mono.just((Object)new ReactionRemoveEmojiEvent(gateway, context.getShardInfo(), channelId, messageId, guildId, emoji));
    }

    static Mono<ReactionRemoveAllEvent> messageReactionRemoveAll(DispatchContext<MessageReactionRemoveAll, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        long messageId = Snowflake.asLong((Id)context.getDispatch().messageId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        return Mono.just((Object)new ReactionRemoveAllEvent(gateway, context.getShardInfo(), channelId, messageId, guildId));
    }

    static Mono<MessageUpdateEvent> messageUpdate(DispatchContext<MessageUpdate, MessageData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        PartialMessageData messageData = context.getDispatch().message();
        long channelId = Snowflake.asLong((Id)messageData.channelId());
        long messageId = Snowflake.asLong((Id)messageData.id());
        Long guildId = messageData.guildId().toOptional().map(Snowflake::asLong).orElse(null);
        String currentContent = messageData.content().toOptional().orElse(null);
        List<Embed> embedList = messageData.embeds().stream().map(embedData -> new Embed(gateway, (EmbedData)embedData)).collect(Collectors.toList());
        Message oldMessage = context.getOldState().map(data -> new Message(gateway, (MessageData)data)).orElse(null);
        return Mono.just((Object)new MessageUpdateEvent(gateway, context.getShardInfo(), messageId, channelId, guildId, oldMessage, !messageData.content().isAbsent(), currentContent, !messageData.embeds().isEmpty(), embedList));
    }
}

