/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.LogUtil;
import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.guild.BanEvent;
import discord4j.core.event.domain.guild.EmojisUpdateEvent;
import discord4j.core.event.domain.guild.GuildCreateEvent;
import discord4j.core.event.domain.guild.GuildDeleteEvent;
import discord4j.core.event.domain.guild.GuildUpdateEvent;
import discord4j.core.event.domain.guild.IntegrationsUpdateEvent;
import discord4j.core.event.domain.guild.MemberChunkEvent;
import discord4j.core.event.domain.guild.MemberJoinEvent;
import discord4j.core.event.domain.guild.MemberLeaveEvent;
import discord4j.core.event.domain.guild.MemberUpdateEvent;
import discord4j.core.event.domain.guild.UnbanEvent;
import discord4j.core.event.domain.role.RoleCreateEvent;
import discord4j.core.event.domain.role.RoleDeleteEvent;
import discord4j.core.event.domain.role.RoleUpdateEvent;
import discord4j.core.object.entity.Guild;
import discord4j.core.object.entity.GuildEmoji;
import discord4j.core.object.entity.Member;
import discord4j.core.object.entity.Role;
import discord4j.core.object.entity.User;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.EmojiData;
import discord4j.discordjson.json.GuildCreateData;
import discord4j.discordjson.json.GuildCreateFields;
import discord4j.discordjson.json.GuildData;
import discord4j.discordjson.json.GuildUpdateFields;
import discord4j.discordjson.json.ImmutableGuildData;
import discord4j.discordjson.json.MemberData;
import discord4j.discordjson.json.RoleData;
import discord4j.discordjson.json.RoleDataFields;
import discord4j.discordjson.json.UserData;
import discord4j.discordjson.json.gateway.GuildBanAdd;
import discord4j.discordjson.json.gateway.GuildBanRemove;
import discord4j.discordjson.json.gateway.GuildCreate;
import discord4j.discordjson.json.gateway.GuildDelete;
import discord4j.discordjson.json.gateway.GuildEmojisUpdate;
import discord4j.discordjson.json.gateway.GuildIntegrationsUpdate;
import discord4j.discordjson.json.gateway.GuildMemberAdd;
import discord4j.discordjson.json.gateway.GuildMemberRemove;
import discord4j.discordjson.json.gateway.GuildMemberUpdate;
import discord4j.discordjson.json.gateway.GuildMembersChunk;
import discord4j.discordjson.json.gateway.GuildRoleCreate;
import discord4j.discordjson.json.gateway.GuildRoleDelete;
import discord4j.discordjson.json.gateway.GuildRoleUpdate;
import discord4j.discordjson.json.gateway.GuildUpdate;
import discord4j.discordjson.possible.Possible;
import java.time.ZonedDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import reactor.core.Disposable;
import reactor.core.publisher.Mono;
import reactor.util.Logger;
import reactor.util.Loggers;
import reactor.util.context.Context;
import reactor.util.context.ContextView;

class GuildDispatchHandlers {
    private static final Logger log = Loggers.getLogger(GuildDispatchHandlers.class);

    GuildDispatchHandlers() {
    }

    static Mono<BanEvent> guildBanAdd(DispatchContext<GuildBanAdd, Void> context) {
        User user = new User(context.getGateway(), context.getDispatch().user());
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        return Mono.just((Object)new BanEvent(context.getGateway(), context.getShardInfo(), user, guildId));
    }

    static Mono<UnbanEvent> guildBanRemove(DispatchContext<GuildBanRemove, Void> context) {
        User user = new User(context.getGateway(), context.getDispatch().user());
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        return Mono.just((Object)new UnbanEvent(context.getGateway(), context.getShardInfo(), user, guildId));
    }

    static Mono<GuildCreateEvent> guildCreate(DispatchContext<GuildCreate, Void> context) {
        ImmutableGuildData guild;
        GuildCreateData createData;
        GatewayDiscordClient gateway = context.getGateway();
        if (context.getDispatch().guild().large()) {
            createData = GuildCreateData.builder().from(context.getDispatch().guild()).members(Collections.emptyList()).build();
            guild = GuildData.builder().from((GuildCreateFields)createData).roles(createData.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(createData.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).channels(createData.channels().stream().map(ChannelData::id).collect(Collectors.toList())).build();
        } else {
            createData = context.getDispatch().guild();
            guild = GuildData.builder().from((GuildCreateFields)createData).roles(createData.roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(createData.emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).members(createData.members().stream().map(data -> data.user().id()).distinct().collect(Collectors.toList())).channels(createData.channels().stream().map(ChannelData::id).collect(Collectors.toList())).build();
        }
        Mono asyncMemberChunk = Mono.create(sink -> sink.onRequest(__ -> {
            Context ctx = Context.of((Object)"discord4j.gateway", (Object)Integer.toHexString(gateway.hashCode()), (Object)"discord4j.shard", (Object)context.getShardInfo().getIndex());
            Disposable memberChunkTask = Mono.just((Object)createData).filterWhen(context.getGateway().getGatewayResources().getMemberRequestFilter()::apply).flatMap(data -> {
                log.debug(LogUtil.format((ContextView)ctx, (String)"Requesting members for guild {}"), new Object[]{createData.id()});
                return context.getGateway().requestMembers(Snowflake.of((String)data.id().asString())).then();
            }).subscribe(null, t -> log.warn(LogUtil.format((ContextView)ctx, (String)"Member request errored for {}"), new Object[]{createData.id(), t}));
            sink.onCancel(memberChunkTask);
            sink.success();
        }));
        return asyncMemberChunk.thenReturn((Object)new GuildCreateEvent(gateway, context.getShardInfo(), new Guild(gateway, (GuildData)guild)));
    }

    static Mono<GuildDeleteEvent> guildDelete(DispatchContext<GuildDelete, GuildData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guild().id());
        boolean unavailable = context.getDispatch().guild().unavailable().toOptional().orElse(false);
        Guild guild = context.getOldState().map(data -> new Guild(gateway, (GuildData)data)).orElse(null);
        return Mono.just((Object)new GuildDeleteEvent(gateway, context.getShardInfo(), guildId, guild, unavailable));
    }

    static Mono<EmojisUpdateEvent> guildEmojisUpdate(DispatchContext<GuildEmojisUpdate, Set<EmojiData>> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        Set<GuildEmoji> emojis = context.getDispatch().emojis().stream().map(emoji -> new GuildEmoji(gateway, (EmojiData)emoji, guildId)).collect(Collectors.toSet());
        Set<GuildEmoji> oldEmojis = context.getOldState().map(oldState -> oldState.stream().map(data -> new GuildEmoji(gateway, (EmojiData)data, guildId)).collect(Collectors.toSet())).orElse(Collections.emptySet());
        return Mono.just((Object)new EmojisUpdateEvent(gateway, context.getShardInfo(), guildId, emojis, oldEmojis));
    }

    static Mono<IntegrationsUpdateEvent> guildIntegrationsUpdate(DispatchContext<GuildIntegrationsUpdate, Void> context) {
        return Mono.just((Object)new IntegrationsUpdateEvent(context.getGateway(), context.getShardInfo(), Snowflake.asLong((Id)context.getDispatch().guildId())));
    }

    static Mono<MemberJoinEvent> guildMemberAdd(DispatchContext<GuildMemberAdd, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        MemberData member = context.getDispatch().member();
        return Mono.just((Object)new MemberJoinEvent(gateway, context.getShardInfo(), new Member(gateway, member, guildId), guildId));
    }

    static Mono<MemberLeaveEvent> guildMemberRemove(DispatchContext<GuildMemberRemove, MemberData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        UserData userData = context.getDispatch().user();
        User user = new User(gateway, userData);
        Member oldMember = context.getOldState().map(data -> new Member(gateway, (MemberData)data, guildId)).orElse(null);
        return Mono.just((Object)new MemberLeaveEvent(gateway, context.getShardInfo(), user, guildId, oldMember));
    }

    static Mono<MemberChunkEvent> guildMembersChunk(DispatchContext<GuildMembersChunk, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        List members = context.getDispatch().members();
        int chunkIndex = context.getDispatch().chunkIndex();
        int chunkCount = context.getDispatch().chunkCount();
        List<Snowflake> notFound = context.getDispatch().notFound().toOptional().orElse(Collections.emptyList()).stream().map(Snowflake::of).collect(Collectors.toList());
        String nonce = context.getDispatch().nonce().toOptional().orElse(null);
        return Mono.just((Object)new MemberChunkEvent(gateway, context.getShardInfo(), guildId, members.stream().map(member -> new Member(gateway, (MemberData)member, guildId)).collect(Collectors.toSet()), chunkIndex, chunkCount, notFound, nonce));
    }

    static Mono<MemberUpdateEvent> guildMemberUpdate(DispatchContext<GuildMemberUpdate, MemberData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        long memberId = Snowflake.asLong((Id)context.getDispatch().user().id());
        Set<Long> currentRoleIds = context.getDispatch().roles().stream().map(Snowflake::asLong).collect(Collectors.toSet());
        String currentNick = Possible.flatOpt((Possible)context.getDispatch().nick()).orElse(null);
        String currentJoinedAt = context.getDispatch().joinedAt().orElse(null);
        String currentPremiumSince = Possible.flatOpt((Possible)context.getDispatch().premiumSince()).orElse(null);
        Boolean currentPending = context.getDispatch().pending().toOptional().orElse(null);
        Member oldMember = context.getOldState().map(data -> new Member(gateway, (MemberData)data, guildId)).orElse(null);
        return Mono.just((Object)new MemberUpdateEvent(gateway, context.getShardInfo(), guildId, memberId, oldMember, currentRoleIds, currentNick, currentJoinedAt, currentPremiumSince, currentPending));
    }

    static Mono<RoleCreateEvent> guildRoleCreate(DispatchContext<GuildRoleCreate, Void> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        RoleData role = context.getDispatch().role();
        return Mono.just((Object)new RoleCreateEvent(gateway, context.getShardInfo(), guildId, new Role(gateway, role, guildId)));
    }

    static Mono<RoleDeleteEvent> guildRoleDelete(DispatchContext<GuildRoleDelete, RoleData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        long roleId = Snowflake.asLong((Id)context.getDispatch().roleId());
        Role oldRole = context.getOldState().map(data -> new Role(gateway, (RoleData)data, guildId)).orElse(null);
        return Mono.just((Object)new RoleDeleteEvent(gateway, context.getShardInfo(), guildId, roleId, oldRole));
    }

    static Mono<RoleUpdateEvent> guildRoleUpdate(DispatchContext<GuildRoleUpdate, RoleData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        long guildId = Snowflake.asLong((Id)context.getDispatch().guildId());
        RoleData role = context.getDispatch().role();
        Role current = new Role(gateway, role, guildId);
        Role oldRole = context.getOldState().map(data -> new Role(gateway, (RoleData)data, guildId)).orElse(null);
        return Mono.just((Object)new RoleUpdateEvent(gateway, context.getShardInfo(), current, oldRole));
    }

    static Mono<GuildUpdateEvent> guildUpdate(DispatchContext<GuildUpdate, GuildData> context) {
        GatewayDiscordClient gateway = context.getGateway();
        Guild oldGuild = context.getOldState().map(data -> new Guild(gateway, (GuildData)data)).orElse(null);
        Guild newGuild = new Guild(gateway, (GuildData)GuildData.builder().from(context.getOldState().orElseGet(() -> GuildData.builder().joinedAt(DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(ZonedDateTime.now())).large(false).memberCount(((GuildUpdate)context.getDispatch()).guild().approximateMemberCount().toOptional().orElse(1).intValue()).build())).from((GuildUpdateFields)context.getDispatch().guild()).roles(context.getDispatch().guild().roles().stream().map(RoleDataFields::id).collect(Collectors.toList())).emojis(context.getDispatch().guild().emojis().stream().map(EmojiData::id).filter(Optional::isPresent).map(Optional::get).collect(Collectors.toList())).build());
        return Mono.just((Object)new GuildUpdateEvent(gateway, context.getShardInfo(), newGuild, oldGuild));
    }
}

