/*
 * Decompiled with CFR 0.152.
 */
package discord4j.core.event.dispatch;

import discord4j.common.util.Snowflake;
import discord4j.core.GatewayDiscordClient;
import discord4j.core.event.dispatch.DispatchContext;
import discord4j.core.event.domain.Event;
import discord4j.core.event.domain.channel.CategoryCreateEvent;
import discord4j.core.event.domain.channel.CategoryDeleteEvent;
import discord4j.core.event.domain.channel.CategoryUpdateEvent;
import discord4j.core.event.domain.channel.NewsChannelCreateEvent;
import discord4j.core.event.domain.channel.NewsChannelDeleteEvent;
import discord4j.core.event.domain.channel.NewsChannelUpdateEvent;
import discord4j.core.event.domain.channel.PinsUpdateEvent;
import discord4j.core.event.domain.channel.PrivateChannelDeleteEvent;
import discord4j.core.event.domain.channel.StoreChannelCreateEvent;
import discord4j.core.event.domain.channel.StoreChannelDeleteEvent;
import discord4j.core.event.domain.channel.StoreChannelUpdateEvent;
import discord4j.core.event.domain.channel.TextChannelCreateEvent;
import discord4j.core.event.domain.channel.TextChannelDeleteEvent;
import discord4j.core.event.domain.channel.TextChannelUpdateEvent;
import discord4j.core.event.domain.channel.VoiceChannelCreateEvent;
import discord4j.core.event.domain.channel.VoiceChannelDeleteEvent;
import discord4j.core.event.domain.channel.VoiceChannelUpdateEvent;
import discord4j.core.object.entity.channel.Category;
import discord4j.core.object.entity.channel.Channel;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.core.object.entity.channel.NewsChannel;
import discord4j.core.object.entity.channel.PrivateChannel;
import discord4j.core.object.entity.channel.StoreChannel;
import discord4j.core.object.entity.channel.TextChannel;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.discordjson.Id;
import discord4j.discordjson.json.ChannelData;
import discord4j.discordjson.json.gateway.ChannelCreate;
import discord4j.discordjson.json.gateway.ChannelDelete;
import discord4j.discordjson.json.gateway.ChannelPinsUpdate;
import discord4j.discordjson.json.gateway.ChannelUpdate;
import discord4j.discordjson.possible.Possible;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import reactor.core.publisher.Mono;

class ChannelDispatchHandlers {
    ChannelDispatchHandlers() {
    }

    static Mono<? extends Event> channelCreate(DispatchContext<ChannelCreate, Void> context) {
        Channel.Type type = Channel.Type.of(context.getDispatch().channel().type());
        GatewayDiscordClient gateway = context.getGateway();
        ChannelData channel = context.getDispatch().channel();
        return Mono.fromCallable(() -> {
            switch (type) {
                case GUILD_TEXT: {
                    return new TextChannelCreateEvent(gateway, context.getShardInfo(), new TextChannel(gateway, channel));
                }
                case GUILD_VOICE: 
                case GUILD_STAGE_VOICE: {
                    return new VoiceChannelCreateEvent(gateway, context.getShardInfo(), new VoiceChannel(gateway, channel));
                }
                case GROUP_DM: {
                    throw new UnsupportedOperationException("Received channel_create for group on a bot account!");
                }
                case GUILD_CATEGORY: {
                    return new CategoryCreateEvent(gateway, context.getShardInfo(), new Category(gateway, channel));
                }
                case GUILD_NEWS: {
                    return new NewsChannelCreateEvent(gateway, context.getShardInfo(), new NewsChannel(gateway, channel));
                }
                case GUILD_STORE: {
                    return new StoreChannelCreateEvent(gateway, context.getShardInfo(), new StoreChannel(gateway, channel));
                }
            }
            throw new IllegalArgumentException("Unhandled channel type " + ((ChannelCreate)context.getDispatch()).channel().type());
        });
    }

    static Mono<? extends Event> channelDelete(DispatchContext<ChannelDelete, ChannelData> context) {
        Channel.Type type = Channel.Type.of(context.getDispatch().channel().type());
        GatewayDiscordClient gateway = context.getGateway();
        ChannelData channel = context.getDispatch().channel();
        return Mono.fromCallable(() -> {
            switch (type) {
                case GUILD_TEXT: {
                    return new TextChannelDeleteEvent(gateway, context.getShardInfo(), new TextChannel(gateway, channel));
                }
                case DM: {
                    return new PrivateChannelDeleteEvent(gateway, context.getShardInfo(), new PrivateChannel(gateway, channel));
                }
                case GUILD_VOICE: 
                case GUILD_STAGE_VOICE: {
                    return new VoiceChannelDeleteEvent(gateway, context.getShardInfo(), new VoiceChannel(gateway, channel));
                }
                case GROUP_DM: {
                    throw new UnsupportedOperationException("Received channel_delete for a group on a bot account!");
                }
                case GUILD_CATEGORY: {
                    return new CategoryDeleteEvent(gateway, context.getShardInfo(), new Category(gateway, channel));
                }
                case GUILD_NEWS: {
                    return new NewsChannelDeleteEvent(gateway, context.getShardInfo(), new NewsChannel(gateway, channel));
                }
                case GUILD_STORE: {
                    return new StoreChannelDeleteEvent(gateway, context.getShardInfo(), new StoreChannel(gateway, channel));
                }
            }
            throw new IllegalArgumentException("Unhandled channel type " + ((ChannelDelete)context.getDispatch()).channel().type());
        });
    }

    static Mono<PinsUpdateEvent> channelPinsUpdate(DispatchContext<ChannelPinsUpdate, Void> context) {
        long channelId = Snowflake.asLong((Id)context.getDispatch().channelId());
        Long guildId = context.getDispatch().guildId().toOptional().map(Snowflake::asLong).orElse(null);
        Instant timestamp = Possible.flatOpt((Possible)context.getDispatch().lastPinTimestamp()).map(text -> DateTimeFormatter.ISO_OFFSET_DATE_TIME.parse((CharSequence)text, Instant::from)).orElse(null);
        return Mono.just((Object)new PinsUpdateEvent(context.getGateway(), context.getShardInfo(), channelId, guildId, timestamp));
    }

    static Mono<? extends Event> channelUpdate(DispatchContext<ChannelUpdate, ChannelData> context) {
        Channel.Type type = Channel.Type.of(context.getDispatch().channel().type());
        GatewayDiscordClient gateway = context.getGateway();
        ChannelData channel = context.getDispatch().channel();
        Optional<ChannelData> oldData = context.getOldState();
        return Mono.fromCallable(() -> {
            switch (type) {
                case GUILD_TEXT: {
                    return new TextChannelUpdateEvent(gateway, context.getShardInfo(), ChannelDispatchHandlers.getConvertibleChannel(gateway, channel), oldData.map(old -> new TextChannel(gateway, (ChannelData)old)).orElse(null));
                }
                case DM: {
                    throw new UnsupportedOperationException("Received channel_update for a DM on a bot account!");
                }
                case GUILD_VOICE: 
                case GUILD_STAGE_VOICE: {
                    return new VoiceChannelUpdateEvent(gateway, context.getShardInfo(), new VoiceChannel(gateway, channel), oldData.map(old -> new VoiceChannel(gateway, (ChannelData)old)).orElse(null));
                }
                case GROUP_DM: {
                    throw new UnsupportedOperationException("Received channel_update for a group on a bot account!");
                }
                case GUILD_CATEGORY: {
                    return new CategoryUpdateEvent(gateway, context.getShardInfo(), new Category(gateway, channel), oldData.map(old -> new Category(gateway, (ChannelData)old)).orElse(null));
                }
                case GUILD_NEWS: {
                    return new NewsChannelUpdateEvent(gateway, context.getShardInfo(), ChannelDispatchHandlers.getConvertibleChannel(gateway, channel), oldData.map(old -> new NewsChannel(gateway, (ChannelData)old)).orElse(null));
                }
                case GUILD_STORE: {
                    return new StoreChannelUpdateEvent(gateway, context.getShardInfo(), new StoreChannel(gateway, channel), oldData.map(old -> new StoreChannel(gateway, (ChannelData)old)).orElse(null));
                }
            }
            throw new IllegalArgumentException("Unhandled channel type " + ((ChannelUpdate)context.getDispatch()).channel().type());
        });
    }

    private static GuildMessageChannel getConvertibleChannel(GatewayDiscordClient gateway, ChannelData channel) {
        switch (Channel.Type.of(channel.type())) {
            case GUILD_NEWS: {
                return new NewsChannel(gateway, channel);
            }
            case GUILD_TEXT: {
                return new TextChannel(gateway, channel);
            }
        }
        throw new IllegalArgumentException("Unhandled channel type " + channel.type());
    }
}

