package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookMessageEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code WebhookMessageEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code WebhookMessageEditSpec.create()}.
 */
@Generated(from = "WebhookMessageEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookMessageEditSpec implements WebhookMessageEditSpecGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final List<EmbedCreateSpec> embeds;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private WebhookMessageEditSpec() {
    Possible<Optional<String>> content$impl = Possible.absent();
    Possible<Optional<AllowedMentions>> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private WebhookMessageEditSpec(WebhookMessageEditSpec.Builder builder) {
    Possible<Optional<String>> content$impl = builder.content_build();
    Possible<Optional<AllowedMentions>> allowedMentions$impl = builder.allowedMentions_build();
    Possible<List<LayoutComponent>> components$impl = builder.components_build();
    if (builder.filesIsSet()) {
      initShim.files(createUnmodifiableList(true, builder.files));
    }
    if (builder.fileSpoilersIsSet()) {
      initShim.fileSpoilers(createUnmodifiableList(true, builder.fileSpoilers));
    }
    if (builder.embedsIsSet()) {
      initShim.embeds(createUnmodifiableList(true, builder.embeds));
    }
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private WebhookMessageEditSpec(
      Possible<Optional<String>> content,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      List<EmbedCreateSpec> embeds,
      Possible<Optional<AllowedMentions>> allowedMentions,
      Possible<List<LayoutComponent>> components) {
    Possible<Optional<String>> content$impl = content;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    initShim.embeds(embeds);
    Possible<Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookMessageEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(filesInitialize(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(fileSpoilersInitialize(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private byte embedsBuildStage = STAGE_UNINITIALIZED;
    private List<EmbedCreateSpec> embeds;

    List<EmbedCreateSpec> embeds() {
      if (embedsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (embedsBuildStage == STAGE_UNINITIALIZED) {
        embedsBuildStage = STAGE_INITIALIZING;
        this.embeds = createUnmodifiableList(false, createSafeList(embedsInitialize(), true, false));
        embedsBuildStage = STAGE_INITIALIZED;
      }
      return this.embeds;
    }

    void embeds(List<EmbedCreateSpec> embeds) {
      this.embeds = embeds;
      embedsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      if (embedsBuildStage == STAGE_INITIALIZING) attributes.add("embeds");
      return "Cannot build WebhookMessageEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  private List<MessageCreateFields.File> filesInitialize() {
    return WebhookMessageEditSpecGenerator.super.files();
  }

  private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
    return WebhookMessageEditSpecGenerator.super.fileSpoilers();
  }

  private List<EmbedCreateSpec> embedsInitialize() {
    return WebhookMessageEditSpecGenerator.super.embeds();
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(content_value));
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public List<EmbedCreateSpec> embeds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.embeds()
        : this.embeds;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(allowedMentions_value));
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  public WebhookMessageEditSpec withContent(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return validate(new WebhookMessageEditSpec(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
  }

  @Deprecated
  public WebhookMessageEditSpec withContent(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new WebhookMessageEditSpec(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
  }

  public WebhookMessageEditSpec withContentOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new WebhookMessageEditSpec(newValue, this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditSpecGenerator#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditSpec withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new WebhookMessageEditSpec(
        this.content(),
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditSpecGenerator#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new WebhookMessageEditSpec(
        this.content(),
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditSpec withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new WebhookMessageEditSpec(this.content(), this.files, newValue, this.embeds, this.allowedMentions(), this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new WebhookMessageEditSpec(this.content(), this.files, newValue, this.embeds, this.allowedMentions(), this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditSpecGenerator#embeds() embeds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditSpec withEmbeds(EmbedCreateSpec... elements) {
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new WebhookMessageEditSpec(
        this.content(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditSpecGenerator#embeds() embeds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of embeds elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditSpec withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
    if (this.embeds == elements) return this;
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new WebhookMessageEditSpec(
        this.content(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookMessageEditSpec withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
    Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
    return validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
  }

  @Deprecated
  public WebhookMessageEditSpec withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
  }

  public WebhookMessageEditSpec withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, newValue, this.components()));
  }

  public WebhookMessageEditSpec withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
  }

  public WebhookMessageEditSpec withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
  }

  @SafeVarargs
  public final WebhookMessageEditSpec withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new WebhookMessageEditSpec(this.content(), this.files, this.fileSpoilers, this.embeds, this.allowedMentions(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code WebhookMessageEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookMessageEditSpec
        && equalTo(0, (WebhookMessageEditSpec) another);
  }

  private boolean equalTo(int synthetic, WebhookMessageEditSpec another) {
    return this.content().equals(another.content())
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && embeds.equals(another.embeds)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code files}, {@code fileSpoilers}, {@code embeds}, {@code allowedMentions}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + embeds.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookMessageEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookMessageEditSpec{"
        + "content=" + (content().toString())
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", embeds=" + embeds
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + "}";
  }

  private static final WebhookMessageEditSpec INSTANCE = validate(new WebhookMessageEditSpec());

  /**
   * Returns the default immutable singleton value of {@code WebhookMessageEditSpec}
   * @return An immutable instance of WebhookMessageEditSpec
   */
  public static WebhookMessageEditSpec create() {
    return INSTANCE;
  }

  private static WebhookMessageEditSpec validate(WebhookMessageEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link WebhookMessageEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookMessageEditSpec instance
   */
  public static WebhookMessageEditSpec copyOf(WebhookMessageEditSpecGenerator instance) {
    if (instance instanceof WebhookMessageEditSpec) {
      return (WebhookMessageEditSpec) instance;
    }
    return WebhookMessageEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link WebhookMessageEditSpec WebhookMessageEditSpec}.
   * <pre>
   * WebhookMessageEditSpec.builder()
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link WebhookMessageEditSpecGenerator#content() content}
   *    .addFile|addAllFiles(discord4j.core.spec.MessageCreateFields.File) // {@link WebhookMessageEditSpecGenerator#files() files} elements
   *    .addFileSpoiler|addAllFileSpoilers(discord4j.core.spec.MessageCreateFields.FileSpoiler) // {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers} elements
   *    .addEmbed|addAllEmbeds(EmbedCreateSpec) // {@link WebhookMessageEditSpecGenerator#embeds() embeds} elements
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;&amp;gt;) // {@link WebhookMessageEditSpecGenerator#allowedMentions() allowedMentions}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;) // {@link WebhookMessageEditSpecGenerator#components() components}
   *    .build();
   * </pre>
   * @return A new WebhookMessageEditSpec builder
   */
  public static WebhookMessageEditSpec.Builder builder() {
    return new WebhookMessageEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link WebhookMessageEditSpec WebhookMessageEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebhookMessageEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_FILES = 0x1L;
    private static final long OPT_BIT_FILE_SPOILERS = 0x2L;
    private static final long OPT_BIT_EMBEDS = 0x4L;
    private long optBits;

    private Possible<Optional<String>> content_possible = Possible.absent();
    private Possible<Optional<AllowedMentions>> allowedMentions_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;
    private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
    private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();
    private List<EmbedCreateSpec> embeds = new ArrayList<EmbedCreateSpec>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebhookMessageEditSpecGenerator} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder from(WebhookMessageEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      content(instance.content());
      addAllFiles(instance.files());
      addAllFileSpoilers(instance.fileSpoilers());
      addAllEmbeds(instance.embeds());
      allowedMentions(instance.allowedMentions());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<Optional<String>> value) {
      this.content_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder content(@Nullable String value) {
      this.content_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder contentOrNull(@Nullable String value) {
      this.content_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Adds one element to {@link WebhookMessageEditSpecGenerator#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFile(MessageCreateFields.File element) {
      element = ImmutableMessageCreateFields.File.copyOf(element);
      this.files.add(Objects.requireNonNull(element, "files element"));
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link WebhookMessageEditSpecGenerator#files() files} list.
     * @param name The value for {@code files.name} 
     * @param inputStream The value for {@code files.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFile(String name, InputStream inputStream) {
      return addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
    }

    /**
     * Adds elements to {@link WebhookMessageEditSpecGenerator#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(MessageCreateFields.File... elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookMessageEditSpecGenerator#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
      this.files.clear();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link WebhookMessageEditSpecGenerator#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Adds one element to {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers} list.
     * @param element A fileSpoilers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
      element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
      this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers} list.
     * @param name The value for {@code fileSpoilers.name} 
     * @param inputStream The value for {@code fileSpoilers.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFileSpoiler(String name, InputStream inputStream) {
      return addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
    }

    /**
     * Adds elements to {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers} list.
     * @param elements An array of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      this.fileSpoilers.clear();
      return addAllFileSpoilers(elements);
    }

    /**
     * Adds elements to {@link WebhookMessageEditSpecGenerator#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    /**
     * Adds one element to {@link WebhookMessageEditSpecGenerator#embeds() embeds} list.
     * @param element A embeds element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEmbed(EmbedCreateSpec element) {
      this.embeds.add(Objects.requireNonNull(element, "embeds element"));
      optBits |= OPT_BIT_EMBEDS;
      return this;
    }

    /**
     * Adds elements to {@link WebhookMessageEditSpecGenerator#embeds() embeds} list.
     * @param elements An array of embeds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEmbeds(EmbedCreateSpec... elements) {
      for (EmbedCreateSpec element : elements) {
        this.embeds.add(Objects.requireNonNull(element, "embeds element"));
      }
      optBits |= OPT_BIT_EMBEDS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookMessageEditSpecGenerator#embeds() embeds} list.
     * @param elements An iterable of embeds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder embeds(Iterable<? extends EmbedCreateSpec> elements) {
      this.embeds.clear();
      return addAllEmbeds(elements);
    }

    /**
     * Adds elements to {@link WebhookMessageEditSpecGenerator#embeds() embeds} list.
     * @param elements An iterable of embeds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
      for (EmbedCreateSpec element : elements) {
        this.embeds.add(Objects.requireNonNull(element, "embeds element"));
      }
      optBits |= OPT_BIT_EMBEDS;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<Optional<AllowedMentions>> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder allowedMentions(@Nullable AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentionsOrNull(@Nullable AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<List<LayoutComponent>> elements) {
      this.components_list = null;
      elements.toOptional().ifPresent(e -> components_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(java.lang.Iterable<LayoutComponent> elements) {
      this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link WebhookMessageEditSpec WebhookMessageEditSpec}.
     * @return An immutable instance of WebhookMessageEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WebhookMessageEditSpec build() {
      return WebhookMessageEditSpec.validate(new WebhookMessageEditSpec(this));
    }

    private boolean filesIsSet() {
      return (optBits & OPT_BIT_FILES) != 0;
    }

    private boolean fileSpoilersIsSet() {
      return (optBits & OPT_BIT_FILE_SPOILERS) != 0;
    }

    private boolean embedsIsSet() {
      return (optBits & OPT_BIT_EMBEDS) != 0;
    }

    private Possible<Optional<String>> content_build() {
      return this.content_possible;
    }

    private Possible<Optional<AllowedMentions>> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<List<LayoutComponent>> components_build() {
      return this.components_list == null ? Possible.absent() :
          Possible.of(this.components_list);
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
