package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Webhook;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookMessageEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code WebhookMessageEditMono.of()}.
 */
@Generated(from = "WebhookMessageEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookMessageEditMono extends WebhookMessageEditMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final List<EmbedCreateSpec> embeds;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final Snowflake messageId;
  private final Webhook webhook;

  private WebhookMessageEditMono(Snowflake messageId, Webhook webhook) {
    this.messageId = Objects.requireNonNull(messageId, "messageId");
    this.webhook = Objects.requireNonNull(webhook, "webhook");
    Possible<Optional<String>> content$impl = Possible.absent();
    Possible<Optional<AllowedMentions>> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private WebhookMessageEditMono(
      Possible<Optional<String>> content,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      List<EmbedCreateSpec> embeds,
      Possible<Optional<AllowedMentions>> allowedMentions,
      Possible<List<LayoutComponent>> components,
      Snowflake messageId,
      Webhook webhook) {
    Possible<Optional<String>> content$impl = content;
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    initShim.embeds(embeds);
    Possible<Optional<AllowedMentions>> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.messageId = messageId;
    this.webhook = webhook;
    this.content_value = Possible.flatOpt(content$impl).orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.allowedMentions_value = Possible.flatOpt(allowedMentions$impl).orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookMessageEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(WebhookMessageEditMono.super.files(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(WebhookMessageEditMono.super.fileSpoilers(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private byte embedsBuildStage = STAGE_UNINITIALIZED;
    private List<EmbedCreateSpec> embeds;

    List<EmbedCreateSpec> embeds() {
      if (embedsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (embedsBuildStage == STAGE_UNINITIALIZED) {
        embedsBuildStage = STAGE_INITIALIZING;
        this.embeds = createUnmodifiableList(false, createSafeList(WebhookMessageEditMono.super.embeds(), true, false));
        embedsBuildStage = STAGE_INITIALIZED;
      }
      return this.embeds;
    }

    void embeds(List<EmbedCreateSpec> embeds) {
      this.embeds = embeds;
      embedsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      if (embedsBuildStage == STAGE_INITIALIZING) attributes.add("embeds");
      return "Cannot build WebhookMessageEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<Optional<String>> content() {
    return content_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(content_value));
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public List<EmbedCreateSpec> embeds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.embeds()
        : this.embeds;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<Optional<AllowedMentions>> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(allowedMentions_value));
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  /**
   * @return The value of the {@code messageId} attribute
   */
  @Override
  public Snowflake messageId() {
    return messageId;
  }

  /**
   * @return The value of the {@code webhook} attribute
   */
  @Override
  public Webhook webhook() {
    return webhook;
  }

  public WebhookMessageEditMono withContent(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new WebhookMessageEditMono(
        newValue,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  @Deprecated
  public WebhookMessageEditMono withContent(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookMessageEditMono(
        newValue,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  public WebhookMessageEditMono withContentOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookMessageEditMono(
        newValue,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditMono withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new WebhookMessageEditMono(
        this.content(),
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new WebhookMessageEditMono(
        this.content(),
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        newValue,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        newValue,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditMono#embeds() embeds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditMono withEmbeds(EmbedCreateSpec... elements) {
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookMessageEditMono#embeds() embeds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of embeds elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookMessageEditMono withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
    if (this.embeds == elements) return this;
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        this.webhook);
  }

  public WebhookMessageEditMono withAllowedMentions(Possible<Optional<AllowedMentions>> value) {
    Possible<Optional<AllowedMentions>> newValue = Objects.requireNonNull(value);
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components(),
        this.messageId,
        this.webhook);
  }

  @Deprecated
  public WebhookMessageEditMono withAllowedMentions(@Nullable AllowedMentions value) {
    Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components(),
        this.messageId,
        this.webhook);
  }

  public WebhookMessageEditMono withAllowedMentionsOrNull(@Nullable AllowedMentions value) {
    Possible<Optional<AllowedMentions>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components(),
        this.messageId,
        this.webhook);
  }

  public WebhookMessageEditMono withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue,
        this.messageId,
        this.webhook);
  }

  public WebhookMessageEditMono withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue,
        this.messageId,
        this.webhook);
  }

  @SafeVarargs
  public final WebhookMessageEditMono withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue,
        this.messageId,
        this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookMessageEditMono#messageId() messageId} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for messageId
   * @return A modified copy of the {@code this} object
   */
  public final WebhookMessageEditMono withMessageId(Snowflake value) {
    if (this.messageId == value) return this;
    Snowflake newValue = Objects.requireNonNull(value, "messageId");
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        newValue,
        this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookMessageEditMono#webhook() webhook} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for webhook
   * @return A modified copy of the {@code this} object
   */
  public final WebhookMessageEditMono withWebhook(Webhook value) {
    if (this.webhook == value) return this;
    Webhook newValue = Objects.requireNonNull(value, "webhook");
    return new WebhookMessageEditMono(
        this.content(),
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.messageId,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code WebhookMessageEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookMessageEditMono
        && equalTo(0, (WebhookMessageEditMono) another);
  }

  private boolean equalTo(int synthetic, WebhookMessageEditMono another) {
    return this.content().equals(another.content())
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && embeds.equals(another.embeds)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && messageId.equals(another.messageId)
        && webhook.equals(another.webhook);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code files}, {@code fileSpoilers}, {@code embeds}, {@code allowedMentions}, {@code components}, {@code messageId}, {@code webhook}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + embeds.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + messageId.hashCode();
    h += (h << 5) + webhook.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookMessageEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookMessageEditMono{"
        + "content=" + (content().toString())
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", embeds=" + embeds
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + ", messageId=" + messageId
        + ", webhook=" + webhook
        + "}";
  }

  /**
   * Construct a new immutable {@code WebhookMessageEditMono} instance.
   * @param messageId The value for the {@code messageId} attribute
   * @param webhook The value for the {@code webhook} attribute
   * @return An immutable WebhookMessageEditMono instance
   */
  public static WebhookMessageEditMono of(Snowflake messageId, Webhook webhook) {
    return new WebhookMessageEditMono(messageId, webhook);
  }

  /**
   * Creates an immutable copy of a {@link WebhookMessageEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookMessageEditMono instance
   */
  static WebhookMessageEditMono copyOf(WebhookMessageEditMonoGenerator instance) {
    if (instance instanceof WebhookMessageEditMono) {
      return (WebhookMessageEditMono) instance;
    }
    return WebhookMessageEditMono.of(instance.messageId(), instance.webhook())
        .withContent(instance.content())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withEmbeds(instance.embeds())
        .withAllowedMentions(instance.allowedMentions())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
