package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WebhookExecuteSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code WebhookExecuteSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code WebhookExecuteSpec.create()}.
 */
@Generated(from = "WebhookExecuteSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookExecuteSpec implements WebhookExecuteSpecGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final String username_value;
  private final boolean username_absent;
  private final String avatarUrl_value;
  private final boolean avatarUrl_absent;
  private final boolean tts;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final List<EmbedCreateSpec> embeds;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;

  private WebhookExecuteSpec() {
    Possible<String> content$impl = Possible.absent();
    Possible<String> username$impl = Possible.absent();
    Possible<String> avatarUrl$impl = Possible.absent();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
    this.avatarUrl_absent = avatarUrl$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.tts = initShim.tts();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private WebhookExecuteSpec(WebhookExecuteSpec.Builder builder) {
    Possible<String> content$impl = builder.content_build();
    Possible<String> username$impl = builder.username_build();
    Possible<String> avatarUrl$impl = builder.avatarUrl_build();
    Possible<AllowedMentions> allowedMentions$impl = builder.allowedMentions_build();
    Possible<List<LayoutComponent>> components$impl = builder.components_build();
    if (builder.ttsIsSet()) {
      initShim.tts(builder.tts);
    }
    if (builder.filesIsSet()) {
      initShim.files(createUnmodifiableList(true, builder.files));
    }
    if (builder.fileSpoilersIsSet()) {
      initShim.fileSpoilers(createUnmodifiableList(true, builder.fileSpoilers));
    }
    if (builder.embedsIsSet()) {
      initShim.embeds(createUnmodifiableList(true, builder.embeds));
    }
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
    this.avatarUrl_absent = avatarUrl$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.tts = initShim.tts();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private WebhookExecuteSpec(
      Possible<String> content,
      Possible<String> username,
      Possible<String> avatarUrl,
      boolean tts,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      List<EmbedCreateSpec> embeds,
      Possible<AllowedMentions> allowedMentions,
      Possible<List<LayoutComponent>> components) {
    Possible<String> content$impl = content;
    Possible<String> username$impl = username;
    Possible<String> avatarUrl$impl = avatarUrl;
    initShim.tts(tts);
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    initShim.embeds(embeds);
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
    this.avatarUrl_absent = avatarUrl$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.tts = initShim.tts();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookExecuteSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte ttsBuildStage = STAGE_UNINITIALIZED;
    private boolean tts;

    boolean tts() {
      if (ttsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ttsBuildStage == STAGE_UNINITIALIZED) {
        ttsBuildStage = STAGE_INITIALIZING;
        this.tts = ttsInitialize();
        ttsBuildStage = STAGE_INITIALIZED;
      }
      return this.tts;
    }

    void tts(boolean tts) {
      this.tts = tts;
      ttsBuildStage = STAGE_INITIALIZED;
    }

    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(filesInitialize(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(fileSpoilersInitialize(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private byte embedsBuildStage = STAGE_UNINITIALIZED;
    private List<EmbedCreateSpec> embeds;

    List<EmbedCreateSpec> embeds() {
      if (embedsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (embedsBuildStage == STAGE_UNINITIALIZED) {
        embedsBuildStage = STAGE_INITIALIZING;
        this.embeds = createUnmodifiableList(false, createSafeList(embedsInitialize(), true, false));
        embedsBuildStage = STAGE_INITIALIZED;
      }
      return this.embeds;
    }

    void embeds(List<EmbedCreateSpec> embeds) {
      this.embeds = embeds;
      embedsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (ttsBuildStage == STAGE_INITIALIZING) attributes.add("tts");
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      if (embedsBuildStage == STAGE_INITIALIZING) attributes.add("embeds");
      return "Cannot build WebhookExecuteSpec, attribute initializers form cycle " + attributes;
    }
  }

  private boolean ttsInitialize() {
    return WebhookExecuteSpecGenerator.super.tts();
  }

  private List<MessageCreateFields.File> filesInitialize() {
    return WebhookExecuteSpecGenerator.super.files();
  }

  private List<MessageCreateFields.FileSpoiler> fileSpoilersInitialize() {
    return WebhookExecuteSpecGenerator.super.fileSpoilers();
  }

  private List<EmbedCreateSpec> embedsInitialize() {
    return WebhookExecuteSpecGenerator.super.embeds();
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public Possible<String> username() {
    return username_absent ? Possible.absent() : Possible.of(username_value);
  }

  /**
   * @return The value of the {@code avatarUrl} attribute
   */
  @Override
  public Possible<String> avatarUrl() {
    return avatarUrl_absent ? Possible.absent() : Possible.of(avatarUrl_value);
  }

  /**
   * @return The value of the {@code tts} attribute
   */
  @Override
  public boolean tts() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tts()
        : this.tts;
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public List<EmbedCreateSpec> embeds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.embeds()
        : this.embeds;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  public WebhookExecuteSpec withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new WebhookExecuteSpec(
        newValue,
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookExecuteSpec withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new WebhookExecuteSpec(
        newValue,
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookExecuteSpec withUsername(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new WebhookExecuteSpec(
        this.content(),
        newValue,
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookExecuteSpec withUsername(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new WebhookExecuteSpec(
        this.content(),
        newValue,
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookExecuteSpec withAvatarUrl(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        newValue,
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookExecuteSpec withAvatarUrl(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        newValue,
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookExecuteSpec#tts() tts} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tts
   * @return A modified copy of the {@code this} object
   */
  public final WebhookExecuteSpec withTts(boolean value) {
    if (this.tts == value) return this;
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        value,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteSpec#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteSpec withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteSpec#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteSpec withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteSpec withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        newValue,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteSpec withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        newValue,
        this.embeds,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteSpec#embeds() embeds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteSpec withEmbeds(EmbedCreateSpec... elements) {
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteSpec#embeds() embeds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of embeds elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteSpec withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
    if (this.embeds == elements) return this;
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components()));
  }

  public WebhookExecuteSpec withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components()));
  }

  public WebhookExecuteSpec withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components()));
  }

  public WebhookExecuteSpec withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue));
  }

  public WebhookExecuteSpec withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue));
  }

  @SafeVarargs
  public final WebhookExecuteSpec withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new WebhookExecuteSpec(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code WebhookExecuteSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookExecuteSpec
        && equalTo(0, (WebhookExecuteSpec) another);
  }

  private boolean equalTo(int synthetic, WebhookExecuteSpec another) {
    return this.content().equals(another.content())
        && this.username().equals(another.username())
        && this.avatarUrl().equals(another.avatarUrl())
        && tts == another.tts
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && embeds.equals(another.embeds)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code username}, {@code avatarUrl}, {@code tts}, {@code files}, {@code fileSpoilers}, {@code embeds}, {@code allowedMentions}, {@code components}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (username().hashCode());
    h += (h << 5) + (avatarUrl().hashCode());
    h += (h << 5) + Boolean.hashCode(tts);
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + embeds.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookExecuteSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookExecuteSpec{"
        + "content=" + (content().toString())
        + ", username=" + (username().toString())
        + ", avatarUrl=" + (avatarUrl().toString())
        + ", tts=" + tts
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", embeds=" + embeds
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + "}";
  }

  private static final WebhookExecuteSpec INSTANCE = validate(new WebhookExecuteSpec());

  /**
   * Returns the default immutable singleton value of {@code WebhookExecuteSpec}
   * @return An immutable instance of WebhookExecuteSpec
   */
  public static WebhookExecuteSpec create() {
    return INSTANCE;
  }

  private static WebhookExecuteSpec validate(WebhookExecuteSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link WebhookExecuteSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookExecuteSpec instance
   */
  static WebhookExecuteSpec copyOf(WebhookExecuteSpecGenerator instance) {
    if (instance instanceof WebhookExecuteSpec) {
      return (WebhookExecuteSpec) instance;
    }
    return WebhookExecuteSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isUsernamePresent() {
    return !username_absent;
  }

  public String usernameOrElse(String defaultValue) {
    return !username_absent ? username_value : defaultValue;
  }

  public boolean isAvatarUrlPresent() {
    return !avatarUrl_absent;
  }

  public String avatarUrlOrElse(String defaultValue) {
    return !avatarUrl_absent ? avatarUrl_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  /**
   * Creates a builder for {@link WebhookExecuteSpec WebhookExecuteSpec}.
   * <pre>
   * WebhookExecuteSpec.builder()
   *    .content(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link WebhookExecuteSpec#content() content}
   *    .username(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link WebhookExecuteSpec#username() username}
   *    .avatarUrl(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link WebhookExecuteSpec#avatarUrl() avatarUrl}
   *    .tts(boolean) // optional {@link WebhookExecuteSpec#tts() tts}
   *    .addFile|addAllFiles(discord4j.core.spec.MessageCreateFields.File) // {@link WebhookExecuteSpec#files() files} elements
   *    .addFileSpoiler|addAllFileSpoilers(discord4j.core.spec.MessageCreateFields.FileSpoiler) // {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers} elements
   *    .addEmbed|addAllEmbeds(EmbedCreateSpec) // {@link WebhookExecuteSpec#embeds() embeds} elements
   *    .allowedMentions(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.AllowedMentions&amp;gt;) // {@link WebhookExecuteSpec#allowedMentions() allowedMentions}
   *    .components(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.component.LayoutComponent&amp;gt;&amp;gt;) // {@link WebhookExecuteSpec#components() components}
   *    .build();
   * </pre>
   * @return A new WebhookExecuteSpec builder
   */
  public static WebhookExecuteSpec.Builder builder() {
    return new WebhookExecuteSpec.Builder();
  }

  /**
   * Builds instances of type {@link WebhookExecuteSpec WebhookExecuteSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebhookExecuteSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_TTS = 0x1L;
    private static final long OPT_BIT_FILES = 0x2L;
    private static final long OPT_BIT_FILE_SPOILERS = 0x4L;
    private static final long OPT_BIT_EMBEDS = 0x8L;
    private long optBits;

    private Possible<String> content_possible = Possible.absent();
    private Possible<String> username_possible = Possible.absent();
    private Possible<String> avatarUrl_possible = Possible.absent();
    private Possible<AllowedMentions> allowedMentions_possible = Possible.absent();
    private List<LayoutComponent> components_list = null;
    private boolean tts;
    private List<MessageCreateFields.File> files = new ArrayList<MessageCreateFields.File>();
    private List<MessageCreateFields.FileSpoiler> fileSpoilers = new ArrayList<MessageCreateFields.FileSpoiler>();
    private List<EmbedCreateSpec> embeds = new ArrayList<EmbedCreateSpec>();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebhookExecuteSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * Collection elements and entries will be added, not replaced.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(WebhookExecuteSpec instance) {
      return from((WebhookExecuteSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code WebhookExecuteSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(WebhookExecuteSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      content(instance.content());
      username(instance.username());
      avatarUrl(instance.avatarUrl());
      tts(instance.tts());
      addAllFiles(instance.files());
      addAllFileSpoilers(instance.fileSpoilers());
      addAllEmbeds(instance.embeds());
      allowedMentions(instance.allowedMentions());
      components(instance.components());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(Possible<String> value) {
      this.content_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder content(String value) {
      this.content_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder username(Possible<String> value) {
      this.username_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder username(String value) {
      this.username_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatarUrl(Possible<String> value) {
      this.avatarUrl_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatarUrl(String value) {
      this.avatarUrl_possible = Possible.of(value);
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookExecuteSpec#tts() tts} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link WebhookExecuteSpec#tts() tts}.</em>
     * @param tts The value for tts 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder tts(boolean tts) {
      this.tts = tts;
      optBits |= OPT_BIT_TTS;
      return this;
    }

    /**
     * Adds one element to {@link WebhookExecuteSpec#files() files} list.
     * @param element A files element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFile(MessageCreateFields.File element) {
      element = ImmutableMessageCreateFields.File.copyOf(element);
      this.files.add(Objects.requireNonNull(element, "files element"));
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link WebhookExecuteSpec#files() files} list.
     * @param name The value for {@code files.name} 
     * @param inputStream The value for {@code files.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFile(String name, InputStream inputStream) {
      return addFile(ImmutableMessageCreateFields.File.of(name, inputStream));
    }

    /**
     * Adds elements to {@link WebhookExecuteSpec#files() files} list.
     * @param elements An array of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFiles(MessageCreateFields.File... elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookExecuteSpec#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder files(Iterable<? extends MessageCreateFields.File> elements) {
      this.files.clear();
      return addAllFiles(elements);
    }

    /**
     * Adds elements to {@link WebhookExecuteSpec#files() files} list.
     * @param elements An iterable of files elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFiles(Iterable<? extends MessageCreateFields.File> elements) {
      for (MessageCreateFields.File element : elements) {
        element = ImmutableMessageCreateFields.File.copyOf(element);
        this.files.add(Objects.requireNonNull(element, "files element"));
      }
      optBits |= OPT_BIT_FILES;
      return this;
    }

    /**
     * Adds one element to {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers} list.
     * @param element A fileSpoilers element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoiler(MessageCreateFields.FileSpoiler element) {
      element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
      this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    /**
     * Constructs and adds an element for the {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers} list.
     * @param name The value for {@code fileSpoilers.name} 
     * @param inputStream The value for {@code fileSpoilers.inputStream} 
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder addFileSpoiler(String name, InputStream inputStream) {
      return addFileSpoiler(ImmutableMessageCreateFields.FileSpoiler.of(name, inputStream));
    }

    /**
     * Adds elements to {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An array of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder fileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      this.fileSpoilers.clear();
      return addAllFileSpoilers(elements);
    }

    /**
     * Adds elements to {@link WebhookExecuteSpec#fileSpoilers() fileSpoilers} list.
     * @param elements An iterable of fileSpoilers elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
      for (MessageCreateFields.FileSpoiler element : elements) {
        element = ImmutableMessageCreateFields.FileSpoiler.copyOf(element);
        this.fileSpoilers.add(Objects.requireNonNull(element, "fileSpoilers element"));
      }
      optBits |= OPT_BIT_FILE_SPOILERS;
      return this;
    }

    /**
     * Adds one element to {@link WebhookExecuteSpec#embeds() embeds} list.
     * @param element A embeds element
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEmbed(EmbedCreateSpec element) {
      this.embeds.add(Objects.requireNonNull(element, "embeds element"));
      optBits |= OPT_BIT_EMBEDS;
      return this;
    }

    /**
     * Adds elements to {@link WebhookExecuteSpec#embeds() embeds} list.
     * @param elements An array of embeds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addEmbeds(EmbedCreateSpec... elements) {
      for (EmbedCreateSpec element : elements) {
        this.embeds.add(Objects.requireNonNull(element, "embeds element"));
      }
      optBits |= OPT_BIT_EMBEDS;
      return this;
    }


    /**
     * Sets or replaces all elements for {@link WebhookExecuteSpec#embeds() embeds} list.
     * @param elements An iterable of embeds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder embeds(Iterable<? extends EmbedCreateSpec> elements) {
      this.embeds.clear();
      return addAllEmbeds(elements);
    }

    /**
     * Adds elements to {@link WebhookExecuteSpec#embeds() embeds} list.
     * @param elements An iterable of embeds elements
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder addAllEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
      for (EmbedCreateSpec element : elements) {
        this.embeds.add(Objects.requireNonNull(element, "embeds element"));
      }
      optBits |= OPT_BIT_EMBEDS;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(Possible<AllowedMentions> value) {
      this.allowedMentions_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder allowedMentions(AllowedMentions value) {
      this.allowedMentions_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addComponent(LayoutComponent element) {
      components_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllComponents(List<LayoutComponent> elements) {
      components_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(Possible<List<LayoutComponent>> elements) {
      this.components_list = null;
      elements.toOptional().ifPresent(e -> components_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(List<LayoutComponent> elements) {
      this.components_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder components(java.lang.Iterable<LayoutComponent> elements) {
      this.components_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    /**
     * Builds a new {@link WebhookExecuteSpec WebhookExecuteSpec}.
     * @return An immutable instance of WebhookExecuteSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WebhookExecuteSpec build() {
      return WebhookExecuteSpec.validate(new WebhookExecuteSpec(this));
    }

    private boolean ttsIsSet() {
      return (optBits & OPT_BIT_TTS) != 0;
    }

    private boolean filesIsSet() {
      return (optBits & OPT_BIT_FILES) != 0;
    }

    private boolean fileSpoilersIsSet() {
      return (optBits & OPT_BIT_FILE_SPOILERS) != 0;
    }

    private boolean embedsIsSet() {
      return (optBits & OPT_BIT_EMBEDS) != 0;
    }

    private Possible<String> content_build() {
      return this.content_possible;
    }

    private Possible<String> username_build() {
      return this.username_possible;
    }

    private Possible<String> avatarUrl_build() {
      return this.avatarUrl_possible;
    }

    private Possible<AllowedMentions> allowedMentions_build() {
      return this.allowedMentions_possible;
    }

    private Possible<List<LayoutComponent>> components_build() {
      return this.components_list == null ? Possible.absent() :
          Possible.of(this.components_list);
    }

    private List<LayoutComponent> components_getOrCreate() {
      if (this.components_list == null) {
        this.components_list = new ArrayList<>();
      }
      return this.components_list;
    }
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
