package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.component.LayoutComponent;
import discord4j.core.object.entity.Webhook;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.AllowedMentions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link WebhookExecuteMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code WebhookExecuteMono.of()}.
 */
@Generated(from = "WebhookExecuteMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookExecuteMono extends WebhookExecuteMonoGenerator {
  private final String content_value;
  private final boolean content_absent;
  private final String username_value;
  private final boolean username_absent;
  private final String avatarUrl_value;
  private final boolean avatarUrl_absent;
  private final boolean tts;
  private final List<MessageCreateFields.File> files;
  private final List<MessageCreateFields.FileSpoiler> fileSpoilers;
  private final List<EmbedCreateSpec> embeds;
  private final AllowedMentions allowedMentions_value;
  private final boolean allowedMentions_absent;
  private final List<LayoutComponent> components_value;
  private final boolean components_absent;
  private final boolean waitForMessage;
  private final Webhook webhook;

  private WebhookExecuteMono(boolean waitForMessage, Webhook webhook) {
    this.waitForMessage = waitForMessage;
    this.webhook = Objects.requireNonNull(webhook, "webhook");
    Possible<String> content$impl = Possible.absent();
    Possible<String> username$impl = Possible.absent();
    Possible<String> avatarUrl$impl = Possible.absent();
    Possible<AllowedMentions> allowedMentions$impl = Possible.absent();
    Possible<List<LayoutComponent>> components$impl = Possible.absent();
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
    this.avatarUrl_absent = avatarUrl$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.tts = initShim.tts();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private WebhookExecuteMono(
      Possible<String> content,
      Possible<String> username,
      Possible<String> avatarUrl,
      boolean tts,
      List<MessageCreateFields.File> files,
      List<MessageCreateFields.FileSpoiler> fileSpoilers,
      List<EmbedCreateSpec> embeds,
      Possible<AllowedMentions> allowedMentions,
      Possible<List<LayoutComponent>> components,
      boolean waitForMessage,
      Webhook webhook) {
    Possible<String> content$impl = content;
    Possible<String> username$impl = username;
    Possible<String> avatarUrl$impl = avatarUrl;
    initShim.tts(tts);
    initShim.files(files);
    initShim.fileSpoilers(fileSpoilers);
    initShim.embeds(embeds);
    Possible<AllowedMentions> allowedMentions$impl = allowedMentions;
    Possible<List<LayoutComponent>> components$impl = components;
    this.waitForMessage = waitForMessage;
    this.webhook = webhook;
    this.content_value = content$impl.toOptional().orElse(null);
    this.content_absent = content$impl.isAbsent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatarUrl_value = avatarUrl$impl.toOptional().orElse(null);
    this.avatarUrl_absent = avatarUrl$impl.isAbsent();
    this.allowedMentions_value = allowedMentions$impl.toOptional().orElse(null);
    this.allowedMentions_absent = allowedMentions$impl.isAbsent();
    this.components_value = components$impl.toOptional().orElse(null);
    this.components_absent = components$impl.isAbsent();
    this.tts = initShim.tts();
    this.files = initShim.files();
    this.fileSpoilers = initShim.fileSpoilers();
    this.embeds = initShim.embeds();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookExecuteMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte ttsBuildStage = STAGE_UNINITIALIZED;
    private boolean tts;

    boolean tts() {
      if (ttsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ttsBuildStage == STAGE_UNINITIALIZED) {
        ttsBuildStage = STAGE_INITIALIZING;
        this.tts = WebhookExecuteMono.super.tts();
        ttsBuildStage = STAGE_INITIALIZED;
      }
      return this.tts;
    }

    void tts(boolean tts) {
      this.tts = tts;
      ttsBuildStage = STAGE_INITIALIZED;
    }

    private byte filesBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.File> files;

    List<MessageCreateFields.File> files() {
      if (filesBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (filesBuildStage == STAGE_UNINITIALIZED) {
        filesBuildStage = STAGE_INITIALIZING;
        this.files = createUnmodifiableList(false, createSafeList(WebhookExecuteMono.super.files(), true, false));
        filesBuildStage = STAGE_INITIALIZED;
      }
      return this.files;
    }

    void files(List<MessageCreateFields.File> files) {
      this.files = files;
      filesBuildStage = STAGE_INITIALIZED;
    }

    private byte fileSpoilersBuildStage = STAGE_UNINITIALIZED;
    private List<MessageCreateFields.FileSpoiler> fileSpoilers;

    List<MessageCreateFields.FileSpoiler> fileSpoilers() {
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (fileSpoilersBuildStage == STAGE_UNINITIALIZED) {
        fileSpoilersBuildStage = STAGE_INITIALIZING;
        this.fileSpoilers = createUnmodifiableList(false, createSafeList(WebhookExecuteMono.super.fileSpoilers(), true, false));
        fileSpoilersBuildStage = STAGE_INITIALIZED;
      }
      return this.fileSpoilers;
    }

    void fileSpoilers(List<MessageCreateFields.FileSpoiler> fileSpoilers) {
      this.fileSpoilers = fileSpoilers;
      fileSpoilersBuildStage = STAGE_INITIALIZED;
    }

    private byte embedsBuildStage = STAGE_UNINITIALIZED;
    private List<EmbedCreateSpec> embeds;

    List<EmbedCreateSpec> embeds() {
      if (embedsBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (embedsBuildStage == STAGE_UNINITIALIZED) {
        embedsBuildStage = STAGE_INITIALIZING;
        this.embeds = createUnmodifiableList(false, createSafeList(WebhookExecuteMono.super.embeds(), true, false));
        embedsBuildStage = STAGE_INITIALIZED;
      }
      return this.embeds;
    }

    void embeds(List<EmbedCreateSpec> embeds) {
      this.embeds = embeds;
      embedsBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (ttsBuildStage == STAGE_INITIALIZING) attributes.add("tts");
      if (filesBuildStage == STAGE_INITIALIZING) attributes.add("files");
      if (fileSpoilersBuildStage == STAGE_INITIALIZING) attributes.add("fileSpoilers");
      if (embedsBuildStage == STAGE_INITIALIZING) attributes.add("embeds");
      return "Cannot build WebhookExecuteMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code content} attribute
   */
  @Override
  public Possible<String> content() {
    return content_absent ? Possible.absent() : Possible.of(content_value);
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public Possible<String> username() {
    return username_absent ? Possible.absent() : Possible.of(username_value);
  }

  /**
   * @return The value of the {@code avatarUrl} attribute
   */
  @Override
  public Possible<String> avatarUrl() {
    return avatarUrl_absent ? Possible.absent() : Possible.of(avatarUrl_value);
  }

  /**
   * @return The value of the {@code tts} attribute
   */
  @Override
  public boolean tts() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.tts()
        : this.tts;
  }

  /**
   * @return The value of the {@code files} attribute
   */
  @Override
  public List<MessageCreateFields.File> files() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.files()
        : this.files;
  }

  /**
   * @return The value of the {@code fileSpoilers} attribute
   */
  @Override
  public List<MessageCreateFields.FileSpoiler> fileSpoilers() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.fileSpoilers()
        : this.fileSpoilers;
  }

  /**
   * @return The value of the {@code embeds} attribute
   */
  @Override
  public List<EmbedCreateSpec> embeds() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.embeds()
        : this.embeds;
  }

  /**
   * @return The value of the {@code allowedMentions} attribute
   */
  @Override
  public Possible<AllowedMentions> allowedMentions() {
    return allowedMentions_absent ? Possible.absent() : Possible.of(allowedMentions_value);
  }

  /**
   * @return The value of the {@code components} attribute
   */
  @Override
  public Possible<List<LayoutComponent>> components() {
    return components_absent ? Possible.absent() :
        Possible.of(components_value);
  }

  /**
   * @return The value of the {@code waitForMessage} attribute
   */
  @Override
  public boolean waitForMessage() {
    return waitForMessage;
  }

  /**
   * @return The value of the {@code webhook} attribute
   */
  @Override
  public Webhook webhook() {
    return webhook;
  }

  public WebhookExecuteMono withContent(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new WebhookExecuteMono(
        newValue,
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withContent(String value) {
    Possible<String> newValue = Possible.of(value);
    return new WebhookExecuteMono(
        newValue,
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withUsername(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new WebhookExecuteMono(
        this.content(),
        newValue,
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withUsername(String value) {
    Possible<String> newValue = Possible.of(value);
    return new WebhookExecuteMono(
        this.content(),
        newValue,
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withAvatarUrl(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        newValue,
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withAvatarUrl(String value) {
    Possible<String> newValue = Possible.of(value);
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        newValue,
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookExecuteMono#tts() tts} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for tts
   * @return A modified copy of the {@code this} object
   */
  public final WebhookExecuteMono withTts(boolean value) {
    if (this.tts == value) return this;
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        value,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteMono#files() files}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteMono withFiles(MessageCreateFields.File... elements) {
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteMono#files() files}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of files elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteMono withFiles(Iterable<? extends MessageCreateFields.File> elements) {
    if (this.files == elements) return this;
    List<MessageCreateFields.File> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        newValue,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteMono#fileSpoilers() fileSpoilers}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteMono withFileSpoilers(MessageCreateFields.FileSpoiler... elements) {
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        newValue,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteMono#fileSpoilers() fileSpoilers}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of fileSpoilers elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteMono withFileSpoilers(Iterable<? extends MessageCreateFields.FileSpoiler> elements) {
    if (this.fileSpoilers == elements) return this;
    List<MessageCreateFields.FileSpoiler> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        newValue,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteMono#embeds() embeds}.
   * @param elements The elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteMono withEmbeds(EmbedCreateSpec... elements) {
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(Arrays.asList(elements), true, false));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object with elements that replace the content of {@link WebhookExecuteMono#embeds() embeds}.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param elements An iterable of embeds elements to set
   * @return A modified copy of {@code this} object
   */
  public final WebhookExecuteMono withEmbeds(Iterable<? extends EmbedCreateSpec> elements) {
    if (this.embeds == elements) return this;
    List<EmbedCreateSpec> newValue = createUnmodifiableList(false, createSafeList(elements, true, false));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        newValue,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withAllowedMentions(Possible<AllowedMentions> value) {
    Possible<AllowedMentions> newValue = Objects.requireNonNull(value);
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withAllowedMentions(AllowedMentions value) {
    Possible<AllowedMentions> newValue = Possible.of(value);
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        newValue,
        this.components(),
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withComponents(Possible<List<LayoutComponent>> possible) {
    Possible<List<LayoutComponent>> newValue = Objects.requireNonNull(possible);
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue,
        this.waitForMessage,
        this.webhook);
  }

  public WebhookExecuteMono withComponents(java.lang.Iterable<LayoutComponent> elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue,
        this.waitForMessage,
        this.webhook);
  }

  @SafeVarargs
  public final WebhookExecuteMono withComponents(LayoutComponent... elements) {
    Possible<List<LayoutComponent>> newValue = Possible.of(Arrays.asList(elements));
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        newValue,
        this.waitForMessage,
        this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookExecuteMono#waitForMessage() waitForMessage} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for waitForMessage
   * @return A modified copy of the {@code this} object
   */
  public final WebhookExecuteMono withWaitForMessage(boolean value) {
    if (this.waitForMessage == value) return this;
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        value,
        this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookExecuteMono#webhook() webhook} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for webhook
   * @return A modified copy of the {@code this} object
   */
  public final WebhookExecuteMono withWebhook(Webhook value) {
    if (this.webhook == value) return this;
    Webhook newValue = Objects.requireNonNull(value, "webhook");
    return new WebhookExecuteMono(
        this.content(),
        this.username(),
        this.avatarUrl(),
        this.tts,
        this.files,
        this.fileSpoilers,
        this.embeds,
        this.allowedMentions(),
        this.components(),
        this.waitForMessage,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code WebhookExecuteMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookExecuteMono
        && equalTo(0, (WebhookExecuteMono) another);
  }

  private boolean equalTo(int synthetic, WebhookExecuteMono another) {
    return this.content().equals(another.content())
        && this.username().equals(another.username())
        && this.avatarUrl().equals(another.avatarUrl())
        && tts == another.tts
        && files.equals(another.files)
        && fileSpoilers.equals(another.fileSpoilers)
        && embeds.equals(another.embeds)
        && this.allowedMentions().equals(another.allowedMentions())
        && Objects.equals(components_value, another.components_value)
        && waitForMessage == another.waitForMessage
        && webhook.equals(another.webhook);
  }

  /**
   * Computes a hash code from attributes: {@code content}, {@code username}, {@code avatarUrl}, {@code tts}, {@code files}, {@code fileSpoilers}, {@code embeds}, {@code allowedMentions}, {@code components}, {@code waitForMessage}, {@code webhook}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (content().hashCode());
    h += (h << 5) + (username().hashCode());
    h += (h << 5) + (avatarUrl().hashCode());
    h += (h << 5) + Boolean.hashCode(tts);
    h += (h << 5) + files.hashCode();
    h += (h << 5) + fileSpoilers.hashCode();
    h += (h << 5) + embeds.hashCode();
    h += (h << 5) + (allowedMentions().hashCode());
    h += (h << 5) + (Objects.hashCode(components_value));
    h += (h << 5) + Boolean.hashCode(waitForMessage);
    h += (h << 5) + webhook.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookExecuteMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookExecuteMono{"
        + "content=" + (content().toString())
        + ", username=" + (username().toString())
        + ", avatarUrl=" + (avatarUrl().toString())
        + ", tts=" + tts
        + ", files=" + files
        + ", fileSpoilers=" + fileSpoilers
        + ", embeds=" + embeds
        + ", allowedMentions=" + (allowedMentions().toString())
        + ", components=" + (Objects.toString(components_value))
        + ", waitForMessage=" + waitForMessage
        + ", webhook=" + webhook
        + "}";
  }

  /**
   * Construct a new immutable {@code WebhookExecuteMono} instance.
   * @param waitForMessage The value for the {@code waitForMessage} attribute
   * @param webhook The value for the {@code webhook} attribute
   * @return An immutable WebhookExecuteMono instance
   */
  public static WebhookExecuteMono of(boolean waitForMessage, Webhook webhook) {
    return new WebhookExecuteMono(waitForMessage, webhook);
  }

  /**
   * Creates an immutable copy of a {@link WebhookExecuteMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookExecuteMono instance
   */
  static WebhookExecuteMono copyOf(WebhookExecuteMonoGenerator instance) {
    if (instance instanceof WebhookExecuteMono) {
      return (WebhookExecuteMono) instance;
    }
    return WebhookExecuteMono.of(instance.waitForMessage(), instance.webhook())
        .withContent(instance.content())
        .withUsername(instance.username())
        .withAvatarUrl(instance.avatarUrl())
        .withTts(instance.tts())
        .withFiles(instance.files())
        .withFileSpoilers(instance.fileSpoilers())
        .withEmbeds(instance.embeds())
        .withAllowedMentions(instance.allowedMentions())
        .withComponents(instance.components());
  }

  public boolean isContentPresent() {
    return !content_absent;
  }

  public String contentOrElse(String defaultValue) {
    return !content_absent ? content_value : defaultValue;
  }

  public boolean isUsernamePresent() {
    return !username_absent;
  }

  public String usernameOrElse(String defaultValue) {
    return !username_absent ? username_value : defaultValue;
  }

  public boolean isAvatarUrlPresent() {
    return !avatarUrl_absent;
  }

  public String avatarUrlOrElse(String defaultValue) {
    return !avatarUrl_absent ? avatarUrl_value : defaultValue;
  }

  public boolean isAllowedMentionsPresent() {
    return !allowedMentions_absent;
  }

  public AllowedMentions allowedMentionsOrElse(AllowedMentions defaultValue) {
    return !allowedMentions_absent ? allowedMentions_value : defaultValue;
  }

  public boolean isComponentsPresent() {
    return !components_absent;
  }

  public List<LayoutComponent> componentsOrElse(List<LayoutComponent> defaultValue) {
    return !components_absent ? components_value : defaultValue;
  }

  private static <T> List<T> createSafeList(Iterable<? extends T> iterable, boolean checkNulls, boolean skipNulls) {
    ArrayList<T> list;
    if (iterable instanceof Collection<?>) {
      int size = ((Collection<?>) iterable).size();
      if (size == 0) return Collections.emptyList();
      list = new ArrayList<>();
    } else {
      list = new ArrayList<>();
    }
    for (T element : iterable) {
      if (skipNulls && element == null) continue;
      if (checkNulls) Objects.requireNonNull(element, "element");
      list.add(element);
    }
    return list;
  }

  private static <T> List<T> createUnmodifiableList(boolean clone, List<T> list) {
    switch(list.size()) {
    case 0: return Collections.emptyList();
    case 1: return Collections.singletonList(list.get(0));
    default:
      if (clone) {
        return Collections.unmodifiableList(new ArrayList<>(list));
      } else {
        if (list instanceof ArrayList<?>) {
          ((ArrayList<?>) list).trimToSize();
        }
        return Collections.unmodifiableList(list);
      }
    }
  }
}
