package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.Webhook;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookEditWithTokenMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code WebhookEditWithTokenMono.of()}.
 */
@Generated(from = "WebhookEditWithTokenMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookEditWithTokenMono extends WebhookEditWithTokenMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Image avatar_value;
  private final boolean avatar_absent;
  private final Webhook webhook;

  private WebhookEditWithTokenMono(Webhook webhook) {
    this.webhook = Objects.requireNonNull(webhook, "webhook");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Image> avatar$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private WebhookEditWithTokenMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<Image> avatar,
      Webhook webhook) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Image> avatar$impl = avatar;
    this.webhook = webhook;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookEditWithTokenMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build WebhookEditWithTokenMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Image> avatar() {
    return avatar_absent ? Possible.absent() : Possible.of(avatar_value);
  }

  /**
   * @return The value of the {@code webhook} attribute
   */
  @Override
  public Webhook webhook() {
    return webhook;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookEditWithTokenMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WebhookEditWithTokenMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new WebhookEditWithTokenMono(value, this.name(), this.avatar(), this.webhook);
  }

  public WebhookEditWithTokenMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new WebhookEditWithTokenMono(this.reason, newValue, this.avatar(), this.webhook);
  }

  public WebhookEditWithTokenMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new WebhookEditWithTokenMono(this.reason, newValue, this.avatar(), this.webhook);
  }

  public WebhookEditWithTokenMono withAvatar(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return new WebhookEditWithTokenMono(this.reason, this.name(), newValue, this.webhook);
  }

  public WebhookEditWithTokenMono withAvatar(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return new WebhookEditWithTokenMono(this.reason, this.name(), newValue, this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookEditWithTokenMono#webhook() webhook} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for webhook
   * @return A modified copy of the {@code this} object
   */
  public final WebhookEditWithTokenMono withWebhook(Webhook value) {
    if (this.webhook == value) return this;
    Webhook newValue = Objects.requireNonNull(value, "webhook");
    return new WebhookEditWithTokenMono(this.reason, this.name(), this.avatar(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code WebhookEditWithTokenMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookEditWithTokenMono
        && equalTo(0, (WebhookEditWithTokenMono) another);
  }

  private boolean equalTo(int synthetic, WebhookEditWithTokenMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.avatar().equals(another.avatar())
        && webhook.equals(another.webhook);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code avatar}, {@code webhook}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (avatar().hashCode());
    h += (h << 5) + webhook.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookEditWithTokenMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookEditWithTokenMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", avatar=" + (avatar().toString())
        + ", webhook=" + webhook
        + "}";
  }

  /**
   * Construct a new immutable {@code WebhookEditWithTokenMono} instance.
   * @param webhook The value for the {@code webhook} attribute
   * @return An immutable WebhookEditWithTokenMono instance
   */
  public static WebhookEditWithTokenMono of(Webhook webhook) {
    return new WebhookEditWithTokenMono(webhook);
  }

  /**
   * Creates an immutable copy of a {@link WebhookEditWithTokenMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookEditWithTokenMono instance
   */
  static WebhookEditWithTokenMono copyOf(WebhookEditWithTokenMonoGenerator instance) {
    if (instance instanceof WebhookEditWithTokenMono) {
      return (WebhookEditWithTokenMono) instance;
    }
    return WebhookEditWithTokenMono.of(instance.webhook())
        .withReason(instance.reason())
        .withName(instance.name())
        .withAvatar(instance.avatar());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }
}
