package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code WebhookEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code WebhookEditSpec.create()}.
 */
@Generated(from = "WebhookEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookEditSpec implements WebhookEditSpecGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Image avatar_value;
  private final boolean avatar_absent;
  private final Snowflake channelId_value;
  private final boolean channelId_absent;

  private WebhookEditSpec() {
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Image> avatar$impl = Possible.absent();
    Possible<Snowflake> channelId$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.channelId_value = channelId$impl.toOptional().orElse(null);
    this.channelId_absent = channelId$impl.isAbsent();
    this.initShim = null;
  }

  private WebhookEditSpec(
      @Nullable String reason,
      Possible<String> name,
      Possible<Image> avatar,
      Possible<Snowflake> channelId) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Image> avatar$impl = avatar;
    Possible<Snowflake> channelId$impl = channelId;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.channelId_value = channelId$impl.toOptional().orElse(null);
    this.channelId_absent = channelId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build WebhookEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Image> avatar() {
    return avatar_absent ? Possible.absent() : Possible.of(avatar_value);
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @Override
  public Possible<Snowflake> channelId() {
    return channelId_absent ? Possible.absent() : Possible.of(channelId_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookEditSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WebhookEditSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new WebhookEditSpec(value, this.name(), this.avatar(), this.channelId()));
  }

  public WebhookEditSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new WebhookEditSpec(this.reason, newValue, this.avatar(), this.channelId()));
  }

  public WebhookEditSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new WebhookEditSpec(this.reason, newValue, this.avatar(), this.channelId()));
  }

  public WebhookEditSpec withAvatar(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return validate(new WebhookEditSpec(this.reason, this.name(), newValue, this.channelId()));
  }

  public WebhookEditSpec withAvatar(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return validate(new WebhookEditSpec(this.reason, this.name(), newValue, this.channelId()));
  }

  public WebhookEditSpec withChannelId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return validate(new WebhookEditSpec(this.reason, this.name(), this.avatar(), newValue));
  }

  public WebhookEditSpec withChannelId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return validate(new WebhookEditSpec(this.reason, this.name(), this.avatar(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code WebhookEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookEditSpec
        && equalTo(0, (WebhookEditSpec) another);
  }

  private boolean equalTo(int synthetic, WebhookEditSpec another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.avatar().equals(another.avatar())
        && this.channelId().equals(another.channelId());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code avatar}, {@code channelId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (avatar().hashCode());
    h += (h << 5) + (channelId().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookEditSpec{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", avatar=" + (avatar().toString())
        + ", channelId=" + (channelId().toString())
        + "}";
  }

  private static final WebhookEditSpec INSTANCE = validate(new WebhookEditSpec());

  /**
   * Returns the default immutable singleton value of {@code WebhookEditSpec}
   * @return An immutable instance of WebhookEditSpec
   */
  public static WebhookEditSpec create() {
    return INSTANCE;
  }

  private static WebhookEditSpec validate(WebhookEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link WebhookEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookEditSpec instance
   */
  static WebhookEditSpec copyOf(WebhookEditSpecGenerator instance) {
    if (instance instanceof WebhookEditSpec) {
      return (WebhookEditSpec) instance;
    }
    return WebhookEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }

  public boolean isChannelIdPresent() {
    return !channelId_absent;
  }

  public Snowflake channelIdOrElse(Snowflake defaultValue) {
    return !channelId_absent ? channelId_value : defaultValue;
  }

  /**
   * Creates a builder for {@link WebhookEditSpec WebhookEditSpec}.
   * <pre>
   * WebhookEditSpec.builder()
   *    .reason(String | null) // nullable {@link WebhookEditSpec#reason() reason}
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link WebhookEditSpec#name() name}
   *    .avatar(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.Image&amp;gt;) // {@link WebhookEditSpec#avatar() avatar}
   *    .channelId(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link WebhookEditSpec#channelId() channelId}
   *    .build();
   * </pre>
   * @return A new WebhookEditSpec builder
   */
  public static WebhookEditSpec.Builder builder() {
    return new WebhookEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link WebhookEditSpec WebhookEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebhookEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private Possible<Image> avatar_possible = Possible.absent();
    private Possible<Snowflake> channelId_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebhookEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(WebhookEditSpec instance) {
      return from((WebhookEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code WebhookEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(WebhookEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      avatar(instance.avatar());
      channelId(instance.channelId());
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookEditSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatar(Possible<Image> value) {
      this.avatar_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatar(Image value) {
      this.avatar_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder channelId(Possible<Snowflake> value) {
      this.channelId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder channelId(Snowflake value) {
      this.channelId_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link WebhookEditSpec WebhookEditSpec}.
     * @return An immutable instance of WebhookEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WebhookEditSpec build() {
      return WebhookEditSpec.validate(new WebhookEditSpec(reason, name_build(), avatar_build(), channelId_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<Image> avatar_build() {
      return this.avatar_possible;
    }

    private Possible<Snowflake> channelId_build() {
      return this.channelId_possible;
    }
  }
}
