package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.entity.Webhook;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code WebhookEditMono.of()}.
 */
@Generated(from = "WebhookEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookEditMono extends WebhookEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Image avatar_value;
  private final boolean avatar_absent;
  private final Snowflake channelId_value;
  private final boolean channelId_absent;
  private final Webhook webhook;

  private WebhookEditMono(Webhook webhook) {
    this.webhook = Objects.requireNonNull(webhook, "webhook");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Image> avatar$impl = Possible.absent();
    Possible<Snowflake> channelId$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.channelId_value = channelId$impl.toOptional().orElse(null);
    this.channelId_absent = channelId$impl.isAbsent();
    this.initShim = null;
  }

  private WebhookEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<Image> avatar,
      Possible<Snowflake> channelId,
      Webhook webhook) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Image> avatar$impl = avatar;
    Possible<Snowflake> channelId$impl = channelId;
    this.webhook = webhook;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.channelId_value = channelId$impl.toOptional().orElse(null);
    this.channelId_absent = channelId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build WebhookEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Image> avatar() {
    return avatar_absent ? Possible.absent() : Possible.of(avatar_value);
  }

  /**
   * @return The value of the {@code channelId} attribute
   */
  @Override
  public Possible<Snowflake> channelId() {
    return channelId_absent ? Possible.absent() : Possible.of(channelId_value);
  }

  /**
   * @return The value of the {@code webhook} attribute
   */
  @Override
  public Webhook webhook() {
    return webhook;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WebhookEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new WebhookEditMono(value, this.name(), this.avatar(), this.channelId(), this.webhook);
  }

  public WebhookEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new WebhookEditMono(this.reason, newValue, this.avatar(), this.channelId(), this.webhook);
  }

  public WebhookEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new WebhookEditMono(this.reason, newValue, this.avatar(), this.channelId(), this.webhook);
  }

  public WebhookEditMono withAvatar(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return new WebhookEditMono(this.reason, this.name(), newValue, this.channelId(), this.webhook);
  }

  public WebhookEditMono withAvatar(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return new WebhookEditMono(this.reason, this.name(), newValue, this.channelId(), this.webhook);
  }

  public WebhookEditMono withChannelId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new WebhookEditMono(this.reason, this.name(), this.avatar(), newValue, this.webhook);
  }

  public WebhookEditMono withChannelId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new WebhookEditMono(this.reason, this.name(), this.avatar(), newValue, this.webhook);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookEditMono#webhook() webhook} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for webhook
   * @return A modified copy of the {@code this} object
   */
  public final WebhookEditMono withWebhook(Webhook value) {
    if (this.webhook == value) return this;
    Webhook newValue = Objects.requireNonNull(value, "webhook");
    return new WebhookEditMono(this.reason, this.name(), this.avatar(), this.channelId(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code WebhookEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookEditMono
        && equalTo(0, (WebhookEditMono) another);
  }

  private boolean equalTo(int synthetic, WebhookEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.avatar().equals(another.avatar())
        && this.channelId().equals(another.channelId())
        && webhook.equals(another.webhook);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code avatar}, {@code channelId}, {@code webhook}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (avatar().hashCode());
    h += (h << 5) + (channelId().hashCode());
    h += (h << 5) + webhook.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", avatar=" + (avatar().toString())
        + ", channelId=" + (channelId().toString())
        + ", webhook=" + webhook
        + "}";
  }

  /**
   * Construct a new immutable {@code WebhookEditMono} instance.
   * @param webhook The value for the {@code webhook} attribute
   * @return An immutable WebhookEditMono instance
   */
  public static WebhookEditMono of(Webhook webhook) {
    return new WebhookEditMono(webhook);
  }

  /**
   * Creates an immutable copy of a {@link WebhookEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookEditMono instance
   */
  static WebhookEditMono copyOf(WebhookEditMonoGenerator instance) {
    if (instance instanceof WebhookEditMono) {
      return (WebhookEditMono) instance;
    }
    return WebhookEditMono.of(instance.webhook())
        .withReason(instance.reason())
        .withName(instance.name())
        .withAvatar(instance.avatar())
        .withChannelId(instance.channelId());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }

  public boolean isChannelIdPresent() {
    return !channelId_absent;
  }

  public Snowflake channelIdOrElse(Snowflake defaultValue) {
    return !channelId_absent ? channelId_value : defaultValue;
  }
}
