package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code WebhookCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code WebhookCreateSpec.of()}.
 */
@Generated(from = "WebhookCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookCreateSpec implements WebhookCreateSpecGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Image avatar_value;
  private final boolean avatar_absent;

  private WebhookCreateSpec(String name) {
    this.name = Objects.requireNonNull(name, "name");
    this.reason = null;
    Possible<Optional<Image>> avatar$impl = Possible.absent();
    this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private WebhookCreateSpec(
      @Nullable String reason,
      String name,
      Possible<Optional<Image>> avatar) {
    this.reason = reason;
    this.name = name;
    Possible<Optional<Image>> avatar$impl = avatar;
    this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build WebhookCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Optional<Image>> avatar() {
    return avatar_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(avatar_value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WebhookCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new WebhookCreateSpec(value, this.name, this.avatar());
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final WebhookCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new WebhookCreateSpec(this.reason, newValue, this.avatar());
  }

  public WebhookCreateSpec withAvatar(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return new WebhookCreateSpec(this.reason, this.name, newValue);
  }

  @Deprecated
  public WebhookCreateSpec withAvatar(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookCreateSpec(this.reason, this.name, newValue);
  }

  public WebhookCreateSpec withAvatarOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookCreateSpec(this.reason, this.name, newValue);
  }

  /**
   * This instance is equal to all instances of {@code WebhookCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookCreateSpec
        && equalTo(0, (WebhookCreateSpec) another);
  }

  private boolean equalTo(int synthetic, WebhookCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.avatar().equals(another.avatar());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code avatar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (avatar().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookCreateSpec{"
        + "reason=" + reason
        + ", name=" + name
        + ", avatar=" + (avatar().toString())
        + "}";
  }

  /**
   * Construct a new immutable {@code WebhookCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable WebhookCreateSpec instance
   */
  public static WebhookCreateSpec of(String name) {
    return new WebhookCreateSpec(name);
  }

  /**
   * Creates an immutable copy of a {@link WebhookCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookCreateSpec instance
   */
  static WebhookCreateSpec copyOf(WebhookCreateSpecGenerator instance) {
    if (instance instanceof WebhookCreateSpec) {
      return (WebhookCreateSpec) instance;
    }
    return WebhookCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }

  /**
   * Creates a builder for {@link WebhookCreateSpec WebhookCreateSpec}.
   * <pre>
   * WebhookCreateSpec.builder()
   *    .reason(String | null) // nullable {@link WebhookCreateSpec#reason() reason}
   *    .name(String) // required {@link WebhookCreateSpec#name() name}
   *    .avatar(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.rest.util.Image&amp;gt;&amp;gt;) // {@link WebhookCreateSpec#avatar() avatar}
   *    .build();
   * </pre>
   * @return A new WebhookCreateSpec builder
   */
  public static WebhookCreateSpec.Builder builder() {
    return new WebhookCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link WebhookCreateSpec WebhookCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "WebhookCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Possible<Optional<Image>> avatar_possible = Possible.absent();
    private String reason;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code WebhookCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(WebhookCreateSpec instance) {
      return from((WebhookCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code WebhookCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(WebhookCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      avatar(instance.avatar());
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link WebhookCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatar(Possible<Optional<Image>> value) {
      this.avatar_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder avatar(@Nullable Image value) {
      this.avatar_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatarOrNull(@Nullable Image value) {
      this.avatar_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link WebhookCreateSpec WebhookCreateSpec}.
     * @return An immutable instance of WebhookCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public WebhookCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new WebhookCreateSpec(reason, name, avatar_build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build WebhookCreateSpec, some of required attributes are not set " + attributes;
    }

    private Possible<Optional<Image>> avatar_build() {
      return this.avatar_possible;
    }
  }
}
