package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.channel.GuildMessageChannel;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link WebhookCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code WebhookCreateMono.of()}.
 */
@Generated(from = "WebhookCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class WebhookCreateMono extends WebhookCreateMonoGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Image avatar_value;
  private final boolean avatar_absent;
  private final GuildMessageChannel channel;

  private WebhookCreateMono(String name, GuildMessageChannel channel) {
    this.name = Objects.requireNonNull(name, "name");
    this.channel = Objects.requireNonNull(channel, "channel");
    this.reason = null;
    Possible<Optional<Image>> avatar$impl = Possible.absent();
    this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private WebhookCreateMono(
      @Nullable String reason,
      String name,
      Possible<Optional<Image>> avatar,
      GuildMessageChannel channel) {
    this.reason = reason;
    this.name = name;
    Possible<Optional<Image>> avatar$impl = avatar;
    this.channel = channel;
    this.avatar_value = Possible.flatOpt(avatar$impl).orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "WebhookCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build WebhookCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Optional<Image>> avatar() {
    return avatar_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(avatar_value));
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @Override
  public GuildMessageChannel channel() {
    return channel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final WebhookCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new WebhookCreateMono(value, this.name, this.avatar(), this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final WebhookCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new WebhookCreateMono(this.reason, newValue, this.avatar(), this.channel);
  }

  public WebhookCreateMono withAvatar(Possible<Optional<Image>> value) {
    Possible<Optional<Image>> newValue = Objects.requireNonNull(value);
    return new WebhookCreateMono(this.reason, this.name, newValue, this.channel);
  }

  @Deprecated
  public WebhookCreateMono withAvatar(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookCreateMono(this.reason, this.name, newValue, this.channel);
  }

  public WebhookCreateMono withAvatarOrNull(@Nullable Image value) {
    Possible<Optional<Image>> newValue = Possible.of(Optional.ofNullable(value));
    return new WebhookCreateMono(this.reason, this.name, newValue, this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link WebhookCreateMono#channel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final WebhookCreateMono withChannel(GuildMessageChannel value) {
    if (this.channel == value) return this;
    GuildMessageChannel newValue = Objects.requireNonNull(value, "channel");
    return new WebhookCreateMono(this.reason, this.name, this.avatar(), newValue);
  }

  /**
   * This instance is equal to all instances of {@code WebhookCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof WebhookCreateMono
        && equalTo(0, (WebhookCreateMono) another);
  }

  private boolean equalTo(int synthetic, WebhookCreateMono another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.avatar().equals(another.avatar())
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code avatar}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (avatar().hashCode());
    h += (h << 5) + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code WebhookCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "WebhookCreateMono{"
        + "reason=" + reason
        + ", name=" + name
        + ", avatar=" + (avatar().toString())
        + ", channel=" + channel
        + "}";
  }

  /**
   * Construct a new immutable {@code WebhookCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param channel The value for the {@code channel} attribute
   * @return An immutable WebhookCreateMono instance
   */
  public static WebhookCreateMono of(String name, GuildMessageChannel channel) {
    return new WebhookCreateMono(name, channel);
  }

  /**
   * Creates an immutable copy of a {@link WebhookCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable WebhookCreateMono instance
   */
  static WebhookCreateMono copyOf(WebhookCreateMonoGenerator instance) {
    if (instance instanceof WebhookCreateMono) {
      return (WebhookCreateMono) instance;
    }
    return WebhookCreateMono.of(instance.name(), instance.channel())
        .withReason(instance.reason())
        .withAvatar(instance.avatar());
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }
}
