package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.voice.AudioProvider;
import discord4j.voice.AudioReceiver;
import discord4j.voice.VoiceReceiveTaskFactory;
import discord4j.voice.VoiceSendTaskFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.retry.RetrySpec;

/**
 * Immutable implementation of {@link VoiceChannelJoinSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code VoiceChannelJoinSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code VoiceChannelJoinSpec.create()}.
 */
@Generated(from = "VoiceChannelJoinSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class VoiceChannelJoinSpec implements VoiceChannelJoinSpecGenerator {
  private final Duration timeout;
  private final AudioProvider provider;
  private final AudioReceiver receiver;
  private final VoiceSendTaskFactory sendTaskFactory;
  private final VoiceReceiveTaskFactory receiveTaskFactory;
  private final boolean selfDeaf;
  private final boolean selfMute;
  private final Duration ipDiscoveryTimeout;
  private final RetrySpec ipDiscoveryRetrySpec;

  private VoiceChannelJoinSpec() {
    this.timeout = initShim.timeout();
    this.provider = initShim.provider();
    this.receiver = initShim.receiver();
    this.sendTaskFactory = initShim.sendTaskFactory();
    this.receiveTaskFactory = initShim.receiveTaskFactory();
    this.selfDeaf = initShim.selfDeaf();
    this.selfMute = initShim.selfMute();
    this.ipDiscoveryTimeout = initShim.ipDiscoveryTimeout();
    this.ipDiscoveryRetrySpec = initShim.ipDiscoveryRetrySpec();
    this.initShim = null;
  }

  private VoiceChannelJoinSpec(VoiceChannelJoinSpec.Builder builder) {
    if (builder.timeout != null) {
      initShim.timeout(builder.timeout);
    }
    if (builder.provider != null) {
      initShim.provider(builder.provider);
    }
    if (builder.receiver != null) {
      initShim.receiver(builder.receiver);
    }
    if (builder.sendTaskFactory != null) {
      initShim.sendTaskFactory(builder.sendTaskFactory);
    }
    if (builder.receiveTaskFactory != null) {
      initShim.receiveTaskFactory(builder.receiveTaskFactory);
    }
    if (builder.selfDeafIsSet()) {
      initShim.selfDeaf(builder.selfDeaf);
    }
    if (builder.selfMuteIsSet()) {
      initShim.selfMute(builder.selfMute);
    }
    if (builder.ipDiscoveryTimeout != null) {
      initShim.ipDiscoveryTimeout(builder.ipDiscoveryTimeout);
    }
    if (builder.ipDiscoveryRetrySpec != null) {
      initShim.ipDiscoveryRetrySpec(builder.ipDiscoveryRetrySpec);
    }
    this.timeout = initShim.timeout();
    this.provider = initShim.provider();
    this.receiver = initShim.receiver();
    this.sendTaskFactory = initShim.sendTaskFactory();
    this.receiveTaskFactory = initShim.receiveTaskFactory();
    this.selfDeaf = initShim.selfDeaf();
    this.selfMute = initShim.selfMute();
    this.ipDiscoveryTimeout = initShim.ipDiscoveryTimeout();
    this.ipDiscoveryRetrySpec = initShim.ipDiscoveryRetrySpec();
    this.initShim = null;
  }

  private VoiceChannelJoinSpec(
      Duration timeout,
      AudioProvider provider,
      AudioReceiver receiver,
      VoiceSendTaskFactory sendTaskFactory,
      VoiceReceiveTaskFactory receiveTaskFactory,
      boolean selfDeaf,
      boolean selfMute,
      Duration ipDiscoveryTimeout,
      RetrySpec ipDiscoveryRetrySpec) {
    this.timeout = timeout;
    this.provider = provider;
    this.receiver = receiver;
    this.sendTaskFactory = sendTaskFactory;
    this.receiveTaskFactory = receiveTaskFactory;
    this.selfDeaf = selfDeaf;
    this.selfMute = selfMute;
    this.ipDiscoveryTimeout = ipDiscoveryTimeout;
    this.ipDiscoveryRetrySpec = ipDiscoveryRetrySpec;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VoiceChannelJoinSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration timeout;

    Duration timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(timeoutInitialize(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Duration timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte providerBuildStage = STAGE_UNINITIALIZED;
    private AudioProvider provider;

    AudioProvider provider() {
      if (providerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (providerBuildStage == STAGE_UNINITIALIZED) {
        providerBuildStage = STAGE_INITIALIZING;
        this.provider = Objects.requireNonNull(providerInitialize(), "provider");
        providerBuildStage = STAGE_INITIALIZED;
      }
      return this.provider;
    }

    void provider(AudioProvider provider) {
      this.provider = provider;
      providerBuildStage = STAGE_INITIALIZED;
    }

    private byte receiverBuildStage = STAGE_UNINITIALIZED;
    private AudioReceiver receiver;

    AudioReceiver receiver() {
      if (receiverBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (receiverBuildStage == STAGE_UNINITIALIZED) {
        receiverBuildStage = STAGE_INITIALIZING;
        this.receiver = Objects.requireNonNull(receiverInitialize(), "receiver");
        receiverBuildStage = STAGE_INITIALIZED;
      }
      return this.receiver;
    }

    void receiver(AudioReceiver receiver) {
      this.receiver = receiver;
      receiverBuildStage = STAGE_INITIALIZED;
    }

    private byte sendTaskFactoryBuildStage = STAGE_UNINITIALIZED;
    private VoiceSendTaskFactory sendTaskFactory;

    VoiceSendTaskFactory sendTaskFactory() {
      if (sendTaskFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sendTaskFactoryBuildStage == STAGE_UNINITIALIZED) {
        sendTaskFactoryBuildStage = STAGE_INITIALIZING;
        this.sendTaskFactory = Objects.requireNonNull(sendTaskFactoryInitialize(), "sendTaskFactory");
        sendTaskFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.sendTaskFactory;
    }

    void sendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
      this.sendTaskFactory = sendTaskFactory;
      sendTaskFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte receiveTaskFactoryBuildStage = STAGE_UNINITIALIZED;
    private VoiceReceiveTaskFactory receiveTaskFactory;

    VoiceReceiveTaskFactory receiveTaskFactory() {
      if (receiveTaskFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (receiveTaskFactoryBuildStage == STAGE_UNINITIALIZED) {
        receiveTaskFactoryBuildStage = STAGE_INITIALIZING;
        this.receiveTaskFactory = Objects.requireNonNull(receiveTaskFactoryInitialize(), "receiveTaskFactory");
        receiveTaskFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.receiveTaskFactory;
    }

    void receiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
      this.receiveTaskFactory = receiveTaskFactory;
      receiveTaskFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte selfDeafBuildStage = STAGE_UNINITIALIZED;
    private boolean selfDeaf;

    boolean selfDeaf() {
      if (selfDeafBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selfDeafBuildStage == STAGE_UNINITIALIZED) {
        selfDeafBuildStage = STAGE_INITIALIZING;
        this.selfDeaf = selfDeafInitialize();
        selfDeafBuildStage = STAGE_INITIALIZED;
      }
      return this.selfDeaf;
    }

    void selfDeaf(boolean selfDeaf) {
      this.selfDeaf = selfDeaf;
      selfDeafBuildStage = STAGE_INITIALIZED;
    }

    private byte selfMuteBuildStage = STAGE_UNINITIALIZED;
    private boolean selfMute;

    boolean selfMute() {
      if (selfMuteBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selfMuteBuildStage == STAGE_UNINITIALIZED) {
        selfMuteBuildStage = STAGE_INITIALIZING;
        this.selfMute = selfMuteInitialize();
        selfMuteBuildStage = STAGE_INITIALIZED;
      }
      return this.selfMute;
    }

    void selfMute(boolean selfMute) {
      this.selfMute = selfMute;
      selfMuteBuildStage = STAGE_INITIALIZED;
    }

    private byte ipDiscoveryTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration ipDiscoveryTimeout;

    Duration ipDiscoveryTimeout() {
      if (ipDiscoveryTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ipDiscoveryTimeoutBuildStage == STAGE_UNINITIALIZED) {
        ipDiscoveryTimeoutBuildStage = STAGE_INITIALIZING;
        this.ipDiscoveryTimeout = Objects.requireNonNull(ipDiscoveryTimeoutInitialize(), "ipDiscoveryTimeout");
        ipDiscoveryTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.ipDiscoveryTimeout;
    }

    void ipDiscoveryTimeout(Duration ipDiscoveryTimeout) {
      this.ipDiscoveryTimeout = ipDiscoveryTimeout;
      ipDiscoveryTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte ipDiscoveryRetrySpecBuildStage = STAGE_UNINITIALIZED;
    private RetrySpec ipDiscoveryRetrySpec;

    RetrySpec ipDiscoveryRetrySpec() {
      if (ipDiscoveryRetrySpecBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ipDiscoveryRetrySpecBuildStage == STAGE_UNINITIALIZED) {
        ipDiscoveryRetrySpecBuildStage = STAGE_INITIALIZING;
        this.ipDiscoveryRetrySpec = Objects.requireNonNull(ipDiscoveryRetrySpecInitialize(), "ipDiscoveryRetrySpec");
        ipDiscoveryRetrySpecBuildStage = STAGE_INITIALIZED;
      }
      return this.ipDiscoveryRetrySpec;
    }

    void ipDiscoveryRetrySpec(RetrySpec ipDiscoveryRetrySpec) {
      this.ipDiscoveryRetrySpec = ipDiscoveryRetrySpec;
      ipDiscoveryRetrySpecBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (providerBuildStage == STAGE_INITIALIZING) attributes.add("provider");
      if (receiverBuildStage == STAGE_INITIALIZING) attributes.add("receiver");
      if (sendTaskFactoryBuildStage == STAGE_INITIALIZING) attributes.add("sendTaskFactory");
      if (receiveTaskFactoryBuildStage == STAGE_INITIALIZING) attributes.add("receiveTaskFactory");
      if (selfDeafBuildStage == STAGE_INITIALIZING) attributes.add("selfDeaf");
      if (selfMuteBuildStage == STAGE_INITIALIZING) attributes.add("selfMute");
      if (ipDiscoveryTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("ipDiscoveryTimeout");
      if (ipDiscoveryRetrySpecBuildStage == STAGE_INITIALIZING) attributes.add("ipDiscoveryRetrySpec");
      return "Cannot build VoiceChannelJoinSpec, attribute initializers form cycle " + attributes;
    }
  }

  private Duration timeoutInitialize() {
    return VoiceChannelJoinSpecGenerator.super.timeout();
  }

  private AudioProvider providerInitialize() {
    return VoiceChannelJoinSpecGenerator.super.provider();
  }

  private AudioReceiver receiverInitialize() {
    return VoiceChannelJoinSpecGenerator.super.receiver();
  }

  private VoiceSendTaskFactory sendTaskFactoryInitialize() {
    return VoiceChannelJoinSpecGenerator.super.sendTaskFactory();
  }

  private VoiceReceiveTaskFactory receiveTaskFactoryInitialize() {
    return VoiceChannelJoinSpecGenerator.super.receiveTaskFactory();
  }

  private boolean selfDeafInitialize() {
    return VoiceChannelJoinSpecGenerator.super.selfDeaf();
  }

  private boolean selfMuteInitialize() {
    return VoiceChannelJoinSpecGenerator.super.selfMute();
  }

  private Duration ipDiscoveryTimeoutInitialize() {
    return VoiceChannelJoinSpecGenerator.super.ipDiscoveryTimeout();
  }

  private RetrySpec ipDiscoveryRetrySpecInitialize() {
    return VoiceChannelJoinSpecGenerator.super.ipDiscoveryRetrySpec();
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Duration timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code provider} attribute
   */
  @Override
  public AudioProvider provider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.provider()
        : this.provider;
  }

  /**
   * @return The value of the {@code receiver} attribute
   */
  @Deprecated
  @Override
  public AudioReceiver receiver() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.receiver()
        : this.receiver;
  }

  /**
   * @return The value of the {@code sendTaskFactory} attribute
   */
  @Override
  public VoiceSendTaskFactory sendTaskFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sendTaskFactory()
        : this.sendTaskFactory;
  }

  /**
   * @return The value of the {@code receiveTaskFactory} attribute
   */
  @Deprecated
  @Override
  public VoiceReceiveTaskFactory receiveTaskFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.receiveTaskFactory()
        : this.receiveTaskFactory;
  }

  /**
   * @return The value of the {@code selfDeaf} attribute
   */
  @Override
  public boolean selfDeaf() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.selfDeaf()
        : this.selfDeaf;
  }

  /**
   * @return The value of the {@code selfMute} attribute
   */
  @Override
  public boolean selfMute() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.selfMute()
        : this.selfMute;
  }

  /**
   * @return The value of the {@code ipDiscoveryTimeout} attribute
   */
  @Override
  public Duration ipDiscoveryTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ipDiscoveryTimeout()
        : this.ipDiscoveryTimeout;
  }

  /**
   * @return The value of the {@code ipDiscoveryRetrySpec} attribute
   */
  @Override
  public RetrySpec ipDiscoveryRetrySpec() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ipDiscoveryRetrySpec()
        : this.ipDiscoveryRetrySpec;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withTimeout(Duration value) {
    if (this.timeout == value) return this;
    Duration newValue = Objects.requireNonNull(value, "timeout");
    return validate(new VoiceChannelJoinSpec(
        newValue,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#provider() provider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for provider
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withProvider(AudioProvider value) {
    if (this.provider == value) return this;
    AudioProvider newValue = Objects.requireNonNull(value, "provider");
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        newValue,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#receiver() receiver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for receiver
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final VoiceChannelJoinSpec withReceiver(AudioReceiver value) {
    if (this.receiver == value) return this;
    AudioReceiver newValue = Objects.requireNonNull(value, "receiver");
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        newValue,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#sendTaskFactory() sendTaskFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sendTaskFactory
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withSendTaskFactory(VoiceSendTaskFactory value) {
    if (this.sendTaskFactory == value) return this;
    VoiceSendTaskFactory newValue = Objects.requireNonNull(value, "sendTaskFactory");
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        this.receiver,
        newValue,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#receiveTaskFactory() receiveTaskFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for receiveTaskFactory
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final VoiceChannelJoinSpec withReceiveTaskFactory(VoiceReceiveTaskFactory value) {
    if (this.receiveTaskFactory == value) return this;
    VoiceReceiveTaskFactory newValue = Objects.requireNonNull(value, "receiveTaskFactory");
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        newValue,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#selfDeaf() selfDeaf} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selfDeaf
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withSelfDeaf(boolean value) {
    if (this.selfDeaf == value) return this;
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        value,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#selfMute() selfMute} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selfMute
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withSelfMute(boolean value) {
    if (this.selfMute == value) return this;
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        value,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#ipDiscoveryTimeout() ipDiscoveryTimeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipDiscoveryTimeout
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withIpDiscoveryTimeout(Duration value) {
    if (this.ipDiscoveryTimeout == value) return this;
    Duration newValue = Objects.requireNonNull(value, "ipDiscoveryTimeout");
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        newValue,
        this.ipDiscoveryRetrySpec));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinSpec#ipDiscoveryRetrySpec() ipDiscoveryRetrySpec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipDiscoveryRetrySpec
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinSpec withIpDiscoveryRetrySpec(RetrySpec value) {
    if (this.ipDiscoveryRetrySpec == value) return this;
    RetrySpec newValue = Objects.requireNonNull(value, "ipDiscoveryRetrySpec");
    return validate(new VoiceChannelJoinSpec(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code VoiceChannelJoinSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VoiceChannelJoinSpec
        && equalTo(0, (VoiceChannelJoinSpec) another);
  }

  private boolean equalTo(int synthetic, VoiceChannelJoinSpec another) {
    return timeout.equals(another.timeout)
        && provider.equals(another.provider)
        && receiver.equals(another.receiver)
        && sendTaskFactory.equals(another.sendTaskFactory)
        && receiveTaskFactory.equals(another.receiveTaskFactory)
        && selfDeaf == another.selfDeaf
        && selfMute == another.selfMute
        && ipDiscoveryTimeout.equals(another.ipDiscoveryTimeout)
        && ipDiscoveryRetrySpec.equals(another.ipDiscoveryRetrySpec);
  }

  /**
   * Computes a hash code from attributes: {@code timeout}, {@code provider}, {@code receiver}, {@code sendTaskFactory}, {@code receiveTaskFactory}, {@code selfDeaf}, {@code selfMute}, {@code ipDiscoveryTimeout}, {@code ipDiscoveryRetrySpec}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + provider.hashCode();
    h += (h << 5) + receiver.hashCode();
    h += (h << 5) + sendTaskFactory.hashCode();
    h += (h << 5) + receiveTaskFactory.hashCode();
    h += (h << 5) + Boolean.hashCode(selfDeaf);
    h += (h << 5) + Boolean.hashCode(selfMute);
    h += (h << 5) + ipDiscoveryTimeout.hashCode();
    h += (h << 5) + ipDiscoveryRetrySpec.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VoiceChannelJoinSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VoiceChannelJoinSpec{"
        + "timeout=" + timeout
        + ", provider=" + provider
        + ", receiver=" + receiver
        + ", sendTaskFactory=" + sendTaskFactory
        + ", receiveTaskFactory=" + receiveTaskFactory
        + ", selfDeaf=" + selfDeaf
        + ", selfMute=" + selfMute
        + ", ipDiscoveryTimeout=" + ipDiscoveryTimeout
        + ", ipDiscoveryRetrySpec=" + ipDiscoveryRetrySpec
        + "}";
  }

  private static final VoiceChannelJoinSpec INSTANCE = validate(new VoiceChannelJoinSpec());

  /**
   * Returns the default immutable singleton value of {@code VoiceChannelJoinSpec}
   * @return An immutable instance of VoiceChannelJoinSpec
   */
  public static VoiceChannelJoinSpec create() {
    return INSTANCE;
  }

  private static VoiceChannelJoinSpec validate(VoiceChannelJoinSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link VoiceChannelJoinSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoiceChannelJoinSpec instance
   */
  static VoiceChannelJoinSpec copyOf(VoiceChannelJoinSpecGenerator instance) {
    if (instance instanceof VoiceChannelJoinSpec) {
      return (VoiceChannelJoinSpec) instance;
    }
    return VoiceChannelJoinSpec.builder()
        .from(instance)
        .build();
  }

  /**
   * Creates a builder for {@link VoiceChannelJoinSpec VoiceChannelJoinSpec}.
   * <pre>
   * VoiceChannelJoinSpec.builder()
   *    .timeout(java.time.Duration) // optional {@link VoiceChannelJoinSpec#timeout() timeout}
   *    .provider(discord4j.voice.AudioProvider) // optional {@link VoiceChannelJoinSpec#provider() provider}
   *    .receiver(discord4j.voice.AudioReceiver) // optional {@link VoiceChannelJoinSpec#receiver() receiver}
   *    .sendTaskFactory(discord4j.voice.VoiceSendTaskFactory) // optional {@link VoiceChannelJoinSpec#sendTaskFactory() sendTaskFactory}
   *    .receiveTaskFactory(discord4j.voice.VoiceReceiveTaskFactory) // optional {@link VoiceChannelJoinSpec#receiveTaskFactory() receiveTaskFactory}
   *    .selfDeaf(boolean) // optional {@link VoiceChannelJoinSpec#selfDeaf() selfDeaf}
   *    .selfMute(boolean) // optional {@link VoiceChannelJoinSpec#selfMute() selfMute}
   *    .ipDiscoveryTimeout(java.time.Duration) // optional {@link VoiceChannelJoinSpec#ipDiscoveryTimeout() ipDiscoveryTimeout}
   *    .ipDiscoveryRetrySpec(reactor.util.retry.RetrySpec) // optional {@link VoiceChannelJoinSpec#ipDiscoveryRetrySpec() ipDiscoveryRetrySpec}
   *    .build();
   * </pre>
   * @return A new VoiceChannelJoinSpec builder
   */
  public static VoiceChannelJoinSpec.Builder builder() {
    return new VoiceChannelJoinSpec.Builder();
  }

  /**
   * Builds instances of type {@link VoiceChannelJoinSpec VoiceChannelJoinSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VoiceChannelJoinSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long OPT_BIT_SELF_DEAF = 0x1L;
    private static final long OPT_BIT_SELF_MUTE = 0x2L;
    private long optBits;

    private Duration timeout;
    private AudioProvider provider;
    private AudioReceiver receiver;
    private VoiceSendTaskFactory sendTaskFactory;
    private VoiceReceiveTaskFactory receiveTaskFactory;
    private boolean selfDeaf;
    private boolean selfMute;
    private Duration ipDiscoveryTimeout;
    private RetrySpec ipDiscoveryRetrySpec;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VoiceChannelJoinSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VoiceChannelJoinSpec instance) {
      return from((VoiceChannelJoinSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code VoiceChannelJoinSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(VoiceChannelJoinSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      timeout(instance.timeout());
      provider(instance.provider());
      receiver(instance.receiver());
      sendTaskFactory(instance.sendTaskFactory());
      receiveTaskFactory(instance.receiveTaskFactory());
      selfDeaf(instance.selfDeaf());
      selfMute(instance.selfMute());
      ipDiscoveryTimeout(instance.ipDiscoveryTimeout());
      ipDiscoveryRetrySpec(instance.ipDiscoveryRetrySpec());
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#timeout() timeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#timeout() timeout}.</em>
     * @param timeout The value for timeout 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder timeout(Duration timeout) {
      this.timeout = Objects.requireNonNull(timeout, "timeout");
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#provider() provider} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#provider() provider}.</em>
     * @param provider The value for provider 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder provider(AudioProvider provider) {
      this.provider = Objects.requireNonNull(provider, "provider");
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#receiver() receiver} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#receiver() receiver}.</em>
     * @param receiver The value for receiver 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder receiver(AudioReceiver receiver) {
      this.receiver = Objects.requireNonNull(receiver, "receiver");
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#sendTaskFactory() sendTaskFactory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#sendTaskFactory() sendTaskFactory}.</em>
     * @param sendTaskFactory The value for sendTaskFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder sendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
      this.sendTaskFactory = Objects.requireNonNull(sendTaskFactory, "sendTaskFactory");
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#receiveTaskFactory() receiveTaskFactory} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#receiveTaskFactory() receiveTaskFactory}.</em>
     * @param receiveTaskFactory The value for receiveTaskFactory 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    @Deprecated
    public final Builder receiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
      this.receiveTaskFactory = Objects.requireNonNull(receiveTaskFactory, "receiveTaskFactory");
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#selfDeaf() selfDeaf} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#selfDeaf() selfDeaf}.</em>
     * @param selfDeaf The value for selfDeaf 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder selfDeaf(boolean selfDeaf) {
      this.selfDeaf = selfDeaf;
      optBits |= OPT_BIT_SELF_DEAF;
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#selfMute() selfMute} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#selfMute() selfMute}.</em>
     * @param selfMute The value for selfMute 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder selfMute(boolean selfMute) {
      this.selfMute = selfMute;
      optBits |= OPT_BIT_SELF_MUTE;
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#ipDiscoveryTimeout() ipDiscoveryTimeout} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#ipDiscoveryTimeout() ipDiscoveryTimeout}.</em>
     * @param ipDiscoveryTimeout The value for ipDiscoveryTimeout 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ipDiscoveryTimeout(Duration ipDiscoveryTimeout) {
      this.ipDiscoveryTimeout = Objects.requireNonNull(ipDiscoveryTimeout, "ipDiscoveryTimeout");
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelJoinSpec#ipDiscoveryRetrySpec() ipDiscoveryRetrySpec} attribute.
     * <p><em>If not set, this attribute will have a default value as returned by the initializer of {@link VoiceChannelJoinSpec#ipDiscoveryRetrySpec() ipDiscoveryRetrySpec}.</em>
     * @param ipDiscoveryRetrySpec The value for ipDiscoveryRetrySpec 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder ipDiscoveryRetrySpec(RetrySpec ipDiscoveryRetrySpec) {
      this.ipDiscoveryRetrySpec = Objects.requireNonNull(ipDiscoveryRetrySpec, "ipDiscoveryRetrySpec");
      return this;
    }

    /**
     * Builds a new {@link VoiceChannelJoinSpec VoiceChannelJoinSpec}.
     * @return An immutable instance of VoiceChannelJoinSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VoiceChannelJoinSpec build() {
      return VoiceChannelJoinSpec.validate(new VoiceChannelJoinSpec(this));
    }

    private boolean selfDeafIsSet() {
      return (optBits & OPT_BIT_SELF_DEAF) != 0;
    }

    private boolean selfMuteIsSet() {
      return (optBits & OPT_BIT_SELF_MUTE) != 0;
    }
  }
}
