package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.voice.AudioProvider;
import discord4j.voice.AudioReceiver;
import discord4j.voice.VoiceReceiveTaskFactory;
import discord4j.voice.VoiceSendTaskFactory;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;
import reactor.util.retry.RetrySpec;

/**
 * Immutable implementation of {@link VoiceChannelJoinMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code VoiceChannelJoinMono.of()}.
 */
@Generated(from = "VoiceChannelJoinMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all", "deprecation", "removal"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class VoiceChannelJoinMono extends VoiceChannelJoinMonoGenerator {
  private final Duration timeout;
  private final AudioProvider provider;
  private final AudioReceiver receiver;
  private final VoiceSendTaskFactory sendTaskFactory;
  private final VoiceReceiveTaskFactory receiveTaskFactory;
  private final boolean selfDeaf;
  private final boolean selfMute;
  private final Duration ipDiscoveryTimeout;
  private final RetrySpec ipDiscoveryRetrySpec;
  private final VoiceChannel channel;

  private VoiceChannelJoinMono(VoiceChannel channel) {
    this.channel = Objects.requireNonNull(channel, "channel");
    this.timeout = initShim.timeout();
    this.provider = initShim.provider();
    this.receiver = initShim.receiver();
    this.sendTaskFactory = initShim.sendTaskFactory();
    this.receiveTaskFactory = initShim.receiveTaskFactory();
    this.selfDeaf = initShim.selfDeaf();
    this.selfMute = initShim.selfMute();
    this.ipDiscoveryTimeout = initShim.ipDiscoveryTimeout();
    this.ipDiscoveryRetrySpec = initShim.ipDiscoveryRetrySpec();
    this.initShim = null;
  }

  private VoiceChannelJoinMono(
      Duration timeout,
      AudioProvider provider,
      AudioReceiver receiver,
      VoiceSendTaskFactory sendTaskFactory,
      VoiceReceiveTaskFactory receiveTaskFactory,
      boolean selfDeaf,
      boolean selfMute,
      Duration ipDiscoveryTimeout,
      RetrySpec ipDiscoveryRetrySpec,
      VoiceChannel channel) {
    this.timeout = timeout;
    this.provider = provider;
    this.receiver = receiver;
    this.sendTaskFactory = sendTaskFactory;
    this.receiveTaskFactory = receiveTaskFactory;
    this.selfDeaf = selfDeaf;
    this.selfMute = selfMute;
    this.ipDiscoveryTimeout = ipDiscoveryTimeout;
    this.ipDiscoveryRetrySpec = ipDiscoveryRetrySpec;
    this.channel = channel;
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VoiceChannelJoinMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private byte timeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration timeout;

    Duration timeout() {
      if (timeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (timeoutBuildStage == STAGE_UNINITIALIZED) {
        timeoutBuildStage = STAGE_INITIALIZING;
        this.timeout = Objects.requireNonNull(VoiceChannelJoinMono.super.timeout(), "timeout");
        timeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.timeout;
    }

    void timeout(Duration timeout) {
      this.timeout = timeout;
      timeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte providerBuildStage = STAGE_UNINITIALIZED;
    private AudioProvider provider;

    AudioProvider provider() {
      if (providerBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (providerBuildStage == STAGE_UNINITIALIZED) {
        providerBuildStage = STAGE_INITIALIZING;
        this.provider = Objects.requireNonNull(VoiceChannelJoinMono.super.provider(), "provider");
        providerBuildStage = STAGE_INITIALIZED;
      }
      return this.provider;
    }

    void provider(AudioProvider provider) {
      this.provider = provider;
      providerBuildStage = STAGE_INITIALIZED;
    }

    private byte receiverBuildStage = STAGE_UNINITIALIZED;
    private AudioReceiver receiver;

    AudioReceiver receiver() {
      if (receiverBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (receiverBuildStage == STAGE_UNINITIALIZED) {
        receiverBuildStage = STAGE_INITIALIZING;
        this.receiver = Objects.requireNonNull(VoiceChannelJoinMono.super.receiver(), "receiver");
        receiverBuildStage = STAGE_INITIALIZED;
      }
      return this.receiver;
    }

    void receiver(AudioReceiver receiver) {
      this.receiver = receiver;
      receiverBuildStage = STAGE_INITIALIZED;
    }

    private byte sendTaskFactoryBuildStage = STAGE_UNINITIALIZED;
    private VoiceSendTaskFactory sendTaskFactory;

    VoiceSendTaskFactory sendTaskFactory() {
      if (sendTaskFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (sendTaskFactoryBuildStage == STAGE_UNINITIALIZED) {
        sendTaskFactoryBuildStage = STAGE_INITIALIZING;
        this.sendTaskFactory = Objects.requireNonNull(VoiceChannelJoinMono.super.sendTaskFactory(), "sendTaskFactory");
        sendTaskFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.sendTaskFactory;
    }

    void sendTaskFactory(VoiceSendTaskFactory sendTaskFactory) {
      this.sendTaskFactory = sendTaskFactory;
      sendTaskFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte receiveTaskFactoryBuildStage = STAGE_UNINITIALIZED;
    private VoiceReceiveTaskFactory receiveTaskFactory;

    VoiceReceiveTaskFactory receiveTaskFactory() {
      if (receiveTaskFactoryBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (receiveTaskFactoryBuildStage == STAGE_UNINITIALIZED) {
        receiveTaskFactoryBuildStage = STAGE_INITIALIZING;
        this.receiveTaskFactory = Objects.requireNonNull(VoiceChannelJoinMono.super.receiveTaskFactory(), "receiveTaskFactory");
        receiveTaskFactoryBuildStage = STAGE_INITIALIZED;
      }
      return this.receiveTaskFactory;
    }

    void receiveTaskFactory(VoiceReceiveTaskFactory receiveTaskFactory) {
      this.receiveTaskFactory = receiveTaskFactory;
      receiveTaskFactoryBuildStage = STAGE_INITIALIZED;
    }

    private byte selfDeafBuildStage = STAGE_UNINITIALIZED;
    private boolean selfDeaf;

    boolean selfDeaf() {
      if (selfDeafBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selfDeafBuildStage == STAGE_UNINITIALIZED) {
        selfDeafBuildStage = STAGE_INITIALIZING;
        this.selfDeaf = VoiceChannelJoinMono.super.selfDeaf();
        selfDeafBuildStage = STAGE_INITIALIZED;
      }
      return this.selfDeaf;
    }

    void selfDeaf(boolean selfDeaf) {
      this.selfDeaf = selfDeaf;
      selfDeafBuildStage = STAGE_INITIALIZED;
    }

    private byte selfMuteBuildStage = STAGE_UNINITIALIZED;
    private boolean selfMute;

    boolean selfMute() {
      if (selfMuteBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (selfMuteBuildStage == STAGE_UNINITIALIZED) {
        selfMuteBuildStage = STAGE_INITIALIZING;
        this.selfMute = VoiceChannelJoinMono.super.selfMute();
        selfMuteBuildStage = STAGE_INITIALIZED;
      }
      return this.selfMute;
    }

    void selfMute(boolean selfMute) {
      this.selfMute = selfMute;
      selfMuteBuildStage = STAGE_INITIALIZED;
    }

    private byte ipDiscoveryTimeoutBuildStage = STAGE_UNINITIALIZED;
    private Duration ipDiscoveryTimeout;

    Duration ipDiscoveryTimeout() {
      if (ipDiscoveryTimeoutBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ipDiscoveryTimeoutBuildStage == STAGE_UNINITIALIZED) {
        ipDiscoveryTimeoutBuildStage = STAGE_INITIALIZING;
        this.ipDiscoveryTimeout = Objects.requireNonNull(VoiceChannelJoinMono.super.ipDiscoveryTimeout(), "ipDiscoveryTimeout");
        ipDiscoveryTimeoutBuildStage = STAGE_INITIALIZED;
      }
      return this.ipDiscoveryTimeout;
    }

    void ipDiscoveryTimeout(Duration ipDiscoveryTimeout) {
      this.ipDiscoveryTimeout = ipDiscoveryTimeout;
      ipDiscoveryTimeoutBuildStage = STAGE_INITIALIZED;
    }

    private byte ipDiscoveryRetrySpecBuildStage = STAGE_UNINITIALIZED;
    private RetrySpec ipDiscoveryRetrySpec;

    RetrySpec ipDiscoveryRetrySpec() {
      if (ipDiscoveryRetrySpecBuildStage == STAGE_INITIALIZING) throw new IllegalStateException(formatInitCycleMessage());
      if (ipDiscoveryRetrySpecBuildStage == STAGE_UNINITIALIZED) {
        ipDiscoveryRetrySpecBuildStage = STAGE_INITIALIZING;
        this.ipDiscoveryRetrySpec = Objects.requireNonNull(VoiceChannelJoinMono.super.ipDiscoveryRetrySpec(), "ipDiscoveryRetrySpec");
        ipDiscoveryRetrySpecBuildStage = STAGE_INITIALIZED;
      }
      return this.ipDiscoveryRetrySpec;
    }

    void ipDiscoveryRetrySpec(RetrySpec ipDiscoveryRetrySpec) {
      this.ipDiscoveryRetrySpec = ipDiscoveryRetrySpec;
      ipDiscoveryRetrySpecBuildStage = STAGE_INITIALIZED;
    }

    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      if (timeoutBuildStage == STAGE_INITIALIZING) attributes.add("timeout");
      if (providerBuildStage == STAGE_INITIALIZING) attributes.add("provider");
      if (receiverBuildStage == STAGE_INITIALIZING) attributes.add("receiver");
      if (sendTaskFactoryBuildStage == STAGE_INITIALIZING) attributes.add("sendTaskFactory");
      if (receiveTaskFactoryBuildStage == STAGE_INITIALIZING) attributes.add("receiveTaskFactory");
      if (selfDeafBuildStage == STAGE_INITIALIZING) attributes.add("selfDeaf");
      if (selfMuteBuildStage == STAGE_INITIALIZING) attributes.add("selfMute");
      if (ipDiscoveryTimeoutBuildStage == STAGE_INITIALIZING) attributes.add("ipDiscoveryTimeout");
      if (ipDiscoveryRetrySpecBuildStage == STAGE_INITIALIZING) attributes.add("ipDiscoveryRetrySpec");
      return "Cannot build VoiceChannelJoinMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code timeout} attribute
   */
  @Override
  public Duration timeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.timeout()
        : this.timeout;
  }

  /**
   * @return The value of the {@code provider} attribute
   */
  @Override
  public AudioProvider provider() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.provider()
        : this.provider;
  }

  /**
   * @return The value of the {@code receiver} attribute
   */
  @Deprecated
  @Override
  public AudioReceiver receiver() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.receiver()
        : this.receiver;
  }

  /**
   * @return The value of the {@code sendTaskFactory} attribute
   */
  @Override
  public VoiceSendTaskFactory sendTaskFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.sendTaskFactory()
        : this.sendTaskFactory;
  }

  /**
   * @return The value of the {@code receiveTaskFactory} attribute
   */
  @Deprecated
  @Override
  public VoiceReceiveTaskFactory receiveTaskFactory() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.receiveTaskFactory()
        : this.receiveTaskFactory;
  }

  /**
   * @return The value of the {@code selfDeaf} attribute
   */
  @Override
  public boolean selfDeaf() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.selfDeaf()
        : this.selfDeaf;
  }

  /**
   * @return The value of the {@code selfMute} attribute
   */
  @Override
  public boolean selfMute() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.selfMute()
        : this.selfMute;
  }

  /**
   * @return The value of the {@code ipDiscoveryTimeout} attribute
   */
  @Override
  public Duration ipDiscoveryTimeout() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ipDiscoveryTimeout()
        : this.ipDiscoveryTimeout;
  }

  /**
   * @return The value of the {@code ipDiscoveryRetrySpec} attribute
   */
  @Override
  public RetrySpec ipDiscoveryRetrySpec() {
    InitShim shim = this.initShim;
    return shim != null
        ? shim.ipDiscoveryRetrySpec()
        : this.ipDiscoveryRetrySpec;
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @Override
  public VoiceChannel channel() {
    return channel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#timeout() timeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for timeout
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withTimeout(Duration value) {
    if (this.timeout == value) return this;
    Duration newValue = Objects.requireNonNull(value, "timeout");
    return new VoiceChannelJoinMono(
        newValue,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#provider() provider} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for provider
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withProvider(AudioProvider value) {
    if (this.provider == value) return this;
    AudioProvider newValue = Objects.requireNonNull(value, "provider");
    return new VoiceChannelJoinMono(
        this.timeout,
        newValue,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#receiver() receiver} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for receiver
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final VoiceChannelJoinMono withReceiver(AudioReceiver value) {
    if (this.receiver == value) return this;
    AudioReceiver newValue = Objects.requireNonNull(value, "receiver");
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        newValue,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#sendTaskFactory() sendTaskFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for sendTaskFactory
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withSendTaskFactory(VoiceSendTaskFactory value) {
    if (this.sendTaskFactory == value) return this;
    VoiceSendTaskFactory newValue = Objects.requireNonNull(value, "sendTaskFactory");
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        newValue,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#receiveTaskFactory() receiveTaskFactory} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for receiveTaskFactory
   * @return A modified copy of the {@code this} object
   */
  @Deprecated
  public final VoiceChannelJoinMono withReceiveTaskFactory(VoiceReceiveTaskFactory value) {
    if (this.receiveTaskFactory == value) return this;
    VoiceReceiveTaskFactory newValue = Objects.requireNonNull(value, "receiveTaskFactory");
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        newValue,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#selfDeaf() selfDeaf} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selfDeaf
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withSelfDeaf(boolean value) {
    if (this.selfDeaf == value) return this;
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        value,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#selfMute() selfMute} attribute.
   * A value equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for selfMute
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withSelfMute(boolean value) {
    if (this.selfMute == value) return this;
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        value,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#ipDiscoveryTimeout() ipDiscoveryTimeout} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipDiscoveryTimeout
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withIpDiscoveryTimeout(Duration value) {
    if (this.ipDiscoveryTimeout == value) return this;
    Duration newValue = Objects.requireNonNull(value, "ipDiscoveryTimeout");
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        newValue,
        this.ipDiscoveryRetrySpec,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#ipDiscoveryRetrySpec() ipDiscoveryRetrySpec} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for ipDiscoveryRetrySpec
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withIpDiscoveryRetrySpec(RetrySpec value) {
    if (this.ipDiscoveryRetrySpec == value) return this;
    RetrySpec newValue = Objects.requireNonNull(value, "ipDiscoveryRetrySpec");
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelJoinMono#channel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelJoinMono withChannel(VoiceChannel value) {
    if (this.channel == value) return this;
    VoiceChannel newValue = Objects.requireNonNull(value, "channel");
    return new VoiceChannelJoinMono(
        this.timeout,
        this.provider,
        this.receiver,
        this.sendTaskFactory,
        this.receiveTaskFactory,
        this.selfDeaf,
        this.selfMute,
        this.ipDiscoveryTimeout,
        this.ipDiscoveryRetrySpec,
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code VoiceChannelJoinMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VoiceChannelJoinMono
        && equalTo(0, (VoiceChannelJoinMono) another);
  }

  private boolean equalTo(int synthetic, VoiceChannelJoinMono another) {
    return timeout.equals(another.timeout)
        && provider.equals(another.provider)
        && receiver.equals(another.receiver)
        && sendTaskFactory.equals(another.sendTaskFactory)
        && receiveTaskFactory.equals(another.receiveTaskFactory)
        && selfDeaf == another.selfDeaf
        && selfMute == another.selfMute
        && ipDiscoveryTimeout.equals(another.ipDiscoveryTimeout)
        && ipDiscoveryRetrySpec.equals(another.ipDiscoveryRetrySpec)
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code timeout}, {@code provider}, {@code receiver}, {@code sendTaskFactory}, {@code receiveTaskFactory}, {@code selfDeaf}, {@code selfMute}, {@code ipDiscoveryTimeout}, {@code ipDiscoveryRetrySpec}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + timeout.hashCode();
    h += (h << 5) + provider.hashCode();
    h += (h << 5) + receiver.hashCode();
    h += (h << 5) + sendTaskFactory.hashCode();
    h += (h << 5) + receiveTaskFactory.hashCode();
    h += (h << 5) + Boolean.hashCode(selfDeaf);
    h += (h << 5) + Boolean.hashCode(selfMute);
    h += (h << 5) + ipDiscoveryTimeout.hashCode();
    h += (h << 5) + ipDiscoveryRetrySpec.hashCode();
    h += (h << 5) + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VoiceChannelJoinMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VoiceChannelJoinMono{"
        + "timeout=" + timeout
        + ", provider=" + provider
        + ", receiver=" + receiver
        + ", sendTaskFactory=" + sendTaskFactory
        + ", receiveTaskFactory=" + receiveTaskFactory
        + ", selfDeaf=" + selfDeaf
        + ", selfMute=" + selfMute
        + ", ipDiscoveryTimeout=" + ipDiscoveryTimeout
        + ", ipDiscoveryRetrySpec=" + ipDiscoveryRetrySpec
        + ", channel=" + channel
        + "}";
  }

  /**
   * Construct a new immutable {@code VoiceChannelJoinMono} instance.
   * @param channel The value for the {@code channel} attribute
   * @return An immutable VoiceChannelJoinMono instance
   */
  public static VoiceChannelJoinMono of(VoiceChannel channel) {
    return new VoiceChannelJoinMono(channel);
  }

  /**
   * Creates an immutable copy of a {@link VoiceChannelJoinMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoiceChannelJoinMono instance
   */
  static VoiceChannelJoinMono copyOf(VoiceChannelJoinMonoGenerator instance) {
    if (instance instanceof VoiceChannelJoinMono) {
      return (VoiceChannelJoinMono) instance;
    }
    return VoiceChannelJoinMono.of(instance.channel())
        .withTimeout(instance.timeout())
        .withProvider(instance.provider())
        .withReceiver(instance.receiver())
        .withSendTaskFactory(instance.sendTaskFactory())
        .withReceiveTaskFactory(instance.receiveTaskFactory())
        .withSelfDeaf(instance.selfDeaf())
        .withSelfMute(instance.selfMute())
        .withIpDiscoveryTimeout(instance.ipDiscoveryTimeout())
        .withIpDiscoveryRetrySpec(instance.ipDiscoveryRetrySpec());
  }
}
