package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link VoiceChannelEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code VoiceChannelEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code VoiceChannelEditSpec.create()}.
 */
@Generated(from = "VoiceChannelEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class VoiceChannelEditSpec implements VoiceChannelEditSpecGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Integer bitrate_value;
  private final boolean bitrate_absent;
  private final Integer userLimit_value;
  private final boolean userLimit_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final String rtcRegion_value;
  private final boolean rtcRegion_absent;
  private final VoiceChannel.Mode videoQualityMode_value;
  private final boolean videoQualityMode_absent;

  private VoiceChannelEditSpec() {
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Integer> bitrate$impl = Possible.absent();
    Possible<Integer> userLimit$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Optional<Snowflake>> parentId$impl = Possible.absent();
    Possible<Optional<String>> rtcRegion$impl = Possible.absent();
    Possible<Optional<VoiceChannel.Mode>> videoQualityMode$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.rtcRegion_value = Possible.flatOpt(rtcRegion$impl).orElse(null);
    this.rtcRegion_absent = rtcRegion$impl.isAbsent();
    this.videoQualityMode_value = Possible.flatOpt(videoQualityMode$impl).orElse(null);
    this.videoQualityMode_absent = videoQualityMode$impl.isAbsent();
    this.initShim = null;
  }

  private VoiceChannelEditSpec(
      @Nullable String reason,
      Possible<String> name,
      Possible<Integer> bitrate,
      Possible<Integer> userLimit,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Optional<Snowflake>> parentId,
      Possible<Optional<String>> rtcRegion,
      Possible<Optional<VoiceChannel.Mode>> videoQualityMode) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Integer> bitrate$impl = bitrate;
    Possible<Integer> userLimit$impl = userLimit;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Optional<Snowflake>> parentId$impl = parentId;
    Possible<Optional<String>> rtcRegion$impl = rtcRegion;
    Possible<Optional<VoiceChannel.Mode>> videoQualityMode$impl = videoQualityMode;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.rtcRegion_value = Possible.flatOpt(rtcRegion$impl).orElse(null);
    this.rtcRegion_absent = rtcRegion$impl.isAbsent();
    this.videoQualityMode_value = Possible.flatOpt(videoQualityMode$impl).orElse(null);
    this.videoQualityMode_absent = videoQualityMode$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VoiceChannelEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build VoiceChannelEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code bitrate} attribute
   */
  @Override
  public Possible<Integer> bitrate() {
    return bitrate_absent ? Possible.absent() : Possible.of(bitrate_value);
  }

  /**
   * @return The value of the {@code userLimit} attribute
   */
  @Override
  public Possible<Integer> userLimit() {
    return userLimit_absent ? Possible.absent() : Possible.of(userLimit_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> parentId() {
    return parentId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(parentId_value));
  }

  /**
   * @return The value of the {@code rtcRegion} attribute
   */
  @Override
  public Possible<Optional<String>> rtcRegion() {
    return rtcRegion_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(rtcRegion_value));
  }

  /**
   * @return The value of the {@code videoQualityMode} attribute
   */
  @Override
  public Possible<Optional<VoiceChannel.Mode>> videoQualityMode() {
    return videoQualityMode_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(videoQualityMode_value));
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelEditSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelEditSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return validate(new VoiceChannelEditSpec(
        value,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        newValue,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        newValue,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withBitrate(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withBitrate(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withUserLimit(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withUserLimit(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  @SafeVarargs
  public final VoiceChannelEditSpec withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withParentId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  @Deprecated
  public VoiceChannelEditSpec withParentId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withParentIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.rtcRegion(),
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withRtcRegion(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.videoQualityMode()));
  }

  @Deprecated
  public VoiceChannelEditSpec withRtcRegion(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withRtcRegionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.videoQualityMode()));
  }

  public VoiceChannelEditSpec withVideoQualityMode(Possible<Optional<VoiceChannel.Mode>> value) {
    Possible<Optional<VoiceChannel.Mode>> newValue = Objects.requireNonNull(value);
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        newValue));
  }

  @Deprecated
  public VoiceChannelEditSpec withVideoQualityMode(@Nullable VoiceChannel.Mode value) {
    Possible<Optional<VoiceChannel.Mode>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        newValue));
  }

  public VoiceChannelEditSpec withVideoQualityModeOrNull(@Nullable VoiceChannel.Mode value) {
    Possible<Optional<VoiceChannel.Mode>> newValue = Possible.of(Optional.ofNullable(value));
    return validate(new VoiceChannelEditSpec(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        newValue));
  }

  /**
   * This instance is equal to all instances of {@code VoiceChannelEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VoiceChannelEditSpec
        && equalTo(0, (VoiceChannelEditSpec) another);
  }

  private boolean equalTo(int synthetic, VoiceChannelEditSpec another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.bitrate().equals(another.bitrate())
        && this.userLimit().equals(another.userLimit())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && this.rtcRegion().equals(another.rtcRegion())
        && this.videoQualityMode().equals(another.videoQualityMode());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code bitrate}, {@code userLimit}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code rtcRegion}, {@code videoQualityMode}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (bitrate().hashCode());
    h += (h << 5) + (userLimit().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + (rtcRegion().hashCode());
    h += (h << 5) + (videoQualityMode().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code VoiceChannelEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VoiceChannelEditSpec{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", bitrate=" + (bitrate().toString())
        + ", userLimit=" + (userLimit().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", rtcRegion=" + (rtcRegion().toString())
        + ", videoQualityMode=" + (videoQualityMode().toString())
        + "}";
  }

  private static final VoiceChannelEditSpec INSTANCE = validate(new VoiceChannelEditSpec());

  /**
   * Returns the default immutable singleton value of {@code VoiceChannelEditSpec}
   * @return An immutable instance of VoiceChannelEditSpec
   */
  public static VoiceChannelEditSpec create() {
    return INSTANCE;
  }

  private static VoiceChannelEditSpec validate(VoiceChannelEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link VoiceChannelEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoiceChannelEditSpec instance
   */
  static VoiceChannelEditSpec copyOf(VoiceChannelEditSpecGenerator instance) {
    if (instance instanceof VoiceChannelEditSpec) {
      return (VoiceChannelEditSpec) instance;
    }
    return VoiceChannelEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isBitratePresent() {
    return !bitrate_absent;
  }

  public Integer bitrateOrElse(Integer defaultValue) {
    return !bitrate_absent ? bitrate_value : defaultValue;
  }

  public boolean isUserLimitPresent() {
    return !userLimit_absent;
  }

  public Integer userLimitOrElse(Integer defaultValue) {
    return !userLimit_absent ? userLimit_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  public boolean isRtcRegionPresent() {
    return !rtcRegion_absent;
  }

  public String rtcRegionOrElse(String defaultValue) {
    return !rtcRegion_absent ? rtcRegion_value : defaultValue;
  }

  public boolean isVideoQualityModePresent() {
    return !videoQualityMode_absent;
  }

  public VoiceChannel.Mode videoQualityModeOrElse(VoiceChannel.Mode defaultValue) {
    return !videoQualityMode_absent ? videoQualityMode_value : defaultValue;
  }

  /**
   * Creates a builder for {@link VoiceChannelEditSpec VoiceChannelEditSpec}.
   * <pre>
   * VoiceChannelEditSpec.builder()
   *    .reason(String | null) // nullable {@link VoiceChannelEditSpec#reason() reason}
   *    .name(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link VoiceChannelEditSpec#name() name}
   *    .bitrate(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link VoiceChannelEditSpec#bitrate() bitrate}
   *    .userLimit(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link VoiceChannelEditSpec#userLimit() userLimit}
   *    .position(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link VoiceChannelEditSpec#position() position}
   *    .permissionOverwrites(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.PermissionOverwrite&amp;gt;&amp;gt;) // {@link VoiceChannelEditSpec#permissionOverwrites() permissionOverwrites}
   *    .parentId(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.common.util.Snowflake&amp;gt;&amp;gt;) // {@link VoiceChannelEditSpec#parentId() parentId}
   *    .rtcRegion(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;String&amp;gt;&amp;gt;) // {@link VoiceChannelEditSpec#rtcRegion() rtcRegion}
   *    .videoQualityMode(discord4j.discordjson.possible.Possible&amp;lt;Optional&amp;lt;discord4j.core.object.entity.channel.VoiceChannel.Mode&amp;gt;&amp;gt;) // {@link VoiceChannelEditSpec#videoQualityMode() videoQualityMode}
   *    .build();
   * </pre>
   * @return A new VoiceChannelEditSpec builder
   */
  public static VoiceChannelEditSpec.Builder builder() {
    return new VoiceChannelEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link VoiceChannelEditSpec VoiceChannelEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VoiceChannelEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> name_possible = Possible.absent();
    private Possible<Integer> bitrate_possible = Possible.absent();
    private Possible<Integer> userLimit_possible = Possible.absent();
    private Possible<Integer> position_possible = Possible.absent();
    private List<PermissionOverwrite> permissionOverwrites_list = null;
    private Possible<Optional<Snowflake>> parentId_possible = Possible.absent();
    private Possible<Optional<String>> rtcRegion_possible = Possible.absent();
    private Possible<Optional<VoiceChannel.Mode>> videoQualityMode_possible = Possible.absent();
    private String reason;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VoiceChannelEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VoiceChannelEditSpec instance) {
      return from((VoiceChannelEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code VoiceChannelEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(VoiceChannelEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      bitrate(instance.bitrate());
      userLimit(instance.userLimit());
      position(instance.position());
      permissionOverwrites(instance.permissionOverwrites());
      parentId(instance.parentId());
      rtcRegion(instance.rtcRegion());
      videoQualityMode(instance.videoQualityMode());
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelEditSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(Possible<String> value) {
      this.name_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder name(String value) {
      this.name_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder bitrate(Possible<Integer> value) {
      this.bitrate_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder bitrate(Integer value) {
      this.bitrate_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder userLimit(Possible<Integer> value) {
      this.userLimit_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder userLimit(Integer value) {
      this.userLimit_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Possible<Integer> value) {
      this.position_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Integer value) {
      this.position_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addPermissionOverwrite(PermissionOverwrite element) {
      permissionOverwrites_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
      permissionOverwrites_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
      this.permissionOverwrites_list = null;
      elements.toOptional().ifPresent(e -> permissionOverwrites_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentId(Possible<Optional<Snowflake>> value) {
      this.parentId_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder parentId(@Nullable Snowflake value) {
      this.parentId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentIdOrNull(@Nullable Snowflake value) {
      this.parentId_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder rtcRegion(Possible<Optional<String>> value) {
      this.rtcRegion_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder rtcRegion(@Nullable String value) {
      this.rtcRegion_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder rtcRegionOrNull(@Nullable String value) {
      this.rtcRegion_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder videoQualityMode(Possible<Optional<VoiceChannel.Mode>> value) {
      this.videoQualityMode_possible = value;
      return this;
    }

    @Deprecated
    @CanIgnoreReturnValue
    public Builder videoQualityMode(@Nullable VoiceChannel.Mode value) {
      this.videoQualityMode_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder videoQualityModeOrNull(@Nullable VoiceChannel.Mode value) {
      this.videoQualityMode_possible = Possible.of(Optional.ofNullable(value));
      return this;
    }

    /**
     * Builds a new {@link VoiceChannelEditSpec VoiceChannelEditSpec}.
     * @return An immutable instance of VoiceChannelEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VoiceChannelEditSpec build() {
      return VoiceChannelEditSpec.validate(new VoiceChannelEditSpec(
          reason,
          name_build(),
          bitrate_build(),
          userLimit_build(),
          position_build(),
          permissionOverwrites_build(),
          parentId_build(),
          rtcRegion_build(),
          videoQualityMode_build()));
    }

    private Possible<String> name_build() {
      return this.name_possible;
    }

    private Possible<Integer> bitrate_build() {
      return this.bitrate_possible;
    }

    private Possible<Integer> userLimit_build() {
      return this.userLimit_possible;
    }

    private Possible<Integer> position_build() {
      return this.position_possible;
    }

    private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
      return this.permissionOverwrites_list == null ? Possible.absent() :
          Possible.of(this.permissionOverwrites_list);
    }

    private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
      if (this.permissionOverwrites_list == null) {
        this.permissionOverwrites_list = new ArrayList<>();
      }
      return this.permissionOverwrites_list;
    }

    private Possible<Optional<Snowflake>> parentId_build() {
      return this.parentId_possible;
    }

    private Possible<Optional<String>> rtcRegion_build() {
      return this.rtcRegion_possible;
    }

    private Possible<Optional<VoiceChannel.Mode>> videoQualityMode_build() {
      return this.videoQualityMode_possible;
    }
  }
}
