package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.channel.VoiceChannel;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link VoiceChannelEditMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code VoiceChannelEditMono.of()}.
 */
@Generated(from = "VoiceChannelEditMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class VoiceChannelEditMono extends VoiceChannelEditMonoGenerator {
  private final @Nullable String reason;
  private final String name_value;
  private final boolean name_absent;
  private final Integer bitrate_value;
  private final boolean bitrate_absent;
  private final Integer userLimit_value;
  private final boolean userLimit_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final String rtcRegion_value;
  private final boolean rtcRegion_absent;
  private final VoiceChannel.Mode videoQualityMode_value;
  private final boolean videoQualityMode_absent;
  private final VoiceChannel channel;

  private VoiceChannelEditMono(VoiceChannel channel) {
    this.channel = Objects.requireNonNull(channel, "channel");
    this.reason = null;
    Possible<String> name$impl = Possible.absent();
    Possible<Integer> bitrate$impl = Possible.absent();
    Possible<Integer> userLimit$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Optional<Snowflake>> parentId$impl = Possible.absent();
    Possible<Optional<String>> rtcRegion$impl = Possible.absent();
    Possible<Optional<VoiceChannel.Mode>> videoQualityMode$impl = Possible.absent();
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.rtcRegion_value = Possible.flatOpt(rtcRegion$impl).orElse(null);
    this.rtcRegion_absent = rtcRegion$impl.isAbsent();
    this.videoQualityMode_value = Possible.flatOpt(videoQualityMode$impl).orElse(null);
    this.videoQualityMode_absent = videoQualityMode$impl.isAbsent();
    this.initShim = null;
  }

  private VoiceChannelEditMono(
      @Nullable String reason,
      Possible<String> name,
      Possible<Integer> bitrate,
      Possible<Integer> userLimit,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Optional<Snowflake>> parentId,
      Possible<Optional<String>> rtcRegion,
      Possible<Optional<VoiceChannel.Mode>> videoQualityMode,
      VoiceChannel channel) {
    this.reason = reason;
    Possible<String> name$impl = name;
    Possible<Integer> bitrate$impl = bitrate;
    Possible<Integer> userLimit$impl = userLimit;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Optional<Snowflake>> parentId$impl = parentId;
    Possible<Optional<String>> rtcRegion$impl = rtcRegion;
    Possible<Optional<VoiceChannel.Mode>> videoQualityMode$impl = videoQualityMode;
    this.channel = channel;
    this.name_value = name$impl.toOptional().orElse(null);
    this.name_absent = name$impl.isAbsent();
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = Possible.flatOpt(parentId$impl).orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.rtcRegion_value = Possible.flatOpt(rtcRegion$impl).orElse(null);
    this.rtcRegion_absent = rtcRegion$impl.isAbsent();
    this.videoQualityMode_value = Possible.flatOpt(videoQualityMode$impl).orElse(null);
    this.videoQualityMode_absent = videoQualityMode$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VoiceChannelEditMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build VoiceChannelEditMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public Possible<String> name() {
    return name_absent ? Possible.absent() : Possible.of(name_value);
  }

  /**
   * @return The value of the {@code bitrate} attribute
   */
  @Override
  public Possible<Integer> bitrate() {
    return bitrate_absent ? Possible.absent() : Possible.of(bitrate_value);
  }

  /**
   * @return The value of the {@code userLimit} attribute
   */
  @Override
  public Possible<Integer> userLimit() {
    return userLimit_absent ? Possible.absent() : Possible.of(userLimit_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Optional<Snowflake>> parentId() {
    return parentId_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(parentId_value));
  }

  /**
   * @return The value of the {@code rtcRegion} attribute
   */
  @Override
  public Possible<Optional<String>> rtcRegion() {
    return rtcRegion_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(rtcRegion_value));
  }

  /**
   * @return The value of the {@code videoQualityMode} attribute
   */
  @Override
  public Possible<Optional<VoiceChannel.Mode>> videoQualityMode() {
    return videoQualityMode_absent ? Possible.absent() :
        Possible.of(Optional.ofNullable(videoQualityMode_value));
  }

  /**
   * @return The value of the {@code channel} attribute
   */
  @Override
  public VoiceChannel channel() {
    return channel;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelEditMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelEditMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new VoiceChannelEditMono(
        value,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withName(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        newValue,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withName(String value) {
    Possible<String> newValue = Possible.of(value);
    return new VoiceChannelEditMono(
        this.reason,
        newValue,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withBitrate(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withBitrate(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withUserLimit(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withUserLimit(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  @SafeVarargs
  public final VoiceChannelEditMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withParentId(Possible<Optional<Snowflake>> value) {
    Possible<Optional<Snowflake>> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  @Deprecated
  public VoiceChannelEditMono withParentId(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withParentIdOrNull(@Nullable Snowflake value) {
    Possible<Optional<Snowflake>> newValue = Possible.of(Optional.ofNullable(value));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.rtcRegion(),
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withRtcRegion(Possible<Optional<String>> value) {
    Possible<Optional<String>> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.videoQualityMode(),
        this.channel);
  }

  @Deprecated
  public VoiceChannelEditMono withRtcRegion(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withRtcRegionOrNull(@Nullable String value) {
    Possible<Optional<String>> newValue = Possible.of(Optional.ofNullable(value));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue,
        this.videoQualityMode(),
        this.channel);
  }

  public VoiceChannelEditMono withVideoQualityMode(Possible<Optional<VoiceChannel.Mode>> value) {
    Possible<Optional<VoiceChannel.Mode>> newValue = Objects.requireNonNull(value);
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        newValue,
        this.channel);
  }

  @Deprecated
  public VoiceChannelEditMono withVideoQualityMode(@Nullable VoiceChannel.Mode value) {
    Possible<Optional<VoiceChannel.Mode>> newValue = Possible.of(Optional.ofNullable(value));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        newValue,
        this.channel);
  }

  public VoiceChannelEditMono withVideoQualityModeOrNull(@Nullable VoiceChannel.Mode value) {
    Possible<Optional<VoiceChannel.Mode>> newValue = Possible.of(Optional.ofNullable(value));
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        newValue,
        this.channel);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelEditMono#channel() channel} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for channel
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelEditMono withChannel(VoiceChannel value) {
    if (this.channel == value) return this;
    VoiceChannel newValue = Objects.requireNonNull(value, "channel");
    return new VoiceChannelEditMono(
        this.reason,
        this.name(),
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.rtcRegion(),
        this.videoQualityMode(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code VoiceChannelEditMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VoiceChannelEditMono
        && equalTo(0, (VoiceChannelEditMono) another);
  }

  private boolean equalTo(int synthetic, VoiceChannelEditMono another) {
    return Objects.equals(reason, another.reason)
        && this.name().equals(another.name())
        && this.bitrate().equals(another.bitrate())
        && this.userLimit().equals(another.userLimit())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && this.rtcRegion().equals(another.rtcRegion())
        && this.videoQualityMode().equals(another.videoQualityMode())
        && channel.equals(another.channel);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code bitrate}, {@code userLimit}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code rtcRegion}, {@code videoQualityMode}, {@code channel}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + (name().hashCode());
    h += (h << 5) + (bitrate().hashCode());
    h += (h << 5) + (userLimit().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + (rtcRegion().hashCode());
    h += (h << 5) + (videoQualityMode().hashCode());
    h += (h << 5) + channel.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VoiceChannelEditMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VoiceChannelEditMono{"
        + "reason=" + reason
        + ", name=" + (name().toString())
        + ", bitrate=" + (bitrate().toString())
        + ", userLimit=" + (userLimit().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", rtcRegion=" + (rtcRegion().toString())
        + ", videoQualityMode=" + (videoQualityMode().toString())
        + ", channel=" + channel
        + "}";
  }

  /**
   * Construct a new immutable {@code VoiceChannelEditMono} instance.
   * @param channel The value for the {@code channel} attribute
   * @return An immutable VoiceChannelEditMono instance
   */
  public static VoiceChannelEditMono of(VoiceChannel channel) {
    return new VoiceChannelEditMono(channel);
  }

  /**
   * Creates an immutable copy of a {@link VoiceChannelEditMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoiceChannelEditMono instance
   */
  static VoiceChannelEditMono copyOf(VoiceChannelEditMonoGenerator instance) {
    if (instance instanceof VoiceChannelEditMono) {
      return (VoiceChannelEditMono) instance;
    }
    return VoiceChannelEditMono.of(instance.channel())
        .withReason(instance.reason())
        .withName(instance.name())
        .withBitrate(instance.bitrate())
        .withUserLimit(instance.userLimit())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites())
        .withParentId(instance.parentId())
        .withRtcRegion(instance.rtcRegion())
        .withVideoQualityMode(instance.videoQualityMode());
  }

  public boolean isNamePresent() {
    return !name_absent;
  }

  public String nameOrElse(String defaultValue) {
    return !name_absent ? name_value : defaultValue;
  }

  public boolean isBitratePresent() {
    return !bitrate_absent;
  }

  public Integer bitrateOrElse(Integer defaultValue) {
    return !bitrate_absent ? bitrate_value : defaultValue;
  }

  public boolean isUserLimitPresent() {
    return !userLimit_absent;
  }

  public Integer userLimitOrElse(Integer defaultValue) {
    return !userLimit_absent ? userLimit_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  public boolean isRtcRegionPresent() {
    return !rtcRegion_absent;
  }

  public String rtcRegionOrElse(String defaultValue) {
    return !rtcRegion_absent ? rtcRegion_value : defaultValue;
  }

  public boolean isVideoQualityModePresent() {
    return !videoQualityMode_absent;
  }

  public VoiceChannel.Mode videoQualityModeOrElse(VoiceChannel.Mode defaultValue) {
    return !videoQualityMode_absent ? videoQualityMode_value : defaultValue;
  }
}
