package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link VoiceChannelCreateSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code VoiceChannelCreateSpec.builder()}.
 * Use the static factory method to create immutable instances:
 * {@code VoiceChannelCreateSpec.of()}.
 */
@Generated(from = "VoiceChannelCreateSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class VoiceChannelCreateSpec implements VoiceChannelCreateSpecGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Integer bitrate_value;
  private final boolean bitrate_absent;
  private final Integer userLimit_value;
  private final boolean userLimit_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;

  private VoiceChannelCreateSpec(String name) {
    this.name = Objects.requireNonNull(name, "name");
    this.reason = null;
    Possible<Integer> bitrate$impl = Possible.absent();
    Possible<Integer> userLimit$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Snowflake> parentId$impl = Possible.absent();
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private VoiceChannelCreateSpec(
      @Nullable String reason,
      String name,
      Possible<Integer> bitrate,
      Possible<Integer> userLimit,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Snowflake> parentId) {
    this.reason = reason;
    this.name = name;
    Possible<Integer> bitrate$impl = bitrate;
    Possible<Integer> userLimit$impl = userLimit;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Snowflake> parentId$impl = parentId;
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VoiceChannelCreateSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build VoiceChannelCreateSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code bitrate} attribute
   */
  @Override
  public Possible<Integer> bitrate() {
    return bitrate_absent ? Possible.absent() : Possible.of(bitrate_value);
  }

  /**
   * @return The value of the {@code userLimit} attribute
   */
  @Override
  public Possible<Integer> userLimit() {
    return userLimit_absent ? Possible.absent() : Possible.of(userLimit_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Snowflake> parentId() {
    return parentId_absent ? Possible.absent() : Possible.of(parentId_value);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelCreateSpec#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelCreateSpec withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new VoiceChannelCreateSpec(
        value,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId());
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelCreateSpec#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelCreateSpec withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new VoiceChannelCreateSpec(
        this.reason,
        newValue,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withBitrate(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withBitrate(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withUserLimit(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withUserLimit(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId());
  }

  public VoiceChannelCreateSpec withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId());
  }

  public VoiceChannelCreateSpec withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId());
  }

  @SafeVarargs
  public final VoiceChannelCreateSpec withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId());
  }

  public VoiceChannelCreateSpec withParentId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue);
  }

  public VoiceChannelCreateSpec withParentId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new VoiceChannelCreateSpec(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code VoiceChannelCreateSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VoiceChannelCreateSpec
        && equalTo(0, (VoiceChannelCreateSpec) another);
  }

  private boolean equalTo(int synthetic, VoiceChannelCreateSpec another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.bitrate().equals(another.bitrate())
        && this.userLimit().equals(another.userLimit())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId());
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code bitrate}, {@code userLimit}, {@code position}, {@code permissionOverwrites}, {@code parentId}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (bitrate().hashCode());
    h += (h << 5) + (userLimit().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code VoiceChannelCreateSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VoiceChannelCreateSpec{"
        + "reason=" + reason
        + ", name=" + name
        + ", bitrate=" + (bitrate().toString())
        + ", userLimit=" + (userLimit().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + "}";
  }

  /**
   * Construct a new immutable {@code VoiceChannelCreateSpec} instance.
   * @param name The value for the {@code name} attribute
   * @return An immutable VoiceChannelCreateSpec instance
   */
  public static VoiceChannelCreateSpec of(String name) {
    return new VoiceChannelCreateSpec(name);
  }

  /**
   * Creates an immutable copy of a {@link VoiceChannelCreateSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoiceChannelCreateSpec instance
   */
  static VoiceChannelCreateSpec copyOf(VoiceChannelCreateSpecGenerator instance) {
    if (instance instanceof VoiceChannelCreateSpec) {
      return (VoiceChannelCreateSpec) instance;
    }
    return VoiceChannelCreateSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isBitratePresent() {
    return !bitrate_absent;
  }

  public Integer bitrateOrElse(Integer defaultValue) {
    return !bitrate_absent ? bitrate_value : defaultValue;
  }

  public boolean isUserLimitPresent() {
    return !userLimit_absent;
  }

  public Integer userLimitOrElse(Integer defaultValue) {
    return !userLimit_absent ? userLimit_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }

  /**
   * Creates a builder for {@link VoiceChannelCreateSpec VoiceChannelCreateSpec}.
   * <pre>
   * VoiceChannelCreateSpec.builder()
   *    .reason(String | null) // nullable {@link VoiceChannelCreateSpec#reason() reason}
   *    .name(String) // required {@link VoiceChannelCreateSpec#name() name}
   *    .bitrate(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link VoiceChannelCreateSpec#bitrate() bitrate}
   *    .userLimit(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link VoiceChannelCreateSpec#userLimit() userLimit}
   *    .position(discord4j.discordjson.possible.Possible&amp;lt;Integer&amp;gt;) // {@link VoiceChannelCreateSpec#position() position}
   *    .permissionOverwrites(discord4j.discordjson.possible.Possible&amp;lt;List&amp;lt;discord4j.core.object.PermissionOverwrite&amp;gt;&amp;gt;) // {@link VoiceChannelCreateSpec#permissionOverwrites() permissionOverwrites}
   *    .parentId(discord4j.discordjson.possible.Possible&amp;lt;discord4j.common.util.Snowflake&amp;gt;) // {@link VoiceChannelCreateSpec#parentId() parentId}
   *    .build();
   * </pre>
   * @return A new VoiceChannelCreateSpec builder
   */
  public static VoiceChannelCreateSpec.Builder builder() {
    return new VoiceChannelCreateSpec.Builder();
  }

  /**
   * Builds instances of type {@link VoiceChannelCreateSpec VoiceChannelCreateSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "VoiceChannelCreateSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private static final long INIT_BIT_NAME = 0x1L;
    private long initBits = 0x1L;

    private Possible<Integer> bitrate_possible = Possible.absent();
    private Possible<Integer> userLimit_possible = Possible.absent();
    private Possible<Integer> position_possible = Possible.absent();
    private List<PermissionOverwrite> permissionOverwrites_list = null;
    private Possible<Snowflake> parentId_possible = Possible.absent();
    private String reason;
    private String name;

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code VoiceChannelCreateSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(VoiceChannelCreateSpec instance) {
      return from((VoiceChannelCreateSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code VoiceChannelCreateSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(VoiceChannelCreateSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      String reasonValue = instance.reason();
      if (reasonValue != null) {
        reason(reasonValue);
      }
      name(instance.name());
      bitrate(instance.bitrate());
      userLimit(instance.userLimit());
      position(instance.position());
      permissionOverwrites(instance.permissionOverwrites());
      parentId(instance.parentId());
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelCreateSpec#reason() reason} attribute.
     * @param reason The value for reason (can be {@code null})
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder reason(@Nullable String reason) {
      this.reason = reason;
      return this;
    }

    /**
     * Initializes the value for the {@link VoiceChannelCreateSpec#name() name} attribute.
     * @param name The value for name 
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    public final Builder name(String name) {
      this.name = Objects.requireNonNull(name, "name");
      initBits &= ~INIT_BIT_NAME;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder bitrate(Possible<Integer> value) {
      this.bitrate_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder bitrate(Integer value) {
      this.bitrate_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder userLimit(Possible<Integer> value) {
      this.userLimit_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder userLimit(Integer value) {
      this.userLimit_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Possible<Integer> value) {
      this.position_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder position(Integer value) {
      this.position_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addPermissionOverwrite(PermissionOverwrite element) {
      permissionOverwrites_getOrCreate().add(element);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder addAllPermissionOverwrites(List<PermissionOverwrite> elements) {
      permissionOverwrites_getOrCreate().addAll(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Possible<List<PermissionOverwrite>> elements) {
      this.permissionOverwrites_list = null;
      elements.toOptional().ifPresent(e -> permissionOverwrites_getOrCreate().addAll(e));
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(List<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = new ArrayList<>(elements);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder permissionOverwrites(Iterable<PermissionOverwrite> elements) {
      this.permissionOverwrites_list = StreamSupport.stream(elements.spliterator(), false).collect(Collectors.toList());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentId(Possible<Snowflake> value) {
      this.parentId_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder parentId(Snowflake value) {
      this.parentId_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link VoiceChannelCreateSpec VoiceChannelCreateSpec}.
     * @return An immutable instance of VoiceChannelCreateSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public VoiceChannelCreateSpec build() {
      if (initBits != 0) {
        throw new IllegalStateException(formatRequiredAttributesMessage());
      }
      return new VoiceChannelCreateSpec(
          reason,
          name,
          bitrate_build(),
          userLimit_build(),
          position_build(),
          permissionOverwrites_build(),
          parentId_build());
    }

    private String formatRequiredAttributesMessage() {
      List<String> attributes = new ArrayList<>();
      if ((initBits & INIT_BIT_NAME) != 0) attributes.add("name");
      return "Cannot build VoiceChannelCreateSpec, some of required attributes are not set " + attributes;
    }

    private Possible<Integer> bitrate_build() {
      return this.bitrate_possible;
    }

    private Possible<Integer> userLimit_build() {
      return this.userLimit_possible;
    }

    private Possible<Integer> position_build() {
      return this.position_possible;
    }

    private Possible<List<PermissionOverwrite>> permissionOverwrites_build() {
      return this.permissionOverwrites_list == null ? Possible.absent() :
          Possible.of(this.permissionOverwrites_list);
    }

    private List<PermissionOverwrite> permissionOverwrites_getOrCreate() {
      if (this.permissionOverwrites_list == null) {
        this.permissionOverwrites_list = new ArrayList<>();
      }
      return this.permissionOverwrites_list;
    }

    private Possible<Snowflake> parentId_build() {
      return this.parentId_possible;
    }
  }
}
