package discord4j.core.spec;

import com.google.errorprone.annotations.Var;
import discord4j.common.util.Snowflake;
import discord4j.core.object.PermissionOverwrite;
import discord4j.core.object.entity.Guild;
import discord4j.discordjson.possible.Possible;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.immutables.value.Generated;
import reactor.util.annotation.Nullable;

/**
 * Immutable implementation of {@link VoiceChannelCreateMonoGenerator}.
 * <p>
 * Use the static factory method to create immutable instances:
 * {@code VoiceChannelCreateMono.of()}.
 */
@Generated(from = "VoiceChannelCreateMonoGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class VoiceChannelCreateMono extends VoiceChannelCreateMonoGenerator {
  private final @Nullable String reason;
  private final String name;
  private final Integer bitrate_value;
  private final boolean bitrate_absent;
  private final Integer userLimit_value;
  private final boolean userLimit_absent;
  private final Integer position_value;
  private final boolean position_absent;
  private final List<PermissionOverwrite> permissionOverwrites_value;
  private final boolean permissionOverwrites_absent;
  private final Snowflake parentId_value;
  private final boolean parentId_absent;
  private final Guild guild;

  private VoiceChannelCreateMono(String name, Guild guild) {
    this.name = Objects.requireNonNull(name, "name");
    this.guild = Objects.requireNonNull(guild, "guild");
    this.reason = null;
    Possible<Integer> bitrate$impl = Possible.absent();
    Possible<Integer> userLimit$impl = Possible.absent();
    Possible<Integer> position$impl = Possible.absent();
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = Possible.absent();
    Possible<Snowflake> parentId$impl = Possible.absent();
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private VoiceChannelCreateMono(
      @Nullable String reason,
      String name,
      Possible<Integer> bitrate,
      Possible<Integer> userLimit,
      Possible<Integer> position,
      Possible<List<PermissionOverwrite>> permissionOverwrites,
      Possible<Snowflake> parentId,
      Guild guild) {
    this.reason = reason;
    this.name = name;
    Possible<Integer> bitrate$impl = bitrate;
    Possible<Integer> userLimit$impl = userLimit;
    Possible<Integer> position$impl = position;
    Possible<List<PermissionOverwrite>> permissionOverwrites$impl = permissionOverwrites;
    Possible<Snowflake> parentId$impl = parentId;
    this.guild = guild;
    this.bitrate_value = bitrate$impl.toOptional().orElse(null);
    this.bitrate_absent = bitrate$impl.isAbsent();
    this.userLimit_value = userLimit$impl.toOptional().orElse(null);
    this.userLimit_absent = userLimit$impl.isAbsent();
    this.position_value = position$impl.toOptional().orElse(null);
    this.position_absent = position$impl.isAbsent();
    this.permissionOverwrites_value = permissionOverwrites$impl.toOptional().orElse(null);
    this.permissionOverwrites_absent = permissionOverwrites$impl.isAbsent();
    this.parentId_value = parentId$impl.toOptional().orElse(null);
    this.parentId_absent = parentId$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "VoiceChannelCreateMonoGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build VoiceChannelCreateMono, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * Returns the current audit log reason set on the spec.
   * @return The current audit log reason.
   */
  @Override
  public @Nullable String reason() {
    return reason;
  }

  /**
   * @return The value of the {@code name} attribute
   */
  @Override
  public String name() {
    return name;
  }

  /**
   * @return The value of the {@code bitrate} attribute
   */
  @Override
  public Possible<Integer> bitrate() {
    return bitrate_absent ? Possible.absent() : Possible.of(bitrate_value);
  }

  /**
   * @return The value of the {@code userLimit} attribute
   */
  @Override
  public Possible<Integer> userLimit() {
    return userLimit_absent ? Possible.absent() : Possible.of(userLimit_value);
  }

  /**
   * @return The value of the {@code position} attribute
   */
  @Override
  public Possible<Integer> position() {
    return position_absent ? Possible.absent() : Possible.of(position_value);
  }

  /**
   * @return The value of the {@code permissionOverwrites} attribute
   */
  @Override
  public Possible<List<PermissionOverwrite>> permissionOverwrites() {
    return permissionOverwrites_absent ? Possible.absent() :
        Possible.of(permissionOverwrites_value);
  }

  /**
   * @return The value of the {@code parentId} attribute
   */
  @Override
  public Possible<Snowflake> parentId() {
    return parentId_absent ? Possible.absent() : Possible.of(parentId_value);
  }

  /**
   * @return The value of the {@code guild} attribute
   */
  @Override
  public Guild guild() {
    return guild;
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelCreateMono#reason() reason} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for reason (can be {@code null})
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelCreateMono withReason(@Nullable String value) {
    if (Objects.equals(this.reason, value)) return this;
    return new VoiceChannelCreateMono(
        value,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelCreateMono#name() name} attribute.
   * An equals check used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for name
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelCreateMono withName(String value) {
    String newValue = Objects.requireNonNull(value, "name");
    if (this.name.equals(newValue)) return this;
    return new VoiceChannelCreateMono(
        this.reason,
        newValue,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withBitrate(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withBitrate(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        newValue,
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withUserLimit(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withUserLimit(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        newValue,
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withPosition(Possible<Integer> value) {
    Possible<Integer> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withPosition(Integer value) {
    Possible<Integer> newValue = Possible.of(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        newValue,
        this.permissionOverwrites(),
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withPermissionOverwrites(Possible<List<PermissionOverwrite>> possible) {
    Possible<List<PermissionOverwrite>> newValue = Objects.requireNonNull(possible);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withPermissionOverwrites(Iterable<PermissionOverwrite> elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(
      StreamSupport.stream(Objects.requireNonNull(elements).spliterator(), false).collect(Collectors.toList()));
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.guild);
  }

  @SafeVarargs
  public final VoiceChannelCreateMono withPermissionOverwrites(PermissionOverwrite... elements) {
    Possible<List<PermissionOverwrite>> newValue = Possible.of(Arrays.asList(elements));
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        newValue,
        this.parentId(),
        this.guild);
  }

  public VoiceChannelCreateMono withParentId(Possible<Snowflake> value) {
    Possible<Snowflake> newValue = Objects.requireNonNull(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.guild);
  }

  public VoiceChannelCreateMono withParentId(Snowflake value) {
    Possible<Snowflake> newValue = Possible.of(value);
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        newValue,
        this.guild);
  }

  /**
   * Copy the current immutable object by setting a value for the {@link VoiceChannelCreateMono#guild() guild} attribute.
   * A shallow reference equality check is used to prevent copying of the same value by returning {@code this}.
   * @param value A new value for guild
   * @return A modified copy of the {@code this} object
   */
  public final VoiceChannelCreateMono withGuild(Guild value) {
    if (this.guild == value) return this;
    Guild newValue = Objects.requireNonNull(value, "guild");
    return new VoiceChannelCreateMono(
        this.reason,
        this.name,
        this.bitrate(),
        this.userLimit(),
        this.position(),
        this.permissionOverwrites(),
        this.parentId(),
        newValue);
  }

  /**
   * This instance is equal to all instances of {@code VoiceChannelCreateMono} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof VoiceChannelCreateMono
        && equalTo(0, (VoiceChannelCreateMono) another);
  }

  private boolean equalTo(int synthetic, VoiceChannelCreateMono another) {
    return Objects.equals(reason, another.reason)
        && name.equals(another.name)
        && this.bitrate().equals(another.bitrate())
        && this.userLimit().equals(another.userLimit())
        && this.position().equals(another.position())
        && Objects.equals(permissionOverwrites_value, another.permissionOverwrites_value)
        && this.parentId().equals(another.parentId())
        && guild.equals(another.guild);
  }

  /**
   * Computes a hash code from attributes: {@code reason}, {@code name}, {@code bitrate}, {@code userLimit}, {@code position}, {@code permissionOverwrites}, {@code parentId}, {@code guild}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + Objects.hashCode(reason);
    h += (h << 5) + name.hashCode();
    h += (h << 5) + (bitrate().hashCode());
    h += (h << 5) + (userLimit().hashCode());
    h += (h << 5) + (position().hashCode());
    h += (h << 5) + (Objects.hashCode(permissionOverwrites_value));
    h += (h << 5) + (parentId().hashCode());
    h += (h << 5) + guild.hashCode();
    return h;
  }

  /**
   * Prints the immutable value {@code VoiceChannelCreateMono} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "VoiceChannelCreateMono{"
        + "reason=" + reason
        + ", name=" + name
        + ", bitrate=" + (bitrate().toString())
        + ", userLimit=" + (userLimit().toString())
        + ", position=" + (position().toString())
        + ", permissionOverwrites=" + (Objects.toString(permissionOverwrites_value))
        + ", parentId=" + (parentId().toString())
        + ", guild=" + guild
        + "}";
  }

  /**
   * Construct a new immutable {@code VoiceChannelCreateMono} instance.
   * @param name The value for the {@code name} attribute
   * @param guild The value for the {@code guild} attribute
   * @return An immutable VoiceChannelCreateMono instance
   */
  public static VoiceChannelCreateMono of(String name, Guild guild) {
    return new VoiceChannelCreateMono(name, guild);
  }

  /**
   * Creates an immutable copy of a {@link VoiceChannelCreateMonoGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable VoiceChannelCreateMono instance
   */
  static VoiceChannelCreateMono copyOf(VoiceChannelCreateMonoGenerator instance) {
    if (instance instanceof VoiceChannelCreateMono) {
      return (VoiceChannelCreateMono) instance;
    }
    return VoiceChannelCreateMono.of(instance.name(), instance.guild())
        .withReason(instance.reason())
        .withBitrate(instance.bitrate())
        .withUserLimit(instance.userLimit())
        .withPosition(instance.position())
        .withPermissionOverwrites(instance.permissionOverwrites())
        .withParentId(instance.parentId());
  }

  public boolean isBitratePresent() {
    return !bitrate_absent;
  }

  public Integer bitrateOrElse(Integer defaultValue) {
    return !bitrate_absent ? bitrate_value : defaultValue;
  }

  public boolean isUserLimitPresent() {
    return !userLimit_absent;
  }

  public Integer userLimitOrElse(Integer defaultValue) {
    return !userLimit_absent ? userLimit_value : defaultValue;
  }

  public boolean isPositionPresent() {
    return !position_absent;
  }

  public Integer positionOrElse(Integer defaultValue) {
    return !position_absent ? position_value : defaultValue;
  }

  public boolean isPermissionOverwritesPresent() {
    return !permissionOverwrites_absent;
  }

  public List<PermissionOverwrite> permissionOverwritesOrElse(List<PermissionOverwrite> defaultValue) {
    return !permissionOverwrites_absent ? permissionOverwrites_value : defaultValue;
  }

  public boolean isParentIdPresent() {
    return !parentId_absent;
  }

  public Snowflake parentIdOrElse(Snowflake defaultValue) {
    return !parentId_absent ? parentId_value : defaultValue;
  }
}
