package discord4j.core.spec;

import com.google.errorprone.annotations.CanIgnoreReturnValue;
import com.google.errorprone.annotations.Var;
import discord4j.discordjson.possible.Possible;
import discord4j.rest.util.Image;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.immutables.value.Generated;

/**
 * Immutable implementation of {@link UserEditSpecGenerator}.
 * <p>
 * Use the builder to create immutable instances:
 * {@code UserEditSpec.builder()}.
 * Use the static factory method to get the default singleton instance:
 * {@code UserEditSpec.create()}.
 */
@Generated(from = "UserEditSpecGenerator", generator = "Immutables")
@SuppressWarnings({"all"})
@javax.annotation.processing.Generated("org.immutables.processor.ProxyProcessor")
public final class UserEditSpec implements UserEditSpecGenerator {
  private final String username_value;
  private final boolean username_absent;
  private final Image avatar_value;
  private final boolean avatar_absent;

  private UserEditSpec() {
    Possible<String> username$impl = Possible.absent();
    Possible<Image> avatar$impl = Possible.absent();
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private UserEditSpec(
      Possible<String> username,
      Possible<Image> avatar) {
    Possible<String> username$impl = username;
    Possible<Image> avatar$impl = avatar;
    this.username_value = username$impl.toOptional().orElse(null);
    this.username_absent = username$impl.isAbsent();
    this.avatar_value = avatar$impl.toOptional().orElse(null);
    this.avatar_absent = avatar$impl.isAbsent();
    this.initShim = null;
  }

  private static final byte STAGE_INITIALIZING = -1;
  private static final byte STAGE_UNINITIALIZED = 0;
  private static final byte STAGE_INITIALIZED = 1;
  @SuppressWarnings("Immutable")
  private transient volatile InitShim initShim = new InitShim();

  @Generated(from = "UserEditSpecGenerator", generator = "Immutables")
  private final class InitShim {
    private String formatInitCycleMessage() {
      List<String> attributes = new ArrayList<>();
      return "Cannot build UserEditSpec, attribute initializers form cycle " + attributes;
    }
  }

  /**
   * @return The value of the {@code username} attribute
   */
  @Override
  public Possible<String> username() {
    return username_absent ? Possible.absent() : Possible.of(username_value);
  }

  /**
   * @return The value of the {@code avatar} attribute
   */
  @Override
  public Possible<Image> avatar() {
    return avatar_absent ? Possible.absent() : Possible.of(avatar_value);
  }

  public UserEditSpec withUsername(Possible<String> value) {
    Possible<String> newValue = Objects.requireNonNull(value);
    return validate(new UserEditSpec(newValue, this.avatar()));
  }

  public UserEditSpec withUsername(String value) {
    Possible<String> newValue = Possible.of(value);
    return validate(new UserEditSpec(newValue, this.avatar()));
  }

  public UserEditSpec withAvatar(Possible<Image> value) {
    Possible<Image> newValue = Objects.requireNonNull(value);
    return validate(new UserEditSpec(this.username(), newValue));
  }

  public UserEditSpec withAvatar(Image value) {
    Possible<Image> newValue = Possible.of(value);
    return validate(new UserEditSpec(this.username(), newValue));
  }

  /**
   * This instance is equal to all instances of {@code UserEditSpec} that have equal attribute values.
   * @return {@code true} if {@code this} is equal to {@code another} instance
   */
  @Override
  public boolean equals(Object another) {
    if (this == another) return true;
    return another instanceof UserEditSpec
        && equalTo(0, (UserEditSpec) another);
  }

  private boolean equalTo(int synthetic, UserEditSpec another) {
    return this.username().equals(another.username())
        && this.avatar().equals(another.avatar());
  }

  /**
   * Computes a hash code from attributes: {@code username}, {@code avatar}.
   * @return hashCode value
   */
  @Override
  public int hashCode() {
    @Var int h = 5381;
    h += (h << 5) + (username().hashCode());
    h += (h << 5) + (avatar().hashCode());
    return h;
  }

  /**
   * Prints the immutable value {@code UserEditSpec} with attribute values.
   * @return A string representation of the value
   */
  @Override
  public String toString() {
    return "UserEditSpec{"
        + "username=" + (username().toString())
        + ", avatar=" + (avatar().toString())
        + "}";
  }

  private static final UserEditSpec INSTANCE = validate(new UserEditSpec());

  /**
   * Returns the default immutable singleton value of {@code UserEditSpec}
   * @return An immutable instance of UserEditSpec
   */
  public static UserEditSpec create() {
    return INSTANCE;
  }

  private static UserEditSpec validate(UserEditSpec instance) {
    return INSTANCE != null && INSTANCE.equalTo(0, instance) ? INSTANCE : instance;
  }

  /**
   * Creates an immutable copy of a {@link UserEditSpecGenerator} value.
   * Uses accessors to get values to initialize the new immutable instance.
   * If an instance is already immutable, it is returned as is.
   * @param instance The instance to copy
   * @return A copied immutable UserEditSpec instance
   */
  static UserEditSpec copyOf(UserEditSpecGenerator instance) {
    if (instance instanceof UserEditSpec) {
      return (UserEditSpec) instance;
    }
    return UserEditSpec.builder()
        .from(instance)
        .build();
  }

  public boolean isUsernamePresent() {
    return !username_absent;
  }

  public String usernameOrElse(String defaultValue) {
    return !username_absent ? username_value : defaultValue;
  }

  public boolean isAvatarPresent() {
    return !avatar_absent;
  }

  public Image avatarOrElse(Image defaultValue) {
    return !avatar_absent ? avatar_value : defaultValue;
  }

  /**
   * Creates a builder for {@link UserEditSpec UserEditSpec}.
   * <pre>
   * UserEditSpec.builder()
   *    .username(discord4j.discordjson.possible.Possible&amp;lt;String&amp;gt;) // {@link UserEditSpec#username() username}
   *    .avatar(discord4j.discordjson.possible.Possible&amp;lt;discord4j.rest.util.Image&amp;gt;) // {@link UserEditSpec#avatar() avatar}
   *    .build();
   * </pre>
   * @return A new UserEditSpec builder
   */
  public static UserEditSpec.Builder builder() {
    return new UserEditSpec.Builder();
  }

  /**
   * Builds instances of type {@link UserEditSpec UserEditSpec}.
   * Initialize attributes and then invoke the {@link #build()} method to create an
   * immutable instance.
   * <p><em>{@code Builder} is not thread-safe and generally should not be stored in a field or collection,
   * but instead used immediately to create instances.</em>
   */
  @Generated(from = "UserEditSpecGenerator", generator = "Immutables")
  public static final class Builder {
    private Possible<String> username_possible = Possible.absent();
    private Possible<Image> avatar_possible = Possible.absent();

    private Builder() {
    }

    /**
     * Fill a builder with attribute values from the provided {@code UserEditSpec} instance.
     * Regular attribute values will be replaced with those from the given instance.
     * Absent optional values will not replace present values.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    public final Builder from(UserEditSpec instance) {
      return from((UserEditSpecGenerator) instance);
    }

    /**
     * Copy abstract value type {@code UserEditSpecGenerator} instance into builder.
     * @param instance The instance from which to copy values
     * @return {@code this} builder for use in a chained invocation
     */
    @CanIgnoreReturnValue 
    final Builder from(UserEditSpecGenerator instance) {
      Objects.requireNonNull(instance, "instance");
      username(instance.username());
      avatar(instance.avatar());
      return this;
    }

    @CanIgnoreReturnValue
    public Builder username(Possible<String> value) {
      this.username_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder username(String value) {
      this.username_possible = Possible.of(value);
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatar(Possible<Image> value) {
      this.avatar_possible = value;
      return this;
    }

    @CanIgnoreReturnValue
    public Builder avatar(Image value) {
      this.avatar_possible = Possible.of(value);
      return this;
    }

    /**
     * Builds a new {@link UserEditSpec UserEditSpec}.
     * @return An immutable instance of UserEditSpec
     * @throws java.lang.IllegalStateException if any required attributes are missing
     */
    public UserEditSpec build() {
      return UserEditSpec.validate(new UserEditSpec(username_build(), avatar_build()));
    }

    private Possible<String> username_build() {
      return this.username_possible;
    }

    private Possible<Image> avatar_build() {
      return this.avatar_possible;
    }
  }
}
